/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.http;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.SimpleCredentials;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.http.AcceptHeader;
import org.apache.jackrabbit.oak.http.HtmlRepresentation;
import org.apache.jackrabbit.oak.http.JsonRepresentation;
import org.apache.jackrabbit.oak.http.PostRepresentation;
import org.apache.jackrabbit.oak.http.Representation;
import org.apache.jackrabbit.oak.http.TextRepresentation;
import org.apache.jackrabbit.util.Base64;
import org.apache.tika.mime.MediaType;

public class OakServlet
extends HttpServlet {
    private static final MediaType JSON = MediaType.parse((String)"application/json");
    private static final MediaType SMILE = MediaType.parse((String)"application/x-jackson-smile");
    private static final Representation[] REPRESENTATIONS = new Representation[]{new HtmlRepresentation(), new TextRepresentation(), new JsonRepresentation(JSON, new JsonFactory()), new JsonRepresentation(SMILE, (JsonFactory)new SmileFactory()), new PostRepresentation()};
    private final ContentRepository repository;

    public OakServlet(ContentRepository repository) {
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            SimpleCredentials credentials = null;
            String authorization = request.getHeader("Authorization");
            if (authorization == null || !authorization.startsWith("Basic ")) {
                throw new LoginException();
            }
            String[] basic = Base64.decode((String)authorization.substring("Basic ".length())).split(":");
            credentials = new SimpleCredentials(basic[0], basic[1].toCharArray());
            try (ContentSession session = this.repository.login((Credentials)credentials, null);){
                Root root = session.getLatestRoot();
                request.setAttribute("root", (Object)root);
                String head = request.getPathInfo();
                String tail = "";
                Tree tree = root.getTree(head);
                while (!tree.exists()) {
                    if (tree.isRoot()) {
                        response.sendError(404);
                        return;
                    }
                    tail = "/" + tree.getName() + tail;
                    tree = tree.getParent();
                }
                request.setAttribute("tree", (Object)tree);
                request.setAttribute("path", (Object)tail);
                super.service(request, response);
            }
        }
        catch (NoSuchWorkspaceException e) {
            response.sendError(404);
        }
        catch (LoginException e) {
            response.setHeader("WWW-Authenticate", "Basic realm=\"Oak\"");
            response.sendError(401);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AcceptHeader accept = new AcceptHeader(request.getHeader("Accept"));
        Representation representation = accept.resolve(REPRESENTATIONS);
        String path = (String)request.getAttribute("path");
        if (path.isEmpty()) {
            Tree tree = (Tree)request.getAttribute("tree");
            representation.render(tree, response);
        } else {
            response.sendError(404);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Root root = (Root)request.getAttribute("root");
            Tree tree = (Tree)request.getAttribute("tree");
            String path = (String)request.getAttribute("path");
            for (String name : PathUtils.elements((String)path)) {
                tree = tree.addChild(name);
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree((InputStream)request.getInputStream());
            if (node.isObject()) {
                OakServlet.post(node, tree);
                root.commit();
                request.setAttribute("path", (Object)"");
                request.setAttribute("tree", (Object)tree);
                this.doGet(request, response);
            } else {
                response.sendError(400);
            }
        }
        catch (CommitFailedException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private static void post(JsonNode node, Tree tree) {
        Iterator iterator = node.fields();
        while (iterator.hasNext()) {
            Tree child;
            Map.Entry entry = (Map.Entry)iterator.next();
            String name = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isObject()) {
                if (tree.hasProperty(name)) {
                    tree.removeProperty(name);
                }
                if (!(child = tree.getChild(name)).exists()) {
                    child = tree.addChild(name);
                }
                OakServlet.post(value, child);
                continue;
            }
            child = tree.getChild(name);
            if (child.exists()) {
                child.remove();
            }
            if (value.isNull()) {
                tree.removeProperty(name);
                continue;
            }
            if (value.isBoolean()) {
                tree.setProperty(name, (Object)value.asBoolean());
                continue;
            }
            if (value.isLong()) {
                tree.setProperty(name, (Object)value.asLong());
                continue;
            }
            if (value.isDouble()) {
                tree.setProperty(name, (Object)value.asDouble());
                continue;
            }
            if (value.isBigDecimal()) {
                tree.setProperty(name, (Object)value.decimalValue());
                continue;
            }
            tree.setProperty(name, (Object)value.asText());
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Root root = (Root)request.getAttribute("root");
            Tree tree = (Tree)request.getAttribute("tree");
            if (!tree.isRoot()) {
                Tree parent = tree.getParent();
                Tree child = parent.getChild(tree.getName());
                if (child.exists()) {
                    child.remove();
                }
                root.commit();
                response.sendError(200);
            } else {
                response.sendError(403);
            }
        }
        catch (CommitFailedException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

