/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.exercise.security.authorization.models.simplifiedroles;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.exercise.security.authorization.models.simplifiedroles.Role;
import org.apache.jackrabbit.oak.exercise.security.authorization.models.simplifiedroles.ThreeRolesConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

class ThreeRolesTreePermission
implements TreePermission,
ThreeRolesConstants {
    private final Role role;
    private final boolean isAcContent;

    ThreeRolesTreePermission(@NotNull Role role, boolean isAcContent) {
        this.role = role;
        this.isAcContent = isAcContent;
    }

    @NotNull
    Role getRole() {
        return this.role;
    }

    @NotNull
    public TreePermission getChildPermission(@NotNull String childName, @NotNull NodeState childState) {
        if (this.isAcContent) {
            return this;
        }
        return new ThreeRolesTreePermission(this.role, "rep:threeRolesPolicy".equals(childName));
    }

    public boolean canRead() {
        if (this.isAcContent) {
            return this.isGranted(128L);
        }
        return this.isGranted(3L);
    }

    public boolean canRead(@NotNull PropertyState property) {
        return this.canRead();
    }

    public boolean canReadAll() {
        return false;
    }

    public boolean canReadProperties() {
        return this.canRead();
    }

    public boolean isGranted(long permissions) {
        return this.role.grants(permissions);
    }

    public boolean isGranted(long permissions, @NotNull PropertyState property) {
        return this.isGranted(permissions);
    }
}

