/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.exercise.security.authorization.models.simplifiedroles;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.security.Principal;
import java.util.Collection;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.exercise.security.authorization.models.simplifiedroles.Role;
import org.apache.jackrabbit.oak.exercise.security.authorization.models.simplifiedroles.ThreeRolesConstants;
import org.apache.jackrabbit.oak.exercise.security.authorization.models.simplifiedroles.ThreeRolesTreePermission;
import org.apache.jackrabbit.oak.exercise.security.authorization.models.simplifiedroles.Utils;
import org.apache.jackrabbit.oak.plugins.tree.ReadOnly;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ThreeRolesPermissionProvider
implements AggregatedPermissionProvider,
ThreeRolesConstants {
    private static final PrivilegeBits SUPPORTED_PRIVBITS = PrivilegeBits.getInstance((PrivilegeBits[])new PrivilegeBits[]{(PrivilegeBits)PrivilegeBits.BUILT_IN.get("jcr:read"), (PrivilegeBits)PrivilegeBits.BUILT_IN.get("rep:write"), (PrivilegeBits)PrivilegeBits.BUILT_IN.get("jcr:versionManagement"), (PrivilegeBits)PrivilegeBits.BUILT_IN.get("jcr:readAccessControl"), (PrivilegeBits)PrivilegeBits.BUILT_IN.get("jcr:modifyAccessControl")});
    private final Root root;
    private final Set<String> principalNames;
    private final String supportedPath;
    private final Context ctx;
    private final RootProvider rootProvider;
    private Root readOnlyRoot;

    ThreeRolesPermissionProvider(@NotNull Root root, Set<Principal> principals, @NotNull String supportedPath, @NotNull Context ctx, @NotNull RootProvider rootProvider) {
        this.root = root;
        this.principalNames = ImmutableSet.copyOf((Iterable)Iterables.transform(principals, Principal::getName));
        this.supportedPath = supportedPath;
        this.ctx = ctx;
        this.rootProvider = rootProvider;
        this.readOnlyRoot = rootProvider.createReadOnlyRoot(root);
    }

    @NotNull
    public PrivilegeBits supportedPrivileges(@Nullable Tree tree, @Nullable PrivilegeBits privilegeBits) {
        PrivilegeBits pb;
        if (tree == null) {
            return PrivilegeBits.EMPTY;
        }
        if (privilegeBits == null) {
            pb = SUPPORTED_PRIVBITS;
        } else {
            pb = PrivilegeBits.getInstance((PrivilegeBits[])new PrivilegeBits[]{privilegeBits});
            pb.retain(SUPPORTED_PRIVBITS);
        }
        if (pb.isEmpty() || !Utils.isSupportedPath(this.supportedPath, tree.getPath())) {
            return PrivilegeBits.EMPTY;
        }
        return pb;
    }

    public long supportedPermissions(@Nullable Tree tree, @Nullable PropertyState property, long permissions) {
        if (tree == null) {
            return 0L;
        }
        long supported = permissions & 0x47FFL;
        if (supported != 0L && Utils.isSupportedPath(this.supportedPath, tree.getPath())) {
            return supported;
        }
        return 0L;
    }

    public long supportedPermissions(@NotNull TreeLocation location, long permissions) {
        long supported = permissions & 0x47FFL;
        if (supported != 0L && Utils.isSupportedPath(this.supportedPath, location.getPath())) {
            return supported;
        }
        return 0L;
    }

    public long supportedPermissions(@NotNull TreePermission treePermission, @Nullable PropertyState property, long permissions) {
        long supported = permissions & 0x47FFL;
        if (supported != 0L && treePermission instanceof ThreeRolesTreePermission) {
            return supported;
        }
        return 0L;
    }

    public boolean isGranted(@NotNull TreeLocation location, long permissions) {
        if (Utils.isSupportedPath(this.supportedPath, location.getPath())) {
            TreePermission tp = this.getTreePermission(location);
            PropertyState property = location.getProperty();
            return property == null ? tp.isGranted(permissions) : tp.isGranted(permissions, property);
        }
        return false;
    }

    @NotNull
    public TreePermission getTreePermission(@NotNull Tree tree, @NotNull TreeType type, @NotNull TreePermission parentPermission) {
        return this.getTreePermission(tree, parentPermission);
    }

    public void refresh() {
        this.readOnlyRoot = this.rootProvider.createReadOnlyRoot(this.root);
    }

    @NotNull
    public Set<String> getPrivileges(@Nullable Tree tree) {
        TreePermission tp;
        if (tree != null && (tp = this.getTreePermission(this.getReadOnlyTree(tree))) instanceof ThreeRolesTreePermission) {
            return ((ThreeRolesTreePermission)tp).getRole().getPrivilegeNames();
        }
        return ImmutableSet.of();
    }

    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        return this.getPrivileges(tree).containsAll((Collection<?>)ImmutableSet.copyOf((Object[])privilegeNames));
    }

    @NotNull
    public RepositoryPermission getRepositoryPermission() {
        return RepositoryPermission.EMPTY;
    }

    @NotNull
    public TreePermission getTreePermission(@NotNull Tree tree, @NotNull TreePermission parentPermission) {
        if (parentPermission instanceof ThreeRolesTreePermission) {
            return parentPermission;
        }
        String path = tree.getPath();
        if (Utils.isSupportedPath(this.supportedPath, path)) {
            Tree t = this.getReadOnlyTree(tree);
            if (t.hasChild("rep:threeRolesPolicy")) {
                return new ThreeRolesTreePermission(this.getRole(t), this.ctx.definesContextRoot(t));
            }
            return TreePermission.EMPTY;
        }
        if (this.isAncestor(path)) {
            return TreePermission.EMPTY;
        }
        return TreePermission.NO_RECOURSE;
    }

    public boolean isGranted(@NotNull Tree tree, @Nullable PropertyState property, long permissions) {
        if (Utils.isSupportedPath(this.supportedPath, tree.getPath())) {
            TreePermission tp = this.getTreePermission(tree);
            return property == null ? tp.isGranted(permissions) : tp.isGranted(permissions, property);
        }
        return false;
    }

    public boolean isGranted(@NotNull String oakPath, @NotNull String jcrActions) {
        TreeLocation tl = TreeLocation.create((Root)this.readOnlyRoot, (String)oakPath);
        long permissions = Permissions.getPermissions((String)jcrActions, (TreeLocation)tl, (boolean)this.ctx.definesLocation(tl));
        return this.isGranted(tl, permissions);
    }

    private boolean isAncestor(@NotNull String path) {
        return Text.isDescendant((String)path, (String)this.supportedPath);
    }

    private Role getRole(@NotNull Tree tree) {
        Tree policy = tree.getChild("rep:threeRolesPolicy");
        if (policy.exists()) {
            if (this.containsAny(policy, "rep:owners")) {
                return Role.OWNER;
            }
            if (this.containsAny(policy, "rep:editors")) {
                return Role.EDITOR;
            }
            if (this.containsAny(policy, "rep:readers")) {
                return Role.READER;
            }
        }
        return Role.NONE;
    }

    private boolean containsAny(@NotNull Tree policyTree, @NotNull String propName) {
        Iterable names = TreeUtil.getStrings((Tree)policyTree, (String)propName);
        if (names != null) {
            for (String principalName : names) {
                if (!this.principalNames.contains(principalName)) continue;
                return true;
            }
        }
        return false;
    }

    private Tree getReadOnlyTree(@NotNull Tree tree) {
        if (tree instanceof ReadOnly) {
            return tree;
        }
        return this.readOnlyRoot.getTree(tree.getPath());
    }

    private TreePermission getTreePermission(@NotNull Tree readOnlyTree) {
        Tree t = readOnlyTree;
        while (Utils.isSupportedPath(this.supportedPath, t.getPath())) {
            if (t.hasChild("rep:threeRolesPolicy")) {
                return new ThreeRolesTreePermission(this.getRole(t), this.ctx.definesContextRoot(t));
            }
            t = t.getParent();
        }
        return TreePermission.EMPTY;
    }

    private TreePermission getTreePermission(@NotNull TreeLocation location) {
        TreeLocation l = location;
        while (Utils.isSupportedPath(this.supportedPath, l.getPath())) {
            Tree tree = location.getTree();
            if (tree != null) {
                return this.getTreePermission(this.getReadOnlyTree(tree));
            }
            l = l.getParent();
        }
        return TreePermission.EMPTY;
    }
}

