/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.hash;

public class SipHash {
    private final long v0;
    private final long v1;
    private final long v2;
    private final long v3;

    public SipHash(long seed) {
        long k0 = seed;
        long k1 = Long.rotateLeft(seed, 32);
        this.v0 = k0 ^ 0x736F6D6570736575L;
        this.v1 = k1 ^ 0x646F72616E646F6DL;
        this.v2 = k0 ^ 0x6C7967656E657261L;
        this.v3 = k1 ^ 0x7465646279746573L;
    }

    public SipHash(SipHash parent, long m) {
        long v0 = parent.v0;
        long v1 = parent.v1;
        long v2 = parent.v2;
        long v3 = parent.v3;
        int repeat = 2;
        for (int i = 0; i < repeat; ++i) {
            v0 += v1;
            v2 += v3;
            v1 = Long.rotateLeft(v1, 13);
            v3 = Long.rotateLeft(v3, 16);
            v1 ^= v0;
            v3 ^= v2;
            v0 = Long.rotateLeft(v0, 32);
            v2 += v1;
            v0 += v3;
            v1 = Long.rotateLeft(v1, 17);
            v3 = Long.rotateLeft(v3, 21);
            v1 ^= v2;
            v3 ^= v0;
            v2 = Long.rotateLeft(v2, 32);
        }
        this.v0 = v0 ^= m;
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
    }

    public int hashCode() {
        long x = this.v0 ^ this.v1 ^ this.v2 ^ this.v3;
        return (int)(x ^ x >>> 16);
    }
}

