/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class Cache<K, V extends Value> {
    int maxMemoryBytes;
    AtomicInteger memoryUsed = new AtomicInteger();
    private final Backend<K, V> backend;
    private final Map<K, V> map = new LinkedHashMap<K, V>(1024, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            if (Cache.this.memoryUsed.get() < Cache.this.maxMemoryBytes) {
                return false;
            }
            int memory = ((Value)eldest.getValue()).getMemory();
            Cache.this.memoryUsed.addAndGet(-memory);
            return true;
        }
    };

    private Cache(Backend<K, V> backend, int maxMemoryBytes) {
        this.backend = backend;
        this.maxMemoryBytes = maxMemoryBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        int memory = value.getMemory();
        if (memory < this.maxMemoryBytes / 2) {
            this.memoryUsed.addAndGet(memory);
            Map<K, V> map = this.map;
            synchronized (map) {
                this.map.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V replace(K key, V value) {
        Map<K, V> map = this.map;
        synchronized (map) {
            if (this.map.containsKey(key)) {
                return (V)((Value)this.map.get(key));
            }
        }
        this.put(key, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Value value;
        Object object = this.map;
        synchronized (object) {
            value = (Value)this.map.get(key);
            if (value != null) {
                return (V)value;
            }
        }
        object = this.backend;
        synchronized (object) {
            Map<K, V> map = this.map;
            synchronized (map) {
                value = (Value)this.map.get(key);
            }
            if (value == null) {
                value = (Value)this.backend.load(key);
                this.put(key, value);
            }
            return (V)value;
        }
    }

    public static <K, V extends Value> Cache<K, V> newInstance(Backend<K, V> backend, int maxMemoryBytes) {
        return new Cache<K, V>(backend, maxMemoryBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<K, V> map = this.map;
        synchronized (map) {
            this.map.clear();
        }
    }

    public int size() {
        return this.map.size();
    }

    public int getMemoryUsed() {
        return this.memoryUsed.get();
    }

    public int getMemoryMax() {
        return this.maxMemoryBytes;
    }

    public static interface Backend<K, V> {
        public V load(K var1);
    }

    public static interface Value {
        public int getMemory();
    }
}

