/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.oak.plugins.blob.DataStoreCacheUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreCacheUpgradeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DataStoreCacheUpgradeUtils.class);
    static final String UPLOAD_MAP = "async-pending-uploads.ser";
    static final String UPLOAD_STAGING_DIR = "upload";
    static final String DOWNLOAD_DIR = "download";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Long> deSerializeUploadMap(File homeDir) {
        Map asyncUploadMap;
        block4: {
            asyncUploadMap = Maps.newHashMap();
            File asyncUploadMapFile = new File(homeDir, UPLOAD_MAP);
            if (!asyncUploadMapFile.exists()) break block4;
            String path = asyncUploadMapFile.getAbsolutePath();
            BufferedInputStream fis = null;
            try {
                fis = new BufferedInputStream(new FileInputStream(path));
                ObjectInputStream input = new ObjectInputStream(fis);
                asyncUploadMap = (Map)input.readObject();
            }
            catch (Exception e) {
                try {
                    LOG.warn("Error in reading pending uploads map [{}] from location [{}]", (Object)UPLOAD_MAP, (Object)homeDir);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
            IOUtils.closeQuietly((InputStream)fis);
            LOG.debug("AsyncUploadMap read [{}]", (Object)asyncUploadMap);
        }
        return asyncUploadMap;
    }

    private static void deleteSerializedUploadMap(File homeDir) {
        File uploadMap = new File(homeDir, UPLOAD_MAP);
        FileUtils.deleteQuietly((File)uploadMap);
        LOG.info("Deleted asyncUploadMap [{}] from [{}]", (Object)UPLOAD_MAP, (Object)homeDir);
    }

    private static boolean notInExceptions(File file, List<String> exceptions) {
        String parent = file.getParent();
        for (String exception : exceptions) {
            if (!parent.contains(exception)) continue;
            return true;
        }
        return false;
    }

    public static void moveDownloadCache(final File path) {
        ImmutableList exceptions = ImmutableList.of((Object)"tmp", (Object)UPLOAD_STAGING_DIR, (Object)DOWNLOAD_DIR);
        File newDownloadDir = new File(path, DOWNLOAD_DIR);
        for (File download : Files.fileTreeTraverser().postOrderTraversal((Object)path).filter((Predicate)new Predicate<File>((List)exceptions){
            final /* synthetic */ List val$exceptions;
            {
                this.val$exceptions = list;
            }

            public boolean apply(File input) {
                return input.isFile() && !input.getParentFile().equals(path) && !DataStoreCacheUpgradeUtils.notInExceptions(input, this.val$exceptions);
            }
        })) {
            LOG.trace("Download cache file absolute pre-upgrade path " + download);
            File newDownload = new File(newDownloadDir, download.getAbsolutePath().substring(path.getAbsolutePath().length()));
            newDownload.getParentFile().mkdirs();
            LOG.trace("Downloaded cache file absolute post-upgrade path " + newDownload);
            try {
                FileUtils.moveFile((File)download, (File)newDownload);
                LOG.info("Download cache file [{}] moved to [{}]", (Object)download, (Object)newDownload);
                DataStoreCacheUtils.recursiveDelete(download, path);
            }
            catch (Exception e) {
                LOG.warn("Unable to move download cache file [{}] to [{}]", (Object)download, (Object)newDownload);
            }
        }
    }

    public static void movePendingUploadsToStaging(File homeDir, File path, boolean deleteMap) {
        File newUploadDir = new File(path, UPLOAD_STAGING_DIR);
        if (homeDir != null && homeDir.exists()) {
            Map<String, Long> pendingUploads = DataStoreCacheUpgradeUtils.deSerializeUploadMap(homeDir);
            for (String file : pendingUploads.keySet()) {
                File upload = new File(path, file);
                LOG.trace("Pending upload absolute path " + upload.getAbsolutePath());
                File newUpload = new File(newUploadDir, file);
                LOG.trace("Pending upload upgrade absolute path " + newUpload.getAbsolutePath());
                newUpload.getParentFile().mkdirs();
                if (upload.exists()) {
                    LOG.trace(upload + " File exists");
                    try {
                        FileUtils.moveFile((File)upload, (File)newUpload);
                        LOG.info("Pending upload file [{}] moved to [{}]", (Object)upload, (Object)newUpload);
                        DataStoreCacheUtils.recursiveDelete(upload, path);
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to move pending upload file [{}] to [{}]", (Object)upload, (Object)newUpload);
                    }
                    continue;
                }
                LOG.warn("File [{}] does not exist", (Object)upload);
            }
            if (deleteMap) {
                DataStoreCacheUpgradeUtils.deleteSerializedUploadMap(homeDir);
            }
        }
    }

    public static void upgrade(File homeDir, File path, boolean moveCache, boolean deleteMap) {
        DataStoreCacheUpgradeUtils.movePendingUploadsToStaging(homeDir, path, deleteMap);
        if (moveCache) {
            DataStoreCacheUpgradeUtils.moveDownloadCache(path);
        }
    }
}

