/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.HttpMethod;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.model.BucketAccelerateConfiguration;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GetBucketAccelerateConfigurationRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.PartSummary;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.Copy;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import com.amazonaws.util.StringUtils;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.util.NamedThreadFactory;
import org.apache.jackrabbit.oak.blob.cloud.s3.S3RequestDecorator;
import org.apache.jackrabbit.oak.blob.cloud.s3.Utils;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordDownloadOptions;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUpload;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUploadException;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUploadToken;
import org.apache.jackrabbit.oak.spi.blob.AbstractDataRecord;
import org.apache.jackrabbit.oak.spi.blob.AbstractSharedBackend;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Backend
extends AbstractSharedBackend {
    private static final Logger LOG = LoggerFactory.getLogger(S3Backend.class);
    private static final String KEY_PREFIX = "dataStore_";
    private static final String META_KEY_PREFIX = "META/";
    private static final String REF_KEY = "reference.key";
    private static final int MAX_UNIQUE_RECORD_TRIES = 10;
    static final String PART_NUMBER = "partNumber";
    static final String UPLOAD_ID = "uploadId";
    private static final int ONE_MB = 0x100000;
    static final long MIN_MULTIPART_UPLOAD_PART_SIZE = 0xA00000L;
    static final long MAX_MULTIPART_UPLOAD_PART_SIZE = 0x10000000L;
    static final long MAX_SINGLE_PUT_UPLOAD_SIZE = 0x140000000L;
    static final long MAX_BINARY_UPLOAD_SIZE = 0x50000000000L;
    private static final int MAX_ALLOWABLE_UPLOAD_URIS = 10000;
    private AmazonS3Client s3service;
    private AmazonS3Client s3PresignService;
    private String bucket;
    private byte[] secret;
    private TransferManager tmx;
    private Properties properties;
    private Date startTime;
    private S3RequestDecorator s3ReqDecorator;
    private Cache<DataIdentifier, URI> httpDownloadURICache;
    private int httpUploadURIExpirySeconds = 0;
    private int httpDownloadURIExpirySeconds = 0;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() throws DataStoreException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String enablePresignedAccelerationStr;
            String getExpiry;
            String putExpiry;
            String region;
            this.startTime = new Date();
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            LOG.debug("init");
            this.s3ReqDecorator = new S3RequestDecorator(this.properties);
            this.s3PresignService = this.s3service = Utils.openService(this.properties);
            if (this.bucket == null || "".equals(this.bucket.trim())) {
                this.bucket = this.properties.getProperty("s3Bucket");
                if (Strings.isNullOrEmpty((String)this.bucket)) {
                    this.bucket = this.properties.getProperty("container");
                }
            }
            if (StringUtils.isNullOrEmpty((String)(region = this.properties.getProperty("s3Region")))) {
                Region ec2Region = Regions.getCurrentRegion();
                if (ec2Region == null) throw new AmazonClientException("parameter [s3Region] not configured and cannot be derived from environment");
                com.amazonaws.services.s3.model.Region region2 = com.amazonaws.services.s3.model.Region.fromValue((String)ec2Region.getName());
            } else if ("us-standard".equals(region)) {
                com.amazonaws.services.s3.model.Region region3 = com.amazonaws.services.s3.model.Region.US_Standard;
            } else if (com.amazonaws.services.s3.model.Region.EU_Ireland.toString().equals(region)) {
                com.amazonaws.services.s3.model.Region region4 = com.amazonaws.services.s3.model.Region.EU_Ireland;
            } else {
                com.amazonaws.services.s3.model.Region region5 = com.amazonaws.services.s3.model.Region.fromValue((String)region);
            }
            if (!this.s3service.doesBucketExist(this.bucket)) {
                void var3_10;
                this.s3service.createBucket(this.bucket, (com.amazonaws.services.s3.model.Region)var3_10);
                LOG.info("Created bucket [{}] in [{}] ", (Object)this.bucket, (Object)region);
            } else {
                LOG.info("Using bucket [{}] in [{}] ", (Object)this.bucket, (Object)region);
            }
            int writeThreads = 10;
            String writeThreadsStr = this.properties.getProperty("writeThreads");
            if (writeThreadsStr != null) {
                writeThreads = Integer.parseInt(writeThreadsStr);
            }
            LOG.info("Using thread pool of [{}] threads in S3 transfer manager.", (Object)writeThreads);
            this.tmx = new TransferManager((AmazonS3)this.s3service, Executors.newFixedThreadPool(writeThreads, (ThreadFactory)new NamedThreadFactory("s3-transfer-manager-worker")));
            String renameKeyProp = this.properties.getProperty("s3RenameKeys");
            boolean renameKeyBool = renameKeyProp == null || "".equals(renameKeyProp) ? false : Boolean.parseBoolean(renameKeyProp);
            LOG.info("Rename keys [{}]", (Object)renameKeyBool);
            if (renameKeyBool) {
                this.renameKeys();
            }
            if ((putExpiry = this.properties.getProperty("presignedHttpUploadURIExpirySeconds")) != null) {
                this.setHttpUploadURIExpirySeconds(Integer.parseInt(putExpiry));
            }
            if ((getExpiry = this.properties.getProperty("presignedHttpDownloadURIExpirySeconds")) != null) {
                int getExpirySeconds = Integer.parseInt(getExpiry);
                this.setHttpDownloadURIExpirySeconds(getExpirySeconds);
                int cacheMaxSize = 0;
                String cacheMaxSizeStr = this.properties.getProperty("presignedHttpDownloadURICacheMaxSize");
                if (cacheMaxSizeStr != null) {
                    cacheMaxSize = Integer.parseInt(cacheMaxSizeStr);
                }
                this.setHttpDownloadURICacheSize(cacheMaxSize);
            }
            this.setBinaryTransferAccelerationEnabled((enablePresignedAccelerationStr = this.properties.getProperty("presignedURIEnableTransferAcceleration")) != null && "true".equals(enablePresignedAccelerationStr));
            LOG.debug("S3 Backend initialized in [{}] ms", (Object)(System.currentTimeMillis() - this.startTime.getTime()));
            return;
        }
        catch (Exception e) {
            void var3_13;
            LOG.error("Error ", (Throwable)e);
            HashMap hashMap = Maps.newHashMap();
            if (this.properties == null) throw new DataStoreException("Could not initialize S3 from " + var3_13, (Throwable)e);
            Map map = Maps.filterKeys(Utils.asMap(this.properties), (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return !input.equals("accessKey") && !input.equals("secretKey");
                }
            });
            throw new DataStoreException("Could not initialize S3 from " + var3_13, (Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    void setBinaryTransferAccelerationEnabled(boolean enabled) {
        if (enabled) {
            BucketAccelerateConfiguration accelerateConfig = this.s3service.getBucketAccelerateConfiguration(new GetBucketAccelerateConfigurationRequest(this.bucket));
            if (accelerateConfig.isAccelerateEnabled()) {
                this.s3PresignService = Utils.openService(this.properties);
                this.s3PresignService.setS3ClientOptions(S3ClientOptions.builder().setAccelerateModeEnabled(true).build());
                LOG.info("S3 Transfer Acceleration enabled for presigned URIs.");
            } else {
                LOG.warn("S3 Transfer Acceleration is not enabled on the bucket {}. Will create normal, non-accelerated presigned URIs.", (Object)this.bucket, (Object)"presignedURIEnableTransferAcceleration");
            }
        } else {
            this.s3PresignService = this.s3service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataIdentifier identifier, File file) throws DataStoreException {
        long start;
        block13: {
            String key = S3Backend.getKeyName(identifier);
            ObjectMetadata objectMetaData = null;
            start = System.currentTimeMillis();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                block12: {
                    Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                    try {
                        objectMetaData = this.s3service.getObjectMetadata(this.bucket, key);
                    }
                    catch (AmazonServiceException ase) {
                        if (ase.getStatusCode() == 404 || ase.getStatusCode() == 403) break block12;
                        throw ase;
                    }
                }
                if (objectMetaData != null) {
                    long l = objectMetaData.getContentLength();
                    if (l != file.length()) {
                        throw new DataStoreException("Collision: " + key + " new length: " + file.length() + " old length: " + l);
                    }
                    LOG.debug("[{}]'s exists, lastmodified = [{}]", (Object)key, (Object)objectMetaData.getLastModified().getTime());
                    CopyObjectRequest copReq = new CopyObjectRequest(this.bucket, key, this.bucket, key);
                    copReq.setNewObjectMetadata(objectMetaData);
                    Copy copy = this.tmx.copy(this.s3ReqDecorator.decorate(copReq));
                    try {
                        copy.waitForCopyResult();
                        LOG.debug("lastModified of [{}] updated successfully.", (Object)identifier);
                    }
                    catch (Exception e2) {
                        throw new DataStoreException("Could not upload " + key, (Throwable)e2);
                    }
                }
                if (objectMetaData != null) break block13;
                try {
                    Upload up = this.tmx.upload(this.s3ReqDecorator.decorate(new PutObjectRequest(this.bucket, key, file)));
                    up.waitForUploadResult();
                    LOG.debug("synchronous upload to identifier [{}] completed.", (Object)identifier);
                }
                catch (Exception e2) {
                    throw new DataStoreException("Could not upload " + key, (Throwable)e2);
                }
            }
            finally {
                if (contextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
            }
        }
        LOG.debug("write of [{}], length=[{}], in [{}]ms", new Object[]{identifier, file.length(), System.currentTimeMillis() - start});
    }

    public boolean exists(DataIdentifier identifier) throws DataStoreException {
        long start = System.currentTimeMillis();
        String key = S3Backend.getKeyName(identifier);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            ObjectMetadata objectMetaData = this.s3service.getObjectMetadata(this.bucket, key);
            if (objectMetaData != null) {
                LOG.trace("exists [{}]: [true] took [{}] ms.", (Object)identifier, (Object)(System.currentTimeMillis() - start));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404 || e.getStatusCode() == 403) {
                LOG.debug("exists [{}]: [false] took [{}] ms.", (Object)identifier, (Object)(System.currentTimeMillis() - start));
                boolean bl = false;
                return bl;
            }
            throw new DataStoreException("Error occured to getObjectMetadata for key [" + identifier.toString() + "]", (Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public InputStream read(DataIdentifier identifier) throws DataStoreException {
        long start = System.currentTimeMillis();
        String key = S3Backend.getKeyName(identifier);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            S3Object object = this.s3service.getObject(this.bucket, key);
            S3ObjectInputStream in = object.getObjectContent();
            LOG.debug("[{}] read took [{}]ms", (Object)identifier, (Object)(System.currentTimeMillis() - start));
            if (LOG.isDebugEnabled()) {
                LOG.debug("binary downloaded from S3: " + identifier, (Throwable)new Exception());
            }
            S3ObjectInputStream s3ObjectInputStream = in;
            return s3ObjectInputStream;
        }
        catch (AmazonServiceException e) {
            throw new DataStoreException("Object not found: " + key, (Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        return new RecordsIterator<DataIdentifier>(new Function<S3ObjectSummary, DataIdentifier>(){

            public DataIdentifier apply(S3ObjectSummary input) {
                return new DataIdentifier(S3Backend.getIdentifierName(input.getKey()));
            }
        });
    }

    public void deleteRecord(DataIdentifier identifier) throws DataStoreException {
        long start = System.currentTimeMillis();
        String key = S3Backend.getKeyName(identifier);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.s3service.deleteObject(this.bucket, key);
            LOG.debug("Identifier [{}] deleted. It took [{}]ms.", new Object[]{identifier, System.currentTimeMillis() - start});
        }
        catch (AmazonServiceException e) {
            throw new DataStoreException("Could not delete dataIdentifier " + identifier, (Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public void close() {
        if (this.s3service.doesBucketExist(this.bucket)) {
            this.tmx.abortMultipartUploads(this.bucket, this.startTime);
        }
        this.tmx.shutdownNow();
        this.s3service.shutdown();
        LOG.info("S3Backend closed.");
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void addMetadataRecord(InputStream input, String name) throws DataStoreException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Upload upload = this.tmx.upload(this.s3ReqDecorator.decorate(new PutObjectRequest(this.bucket, S3Backend.addMetaKeyPrefix(name), input, new ObjectMetadata())));
            upload.waitForUploadResult();
        }
        catch (InterruptedException e) {
            LOG.error("Error in uploading", (Throwable)e);
            throw new DataStoreException("Error in uploading", (Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public void addMetadataRecord(File input, String name) throws DataStoreException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Upload upload = this.tmx.upload(this.s3ReqDecorator.decorate(new PutObjectRequest(this.bucket, S3Backend.addMetaKeyPrefix(name), input)));
            upload.waitForUploadResult();
        }
        catch (InterruptedException e) {
            LOG.error("Exception in uploading metadata file {}", new Object[]{input, e});
            throw new DataStoreException("Error in uploading metadata file", (Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRecord getMetadataRecord(String name) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            ObjectMetadata meta = this.s3service.getObjectMetadata(this.bucket, S3Backend.addMetaKeyPrefix(name));
            S3DataRecord s3DataRecord = new S3DataRecord(this, this.s3service, this.bucket, new DataIdentifier(name), meta.getLastModified().getTime(), meta.getContentLength(), true);
            return s3DataRecord;
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataRecord> getAllMetadataRecords(String prefix) {
        ArrayList<DataRecord> metadataList = new ArrayList<DataRecord>();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucket).withPrefix(S3Backend.addMetaKeyPrefix(prefix));
            ObjectListing prevObjectListing = this.s3service.listObjects(listObjectsRequest);
            for (S3ObjectSummary s3ObjSumm : prevObjectListing.getObjectSummaries()) {
                metadataList.add((DataRecord)new S3DataRecord(this, this.s3service, this.bucket, new DataIdentifier(S3Backend.stripMetaKeyPrefix(s3ObjSumm.getKey())), s3ObjSumm.getLastModified().getTime(), s3ObjSumm.getSize(), true));
            }
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        return metadataList;
    }

    public boolean deleteMetadataRecord(String name) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.s3service.deleteObject(this.bucket, S3Backend.addMetaKeyPrefix(name));
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllMetadataRecords(String prefix) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucket).withPrefix(S3Backend.addMetaKeyPrefix(prefix));
            ObjectListing metaList = this.s3service.listObjects(listObjectsRequest);
            ArrayList<DeleteObjectsRequest.KeyVersion> deleteList = new ArrayList<DeleteObjectsRequest.KeyVersion>();
            for (S3ObjectSummary s3ObjSumm : metaList.getObjectSummaries()) {
                deleteList.add(new DeleteObjectsRequest.KeyVersion(s3ObjSumm.getKey()));
            }
            if (deleteList.size() > 0) {
                DeleteObjectsRequest delObjsReq = new DeleteObjectsRequest(this.bucket);
                delObjsReq.setKeys(deleteList);
                this.s3service.deleteObjects(delObjsReq);
            }
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public Iterator<DataRecord> getAllRecords() {
        final S3Backend backend = this;
        return new RecordsIterator<DataRecord>(new Function<S3ObjectSummary, DataRecord>(){

            public DataRecord apply(S3ObjectSummary input) {
                return new S3DataRecord(backend, S3Backend.this.s3service, S3Backend.this.bucket, new DataIdentifier(S3Backend.getIdentifierName(input.getKey())), input.getLastModified().getTime(), input.getSize());
            }
        });
    }

    public DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        long start = System.currentTimeMillis();
        String key = S3Backend.getKeyName(identifier);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            ObjectMetadata object = this.s3service.getObjectMetadata(this.bucket, key);
            S3DataRecord record = new S3DataRecord(this, this.s3service, this.bucket, identifier, object.getLastModified().getTime(), object.getContentLength());
            LOG.debug("Identifier [{}]'s getRecord = [{}] took [{}]ms.", new Object[]{identifier, record, System.currentTimeMillis() - start});
            S3DataRecord s3DataRecord = record;
            return s3DataRecord;
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404 || e.getStatusCode() == 403) {
                LOG.info("getRecord:Identifier [{}] not found. Took [{}] ms.", (Object)identifier, (Object)(System.currentTimeMillis() - start));
            }
            throw new DataStoreException((Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public byte[] getOrCreateReferenceKey() throws DataStoreException {
        try {
            byte[] key;
            if (this.secret != null && this.secret.length != 0) {
                return this.secret;
            }
            if (this.metadataExists(REF_KEY)) {
                key = this.readMetadataBytes(REF_KEY);
            } else {
                key = super.getOrCreateReferenceKey();
                this.addMetadataRecord(new ByteArrayInputStream(key), REF_KEY);
                key = this.readMetadataBytes(REF_KEY);
            }
            this.secret = key;
            return this.secret;
        }
        catch (IOException e) {
            throw new DataStoreException("Unable to get or create key " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readMetadataBytes(String name) throws IOException, DataStoreException {
        DataRecord rec = this.getMetadataRecord(name);
        InputStream stream = null;
        try {
            stream = rec.getStream();
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean metadataExists(String name) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            boolean bl = this.s3service.doesObjectExist(this.bucket, S3Backend.addMetaKeyPrefix(name));
            return bl;
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    void setHttpUploadURIExpirySeconds(int seconds) {
        this.httpUploadURIExpirySeconds = seconds;
    }

    private DataIdentifier generateSafeRandomIdentifier() {
        return new DataIdentifier(String.format("%s-%d", UUID.randomUUID().toString(), Instant.now().toEpochMilli()));
    }

    private URI createPresignedPutURI(DataIdentifier identifier) {
        if (this.httpUploadURIExpirySeconds <= 0) {
            return null;
        }
        return this.createPresignedURI(identifier, HttpMethod.PUT, this.httpUploadURIExpirySeconds);
    }

    void setHttpDownloadURIExpirySeconds(int seconds) {
        this.httpDownloadURIExpirySeconds = seconds;
    }

    void setHttpDownloadURICacheSize(int maxSize) {
        if (maxSize > 0) {
            LOG.info("presigned GET URI cache enabled, maxSize = {} items, expiry = {} seconds", (Object)maxSize, (Object)(this.httpDownloadURIExpirySeconds / 2));
            this.httpDownloadURICache = CacheBuilder.newBuilder().maximumSize((long)maxSize).expireAfterWrite((long)(this.httpDownloadURIExpirySeconds / 2), TimeUnit.SECONDS).build();
        } else {
            LOG.info("presigned GET URI cache disabled");
            this.httpDownloadURICache = null;
        }
    }

    URI createHttpDownloadURI(@NotNull DataIdentifier identifier, @NotNull DataRecordDownloadOptions downloadOptions) {
        if (this.httpDownloadURIExpirySeconds <= 0) {
            return null;
        }
        URI uri = null;
        if (this.httpDownloadURICache != null) {
            uri = (URI)this.httpDownloadURICache.getIfPresent((Object)identifier);
        }
        if (uri == null) {
            String contentDisposition;
            HashMap requestParams = Maps.newHashMap();
            requestParams.put("response-cache-control", String.format("private, max-age=%d, immutable", this.httpDownloadURIExpirySeconds));
            String contentType = downloadOptions.getContentTypeHeader();
            if (!Strings.isNullOrEmpty((String)contentType)) {
                requestParams.put("response-content-type", contentType);
            }
            if (!Strings.isNullOrEmpty((String)(contentDisposition = downloadOptions.getContentDispositionHeader()))) {
                requestParams.put("response-content-disposition", contentDisposition);
            }
            if ((uri = this.createPresignedURI(identifier, HttpMethod.GET, this.httpDownloadURIExpirySeconds, requestParams)) != null && this.httpDownloadURICache != null) {
                this.httpDownloadURICache.put((Object)identifier, (Object)uri);
            }
        }
        return uri;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DataRecordUpload initiateHttpUpload(long maxUploadSizeInBytes, int maxNumberOfURIs) {
        final ArrayList uploadPartURIs = Lists.newArrayList();
        final long minPartSize = 0xA00000L;
        final long maxPartSize = 0x10000000L;
        if (0L >= maxUploadSizeInBytes) {
            throw new IllegalArgumentException("maxUploadSizeInBytes must be > 0");
        }
        if (0 == maxNumberOfURIs) {
            throw new IllegalArgumentException("maxNumberOfURIs must either be > 0 or -1");
        }
        if (-1 > maxNumberOfURIs) {
            throw new IllegalArgumentException("maxNumberOfURIs must either be > 0 or -1");
        }
        if (maxUploadSizeInBytes > 0x140000000L && maxNumberOfURIs == 1) {
            throw new IllegalArgumentException(String.format("Cannot do single-put upload with file size %d - exceeds max single-put upload size of %d", maxUploadSizeInBytes, 0x140000000L));
        }
        if (maxUploadSizeInBytes > 0x50000000000L) {
            throw new IllegalArgumentException(String.format("Cannot do upload with file size %d - exceeds max upload size of %d", maxUploadSizeInBytes, 0x50000000000L));
        }
        DataIdentifier newIdentifier = this.generateSafeRandomIdentifier();
        String blobId = S3Backend.getKeyName(newIdentifier);
        String uploadId = null;
        if (this.httpUploadURIExpirySeconds > 0) {
            if (maxNumberOfURIs == 1 || maxUploadSizeInBytes <= minPartSize) {
                uploadPartURIs.add(this.createPresignedPutURI(newIdentifier));
            } else {
                long numParts;
                InitiateMultipartUploadRequest req = new InitiateMultipartUploadRequest(this.bucket, blobId);
                InitiateMultipartUploadResult res = this.s3service.initiateMultipartUpload(req);
                uploadId = res.getUploadId();
                if (maxNumberOfURIs > 1) {
                    long requestedPartSize = (long)Math.ceil((double)maxUploadSizeInBytes / (double)maxNumberOfURIs);
                    if (requestedPartSize > maxPartSize) throw new IllegalArgumentException(String.format("Cannot do multi-part upload with requested part size %d", requestedPartSize));
                    numParts = Math.min((long)maxNumberOfURIs, Math.min((long)Math.ceil((double)maxUploadSizeInBytes / (double)minPartSize), 10000L));
                } else {
                    long maximalNumParts = (long)Math.ceil((double)maxUploadSizeInBytes / 1.048576E7);
                    numParts = Math.min(maximalNumParts, 10000L);
                }
                HashMap presignedURIRequestParams = Maps.newHashMap();
                for (long blockId = 1L; blockId <= numParts; ++blockId) {
                    presignedURIRequestParams.put(PART_NUMBER, String.valueOf(blockId));
                    presignedURIRequestParams.put(UPLOAD_ID, uploadId);
                    uploadPartURIs.add(this.createPresignedURI(newIdentifier, HttpMethod.PUT, this.httpUploadURIExpirySeconds, presignedURIRequestParams));
                }
            }
        }
        try {
            byte[] secret = this.getOrCreateReferenceKey();
            final String uploadToken = new DataRecordUploadToken(blobId, uploadId).getEncodedToken(secret);
            return new DataRecordUpload(){

                @NotNull
                public String getUploadToken() {
                    return uploadToken;
                }

                public long getMinPartSize() {
                    return minPartSize;
                }

                public long getMaxPartSize() {
                    return maxPartSize;
                }

                @NotNull
                public Collection<URI> getUploadURIs() {
                    return uploadPartURIs;
                }
            };
        }
        catch (DataStoreException e) {
            LOG.warn("Unable to obtain data store key");
            return null;
        }
    }

    DataRecord completeHttpUpload(@NotNull String uploadTokenStr) throws DataRecordUploadException, DataStoreException {
        if (Strings.isNullOrEmpty((String)uploadTokenStr)) {
            throw new IllegalArgumentException("uploadToken required");
        }
        DataRecordUploadToken uploadToken = DataRecordUploadToken.fromEncodedToken((String)uploadTokenStr, (byte[])this.getOrCreateReferenceKey());
        String blobId = uploadToken.getBlobId();
        if (uploadToken.getUploadId().isPresent()) {
            String uploadId = (String)uploadToken.getUploadId().get();
            ListPartsRequest listPartsRequest = new ListPartsRequest(this.bucket, blobId, uploadId);
            PartListing listing = this.s3service.listParts(listPartsRequest);
            ArrayList eTags = Lists.newArrayList();
            for (PartSummary partSummary : listing.getParts()) {
                PartETag eTag = new PartETag(partSummary.getPartNumber(), partSummary.getETag());
                eTags.add(eTag);
            }
            CompleteMultipartUploadRequest completeReq = new CompleteMultipartUploadRequest(this.bucket, blobId, uploadId, (List)eTags);
            this.s3service.completeMultipartUpload(completeReq);
        }
        if (!this.s3service.doesObjectExist(this.bucket, blobId)) {
            throw new DataRecordUploadException(String.format("Unable to finalize direct write of binary %s", blobId));
        }
        return this.getRecord(new DataIdentifier(S3Backend.getIdentifierName(blobId)));
    }

    private URI createPresignedURI(DataIdentifier identifier, HttpMethod method, int expirySeconds) {
        return this.createPresignedURI(identifier, method, expirySeconds, Maps.newHashMap());
    }

    private URI createPresignedURI(DataIdentifier identifier, HttpMethod method, int expirySeconds, Map<String, String> reqParams) {
        String key = S3Backend.getKeyName(identifier);
        try {
            Date expiration = new Date();
            expiration.setTime(expiration.getTime() + (long)(expirySeconds * 1000));
            GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(this.bucket, key).withMethod(method).withExpiration(expiration);
            for (Map.Entry<String, String> e : reqParams.entrySet()) {
                request.addRequestParameter(e.getKey(), e.getValue());
            }
            URI uri = null;
            URL presignedURL = null;
            try {
                presignedURL = this.s3PresignService.generatePresignedUrl(request);
                uri = presignedURL.toURI();
                LOG.debug("Presigned {} URI for key {}: {}", new Object[]{method.name(), key, uri.toString()});
            }
            catch (URISyntaxException e) {
                LOG.error("AWS request to create presigned S3 URI failed - could not convert '{}' to URI", (Object)(null != presignedURL ? presignedURL.toString() : ""));
            }
            return uri;
        }
        catch (AmazonServiceException e) {
            LOG.error("AWS request to create presigned S3 {} URI failed. Key: {}, Error: {}, HTTP Code: {}, AWS Error Code: {}, Error Type: {}, Request ID: {}", new Object[]{method.name(), key, e.getMessage(), e.getStatusCode(), e.getErrorCode(), e.getErrorType(), e.getRequestId()});
            return null;
        }
    }

    private static String addMetaKeyPrefix(String key) {
        return META_KEY_PREFIX + key;
    }

    private static String stripMetaKeyPrefix(String name) {
        if (name.startsWith(META_KEY_PREFIX)) {
            return name.substring(META_KEY_PREFIX.length());
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameKeys() throws DataStoreException {
        block11: {
            long startTime = System.currentTimeMillis();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            long count = 0L;
            try {
                int endIndex;
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                ObjectListing prevObjectListing = this.s3service.listObjects(this.bucket);
                ArrayList<DeleteObjectsRequest.KeyVersion> deleteList = new ArrayList<DeleteObjectsRequest.KeyVersion>();
                int nThreads = Integer.parseInt(this.properties.getProperty("maxConnections"));
                ExecutorService executor = Executors.newFixedThreadPool(nThreads, (ThreadFactory)new NamedThreadFactory("s3-object-rename-worker"));
                boolean taskAdded = false;
                while (true) {
                    for (S3ObjectSummary s3ObjSumm : prevObjectListing.getObjectSummaries()) {
                        executor.execute(new KeyRenameThread(s3ObjSumm.getKey()));
                        taskAdded = true;
                        ++count;
                        if (!s3ObjSumm.getKey().startsWith(KEY_PREFIX)) continue;
                        deleteList.add(new DeleteObjectsRequest.KeyVersion(s3ObjSumm.getKey()));
                    }
                    if (!prevObjectListing.isTruncated()) break;
                    prevObjectListing = this.s3service.listNextBatchOfObjects(prevObjectListing);
                }
                executor.shutdown();
                try {
                    while (taskAdded && !executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                        LOG.info("Rename S3 keys tasks timedout. Waiting again");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LOG.info("Renamed [{}] keys, time taken [{}]sec", (Object)count, (Object)((System.currentTimeMillis() - startTime) / 1000L));
                if (deleteList.size() <= 0) break block11;
                DeleteObjectsRequest delObjsReq = new DeleteObjectsRequest(this.bucket);
                int batchSize = 500;
                int startIndex = 0;
                int size = deleteList.size();
                int n = endIndex = batchSize < size ? batchSize : size;
                while (endIndex <= size) {
                    delObjsReq.setKeys(Collections.unmodifiableList(deleteList.subList(startIndex, endIndex)));
                    DeleteObjectsResult dobjs = this.s3service.deleteObjects(delObjsReq);
                    LOG.info("Records[{}] deleted in datastore from index [{}] to [{}]", new Object[]{dobjs.getDeletedObjects().size(), startIndex, endIndex - 1});
                    if (endIndex == size) {
                        break;
                    }
                    startIndex = endIndex;
                    endIndex = startIndex + batchSize < size ? startIndex + batchSize : size;
                }
            }
            finally {
                if (contextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
            }
        }
    }

    private static String convertKey(String oldKey) throws IllegalArgumentException {
        if (!oldKey.startsWith(KEY_PREFIX)) {
            return oldKey;
        }
        String key = oldKey.substring(KEY_PREFIX.length());
        return key.substring(0, 4) + "-" + key.substring(4);
    }

    private static String getKeyName(DataIdentifier identifier) {
        String key = identifier.toString();
        return key.substring(0, 4) + "-" + key.substring(4);
    }

    private static String getIdentifierName(String key) {
        if (!key.contains("-")) {
            return null;
        }
        if (key.contains(META_KEY_PREFIX)) {
            return key;
        }
        return key.substring(0, 4) + key.substring(5);
    }

    private class KeyRenameThread
    implements Runnable {
        private String oldKey;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                String newS3Key = S3Backend.convertKey(this.oldKey);
                CopyObjectRequest copReq = new CopyObjectRequest(S3Backend.this.bucket, this.oldKey, S3Backend.this.bucket, newS3Key);
                Copy copy = S3Backend.this.tmx.copy(S3Backend.this.s3ReqDecorator.decorate(copReq));
                try {
                    copy.waitForCopyResult();
                    LOG.debug("[{}] renamed to [{}] ", (Object)this.oldKey, (Object)newS3Key);
                }
                catch (InterruptedException ie) {
                    LOG.error(" Exception in renaming [{}] to [{}] ", new Object[]{ie, this.oldKey, newS3Key});
                }
            }
            finally {
                if (contextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
            }
        }

        public KeyRenameThread(String oldKey) {
            this.oldKey = oldKey;
        }
    }

    static class S3DataRecord
    extends AbstractDataRecord {
        private AmazonS3Client s3service;
        private long length;
        private long lastModified;
        private String bucket;
        private boolean isMeta;

        public S3DataRecord(AbstractSharedBackend backend, AmazonS3Client s3service, String bucket, DataIdentifier key, long lastModified, long length) {
            this(backend, s3service, bucket, key, lastModified, length, false);
        }

        public S3DataRecord(AbstractSharedBackend backend, AmazonS3Client s3service, String bucket, DataIdentifier key, long lastModified, long length, boolean isMeta) {
            super(backend, key);
            this.s3service = s3service;
            this.lastModified = lastModified;
            this.length = length;
            this.bucket = bucket;
            this.isMeta = isMeta;
        }

        public long getLength() throws DataStoreException {
            return this.length;
        }

        public InputStream getStream() throws DataStoreException {
            String id = S3Backend.getKeyName(this.getIdentifier());
            if (this.isMeta) {
                id = S3Backend.addMetaKeyPrefix(this.getIdentifier().toString());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("binary downloaded from S3: " + this.getIdentifier(), (Throwable)new Exception());
            }
            return this.s3service.getObject(this.bucket, id).getObjectContent();
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public String toString() {
            return "S3DataRecord{identifier=" + this.getIdentifier() + ", length=" + this.length + ", lastModified=" + this.lastModified + ", bucket='" + this.bucket + '\'' + '}';
        }
    }

    class RecordsIterator<T>
    extends AbstractIterator<T> {
        ObjectListing prevObjectListing;
        Queue<S3ObjectSummary> queue = Lists.newLinkedList();
        long size;
        Function<S3ObjectSummary, T> transformer;

        public RecordsIterator(Function<S3ObjectSummary, T> transformer) {
            this.transformer = transformer;
        }

        protected T computeNext() {
            if (this.queue.isEmpty()) {
                this.loadBatch();
            }
            if (!this.queue.isEmpty()) {
                return (T)this.transformer.apply((Object)this.queue.remove());
            }
            return (T)this.endOfData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean loadBatch() {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            long start = System.currentTimeMillis();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                if (this.prevObjectListing == null) {
                    this.prevObjectListing = S3Backend.this.s3service.listObjects(S3Backend.this.bucket);
                } else if (this.prevObjectListing.isTruncated()) {
                    this.prevObjectListing = S3Backend.this.s3service.listNextBatchOfObjects(this.prevObjectListing);
                } else {
                    boolean bl = false;
                    return bl;
                }
                ArrayList listing = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.prevObjectListing.getObjectSummaries(), (Predicate)new Predicate<S3ObjectSummary>(){

                    public boolean apply(S3ObjectSummary input) {
                        return !input.getKey().startsWith(S3Backend.META_KEY_PREFIX);
                    }
                }));
                if (listing.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                this.size += (long)listing.size();
                this.queue.addAll(listing);
                LOG.info("Loaded batch of size [{}] in [{}] ms.", (Object)listing.size(), (Object)(System.currentTimeMillis() - start));
                boolean bl = true;
                return bl;
            }
            catch (AmazonServiceException e) {
                LOG.warn("Could not list objects", (Throwable)e);
            }
            finally {
                if (contextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
            }
            return false;
        }
    }
}

