/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.s3;

import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.util.Properties;

public class S3RequestDecorator {
    DataEncryption dataEncryption = DataEncryption.NONE;

    public S3RequestDecorator(Properties props) {
        if (props.getProperty("s3Encryption") != null) {
            this.dataEncryption = DataEncryption.valueOf(props.getProperty("s3Encryption"));
        }
    }

    public PutObjectRequest decorate(PutObjectRequest request) {
        switch (this.getDataEncryption()) {
            case SSE_S3: {
                ObjectMetadata metadata = request.getMetadata() == null ? new ObjectMetadata() : request.getMetadata();
                metadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                request.setMetadata(metadata);
                break;
            }
        }
        return request;
    }

    public CopyObjectRequest decorate(CopyObjectRequest request) {
        switch (this.getDataEncryption()) {
            case SSE_S3: {
                ObjectMetadata metadata = request.getNewObjectMetadata() == null ? new ObjectMetadata() : request.getNewObjectMetadata();
                metadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                request.setNewObjectMetadata(metadata);
                break;
            }
        }
        return request;
    }

    private DataEncryption getDataEncryption() {
        return this.dataEncryption;
    }

    private static enum DataEncryption {
        SSE_S3,
        NONE;

    }
}

