/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.s3;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.scr.annotations.Component;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.blob.cloud.aws.s3.SharedS3DataStore;
import org.apache.jackrabbit.oak.blob.cloud.s3.S3DataStore;
import org.apache.jackrabbit.oak.plugins.blob.AbstractSharedCachingDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.AbstractDataStoreService;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;

@Component(componentAbstract=true)
public abstract class AbstractS3DataStoreService
extends AbstractDataStoreService {
    private static final String DESCRIPTION = "oak.datastore.description";
    private ServiceRegistration delegateReg;

    protected DataStore createDataStore(ComponentContext context, Map<String, Object> config) {
        Properties properties = new Properties();
        properties.putAll(config);
        if (this.JR2_CACHING) {
            SharedS3DataStore dataStore = new SharedS3DataStore();
            dataStore.setProperties(properties);
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("service.pid", ((Object)((Object)dataStore)).getClass().getName());
            ((Dictionary)props).put(DESCRIPTION, this.getDescription());
            this.delegateReg = context.getBundleContext().registerService(new String[]{SharedS3DataStore.class.getName(), SharedS3DataStore.class.getName()}, (Object)dataStore, props);
            return dataStore;
        }
        S3DataStore dataStore = new S3DataStore();
        dataStore.setStatisticsProvider(this.getStatisticsProvider());
        dataStore.setProperties(properties);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.pid", ((Object)((Object)dataStore)).getClass().getName());
        ((Dictionary)props).put(DESCRIPTION, this.getDescription());
        this.delegateReg = context.getBundleContext().registerService(new String[]{AbstractSharedCachingDataStore.class.getName(), AbstractSharedCachingDataStore.class.getName()}, (Object)dataStore, props);
        return dataStore;
    }

    protected void deactivate() throws DataStoreException {
        if (this.delegateReg != null) {
            this.delegateReg.unregister();
        }
        super.deactivate();
    }

    protected String[] getDescription() {
        return new String[]{"type=S3"};
    }
}

