/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.aws.s3;

import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.core.data.Backend;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.blob.cloud.aws.s3.S3Backend;
import org.apache.jackrabbit.oak.blob.cloud.aws.s3.S3DataStore;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;

public class SharedS3DataStore
extends S3DataStore
implements SharedDataStore {
    protected S3Backend backend;

    @Override
    protected Backend createBackend() {
        this.backend = new S3Backend();
        if (this.properties != null) {
            this.backend.setProperties(this.properties);
        }
        return this.backend;
    }

    public void addMetadataRecord(InputStream stream, String name) throws DataStoreException {
        this.backend.addMetadataRecord(stream, name);
    }

    public void addMetadataRecord(File f, String name) throws DataStoreException {
        this.backend.addMetadataRecord(f, name);
    }

    public DataRecord getMetadataRecord(String name) {
        return this.backend.getMetadataRecord(name);
    }

    public List<DataRecord> getAllMetadataRecords(String prefix) {
        return this.backend.getAllMetadataRecords(prefix);
    }

    public boolean deleteMetadataRecord(String name) {
        return this.backend.deleteMetadataRecord(name);
    }

    public void deleteAllMetadataRecords(String prefix) {
        this.backend.deleteAllMetadataRecords(prefix);
    }

    public Iterator<DataRecord> getAllRecords() {
        return this.backend.getAllRecords();
    }

    public DataRecord getRecordForId(DataIdentifier identifier) throws DataStoreException {
        return this.backend.getRecord(identifier);
    }

    public SharedDataStore.Type getType() {
        return SharedDataStore.Type.SHARED;
    }
}

