/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.aws.s3;

import com.google.common.base.Strings;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.blob.cloud.aws.s3.SharedS3DataStore;
import org.apache.jackrabbit.oak.blob.cloud.s3.stats.S3DataStoreStatsMBean;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.InMemoryDataRecord;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.osgi.framework.BundleContext;

@Component
public class S3DataStoreStats
implements S3DataStoreStatsMBean {
    private Registration mbeanReg;
    @Reference
    protected SharedS3DataStore s3ds;
    @Reference
    protected NodeStore nodeStore;

    @Activate
    private void activate(BundleContext context) {
        OsgiWhiteboard wb = new OsgiWhiteboard(context);
        this.mbeanReg = WhiteboardUtils.registerMBean((Whiteboard)wb, S3DataStoreStatsMBean.class, (Object)this, (String)"S3DataStoreStats", (String)"S3 DataStore statistics");
    }

    @Deactivate
    private void deactivate() {
        if (this.mbeanReg != null) {
            this.mbeanReg.unregister();
        }
    }

    @Override
    public long getActiveSyncs() {
        return this.s3ds.getPendingUploads().size();
    }

    @Override
    public boolean isFileSynced(String nodePathName) {
        if (Strings.isNullOrEmpty((String)nodePathName)) {
            return false;
        }
        if (null == this.nodeStore) {
            return false;
        }
        NodeState leafNode = this.findLeafNode(nodePathName);
        if (!leafNode.exists()) {
            return false;
        }
        boolean nodeHasBinaryProperties = false;
        for (PropertyState propertyState : leafNode.getProperties()) {
            nodeHasBinaryProperties |= propertyState.getType() == Type.BINARY || propertyState.getType() == Type.BINARIES;
            try {
                if (propertyState.getType() == Type.BINARY) {
                    Blob blob = (Blob)propertyState.getValue(propertyState.getType());
                    if (null != blob && this.haveRecordForBlob(blob)) continue;
                    return false;
                }
                if (propertyState.getType() != Type.BINARIES) continue;
                List blobs = (List)propertyState.getValue(propertyState.getType());
                if (null == blobs) {
                    return false;
                }
                for (Blob blob : blobs) {
                    if (this.haveRecordForBlob(blob)) continue;
                    return false;
                }
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return nodeHasBinaryProperties;
    }

    private NodeState findLeafNode(String nodePathName) {
        Iterable pathNodes = PathUtils.elements((String)PathUtils.getParentPath((String)nodePathName));
        String leafNodeName = PathUtils.getName((String)nodePathName);
        NodeState currentNode = this.nodeStore.getRoot();
        for (String pathNodeName : pathNodes) {
            if (pathNodeName.length() <= 0) continue;
            NodeState childNode = currentNode.getChildNode(pathNodeName);
            if (!childNode.exists()) break;
            currentNode = childNode;
        }
        return currentNode.getChildNode(leafNodeName);
    }

    private boolean haveRecordForBlob(Blob blob) {
        String fullBlobId = blob.getContentIdentity();
        if (!Strings.isNullOrEmpty((String)fullBlobId) && !InMemoryDataRecord.isInstance((String)fullBlobId)) {
            String blobId = DataStoreBlobStore.BlobId.of((String)fullBlobId).getBlobId();
            return this.s3ds.haveRecordForIdentifier(blobId);
        }
        return false;
    }

    protected void bindS3ds(SharedS3DataStore sharedS3DataStore) {
        this.s3ds = sharedS3DataStore;
    }

    protected void unbindS3ds(SharedS3DataStore sharedS3DataStore) {
        if (this.s3ds == sharedS3DataStore) {
            this.s3ds = null;
        }
    }

    protected void bindNodeStore(NodeStore nodeStore) {
        this.nodeStore = nodeStore;
    }

    protected void unbindNodeStore(NodeStore nodeStore) {
        if (this.nodeStore == nodeStore) {
            this.nodeStore = null;
        }
    }
}

