/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.azure.blobstorage;

import java.net.URI;
import java.util.Properties;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.blob.cloud.azure.blobstorage.AzureBlobStoreBackend;
import org.apache.jackrabbit.oak.plugins.blob.AbstractSharedCachingDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.ConfigurableDataRecordAccessProvider;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordDownloadOptions;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUpload;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUploadException;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUploadOptions;
import org.apache.jackrabbit.oak.spi.blob.AbstractSharedBackend;
import org.apache.jackrabbit.oak.spi.blob.SharedBackend;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzureDataStore
extends AbstractSharedCachingDataStore
implements ConfigurableDataRecordAccessProvider {
    private int minRecordLength = 16384;
    protected Properties properties;
    private AzureBlobStoreBackend azureBlobStoreBackend;

    protected AbstractSharedBackend createBackend() {
        this.azureBlobStoreBackend = new AzureBlobStoreBackend();
        if (null != this.properties) {
            this.azureBlobStoreBackend.setProperties(this.properties);
        }
        return this.azureBlobStoreBackend;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public SharedBackend getBackend() {
        return this.backend;
    }

    public int getMinRecordLength() {
        return this.minRecordLength;
    }

    public void setMinRecordLength(int minRecordLength) {
        this.minRecordLength = minRecordLength;
    }

    public void setDirectUploadURIExpirySeconds(int seconds) {
        if (null != this.azureBlobStoreBackend) {
            this.azureBlobStoreBackend.setHttpUploadURIExpirySeconds(seconds);
        }
    }

    public void setBinaryTransferAccelerationEnabled(boolean enabled) {
    }

    @Nullable
    public DataRecordUpload initiateDataRecordUpload(long maxUploadSizeInBytes, int maxNumberOfURIs) throws IllegalArgumentException, DataRecordUploadException {
        return this.initiateDataRecordUpload(maxUploadSizeInBytes, maxNumberOfURIs, DataRecordUploadOptions.DEFAULT);
    }

    @Nullable
    public DataRecordUpload initiateDataRecordUpload(long maxUploadSizeInBytes, int maxNumberOfURIs, @NotNull DataRecordUploadOptions options) throws IllegalArgumentException, DataRecordUploadException {
        if (null == this.azureBlobStoreBackend) {
            throw new DataRecordUploadException("Backend not initialized");
        }
        return this.azureBlobStoreBackend.initiateHttpUpload(maxUploadSizeInBytes, maxNumberOfURIs, options);
    }

    @NotNull
    public DataRecord completeDataRecordUpload(String uploadToken) throws IllegalArgumentException, DataRecordUploadException, DataStoreException {
        if (null == this.azureBlobStoreBackend) {
            throw new DataRecordUploadException("Backend not initialized");
        }
        return this.azureBlobStoreBackend.completeHttpUpload(uploadToken);
    }

    public void setDirectDownloadURIExpirySeconds(int seconds) {
        if (null != this.azureBlobStoreBackend) {
            this.azureBlobStoreBackend.setHttpDownloadURIExpirySeconds(seconds);
        }
    }

    public void setDirectDownloadURICacheSize(int maxSize) {
        this.azureBlobStoreBackend.setHttpDownloadURICacheSize(maxSize);
    }

    @Nullable
    public URI getDownloadURI(@NotNull DataIdentifier identifier, @NotNull DataRecordDownloadOptions downloadOptions) {
        if (null != this.azureBlobStoreBackend) {
            return this.azureBlobStoreBackend.createHttpDownloadURI(identifier, downloadOptions);
        }
        return null;
    }
}

