/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.ldap.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.security.auth.login.LoginException;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.directory.api.ldap.codec.controls.search.pagedSearch.PagedResultsDecorator;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.controls.PagedResults;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.ldap.client.api.AbstractPoolableLdapConnectionFactory;
import org.apache.directory.ldap.client.api.DefaultLdapConnectionValidator;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionPool;
import org.apache.directory.ldap.client.api.LdapConnectionValidator;
import org.apache.directory.ldap.client.api.LookupLdapConnectionValidator;
import org.apache.directory.ldap.client.api.NoVerificationTrustManager;
import org.apache.directory.ldap.client.api.ValidatingPoolableLdapConnectionFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.commons.DebugTimer;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapGroup;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapIdentity;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapProviderConfig;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapUser;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.PoolableUnboundConnectionFactory;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.UnboundConnectionValidator;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.UnboundLdapConnectionPool;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.UnboundLookupConnectionValidator;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalGroup;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalUser;
import org.apache.jackrabbit.oak.spi.security.authentication.external.PrincipalNameResolver;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service
public class LdapIdentityProvider
implements ExternalIdentityProvider,
PrincipalNameResolver {
    private static final Logger log = LoggerFactory.getLogger(LdapIdentityProvider.class);
    private LdapProviderConfig config;
    private LdapConnectionPool adminPool;
    private AbstractPoolableLdapConnectionFactory adminConnectionFactory;
    private UnboundLdapConnectionPool userPool;
    private PoolableUnboundConnectionFactory userConnectionFactory;
    private String[] enabledSSLProtocols;

    public LdapIdentityProvider() {
    }

    public LdapIdentityProvider(@Nonnull LdapProviderConfig config) {
        this.config = config;
        this.init();
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        ConfigurationParameters cfg = ConfigurationParameters.of(properties);
        this.config = LdapProviderConfig.of(cfg);
        this.init();
    }

    @Deactivate
    private void deactivate() {
        this.close();
    }

    public void close() {
        if (this.adminPool != null) {
            try {
                this.adminPool.close();
            }
            catch (Exception e) {
                log.warn("Error while closing LDAP connection pool", (Throwable)e);
            }
            this.adminPool = null;
        }
        if (this.userPool != null) {
            try {
                this.userPool.close();
            }
            catch (Exception e) {
                log.warn("Error while closing LDAP connection pool", (Throwable)e);
            }
            this.userPool = null;
        }
    }

    @Nonnull
    public String fromExternalIdentityRef(@Nonnull ExternalIdentityRef externalIdentityRef) throws ExternalIdentityException {
        if (!this.isMyRef(externalIdentityRef)) {
            throw new ExternalIdentityException("Foreign IDP " + externalIdentityRef.getString());
        }
        return externalIdentityRef.getId();
    }

    @Nonnull
    public String getName() {
        return this.config.getName();
    }

    public ExternalIdentity getIdentity(@Nonnull ExternalIdentityRef ref) throws ExternalIdentityException {
        if (!this.isMyRef(ref)) {
            return null;
        }
        LdapConnection connection = this.connect();
        try {
            ExternalUser externalUser;
            Entry entry;
            String userIdAttr = this.config.getUserConfig().getIdAttribute();
            String groupIdAttr = this.config.getGroupConfig().getIdAttribute();
            String[] ca = this.config.getCustomAttributes();
            if (ca.length == 0) {
                entry = connection.lookup(ref.getId(), new String[]{"*"});
            } else {
                ArrayList<String> attributes = new ArrayList<String>(Arrays.asList(ca));
                attributes.add("objectClass");
                attributes.add(userIdAttr);
                attributes.add(groupIdAttr);
                String[] attributeArray = new String[attributes.size()];
                attributes.toArray(attributeArray);
                entry = connection.lookup(ref.getId(), attributeArray);
            }
            if (entry == null) {
                externalUser = null;
                return externalUser;
            }
            if (entry.hasObjectClass(this.config.getUserConfig().getObjectClasses())) {
                externalUser = this.createUser(entry, null);
                return externalUser;
            }
            if (entry.hasObjectClass(this.config.getGroupConfig().getObjectClasses())) {
                externalUser = this.createGroup(entry, null);
                return externalUser;
            }
            log.warn("referenced identity is neither user or group: {}", (Object)ref.getString());
            externalUser = null;
            return externalUser;
        }
        catch (LdapException e) {
            throw LdapIdentityProvider.lookupFailedException((Exception)((Object)e), null);
        }
        finally {
            this.disconnect(connection);
        }
    }

    public ExternalUser getUser(@Nonnull String userId) throws ExternalIdentityException {
        DebugTimer timer = new DebugTimer();
        LdapConnection connection = this.connect();
        timer.mark("connect");
        try {
            Entry entry = this.getEntry(connection, this.config.getUserConfig(), userId, this.config.getCustomAttributes());
            timer.mark("lookup");
            if (log.isDebugEnabled()) {
                log.debug("getUser({}) {}", (Object)userId, (Object)timer.getString());
            }
            if (entry != null) {
                ExternalUser externalUser = this.createUser(entry, userId);
                return externalUser;
            }
            ExternalUser externalUser = null;
            return externalUser;
        }
        catch (LdapException e) {
            throw LdapIdentityProvider.lookupFailedException((Exception)((Object)e), timer);
        }
        catch (CursorException e) {
            throw LdapIdentityProvider.lookupFailedException((Exception)((Object)e), timer);
        }
        finally {
            this.disconnect(connection);
        }
    }

    public ExternalGroup getGroup(@Nonnull String name) throws ExternalIdentityException {
        DebugTimer timer = new DebugTimer();
        LdapConnection connection = this.connect();
        timer.mark("connect");
        try {
            Entry entry = this.getEntry(connection, this.config.getGroupConfig(), name, this.config.getCustomAttributes());
            timer.mark("lookup");
            if (log.isDebugEnabled()) {
                log.debug("getGroup({}) {}", (Object)name, (Object)timer.getString());
            }
            if (entry != null) {
                ExternalGroup externalGroup = this.createGroup(entry, name);
                return externalGroup;
            }
            ExternalGroup externalGroup = null;
            return externalGroup;
        }
        catch (LdapException e) {
            throw LdapIdentityProvider.lookupFailedException((Exception)((Object)e), timer);
        }
        catch (CursorException e) {
            throw LdapIdentityProvider.lookupFailedException((Exception)((Object)e), timer);
        }
        finally {
            this.disconnect(connection);
        }
    }

    @Nonnull
    public Iterator<ExternalUser> listUsers() throws ExternalIdentityException {
        try {
            final SearchResultIterator iter = this.getEntryIterator(this.config.getUserConfig());
            return new AbstractLazyIterator<ExternalUser>(){

                protected ExternalUser getNext() {
                    while (iter.hasNext()) {
                        try {
                            return LdapIdentityProvider.this.createUser((Entry)iter.next(), null);
                        }
                        catch (LdapInvalidAttributeValueException e) {
                            log.warn("Error while creating external user object", (Throwable)e);
                        }
                    }
                    return null;
                }
            };
        }
        catch (LdapException e) {
            throw LdapIdentityProvider.lookupFailedException((Exception)((Object)e), null);
        }
        catch (CursorException e) {
            throw LdapIdentityProvider.lookupFailedException((Exception)((Object)e), null);
        }
    }

    @Nonnull
    public Iterator<ExternalGroup> listGroups() throws ExternalIdentityException {
        try {
            final SearchResultIterator iter = this.getEntryIterator(this.config.getGroupConfig());
            return new AbstractLazyIterator<ExternalGroup>(){

                protected ExternalGroup getNext() {
                    while (iter.hasNext()) {
                        try {
                            return LdapIdentityProvider.this.createGroup((Entry)iter.next(), null);
                        }
                        catch (LdapInvalidAttributeValueException e) {
                            log.warn("Error while creating external user object", (Throwable)e);
                        }
                    }
                    return null;
                }
            };
        }
        catch (LdapException e) {
            throw LdapIdentityProvider.lookupFailedException((Exception)((Object)e), null);
        }
        catch (CursorException e) {
            throw LdapIdentityProvider.lookupFailedException((Exception)((Object)e), null);
        }
    }

    public ExternalUser authenticate(@Nonnull Credentials credentials) throws ExternalIdentityException, LoginException {
        if (!(credentials instanceof SimpleCredentials)) {
            log.debug("LDAP IDP can only authenticate SimpleCredentials.");
            return null;
        }
        SimpleCredentials creds = (SimpleCredentials)credentials;
        LdapUser user = (LdapUser)this.getUser(creds.getUserID());
        if (user != null) {
            if (creds.getPassword().length == 0) {
                throw new LoginException("Refusing to authenticate against LDAP server: Empty passwords not allowed.");
            }
            LdapConnection connection = null;
            try {
                DebugTimer timer = new DebugTimer();
                connection = this.userPool == null ? this.userConnectionFactory.makeObject() : this.userPool.getConnection();
                timer.mark("connect");
                connection.bind(user.getEntry().getDn(), new String(creds.getPassword()));
                timer.mark("bind");
                if (log.isDebugEnabled()) {
                    log.debug("authenticate({}) {}", (Object)user.getId(), (Object)timer.getString());
                }
            }
            catch (LdapAuthenticationException e) {
                throw new LoginException("Unable to authenticate against LDAP server: " + e.getMessage());
            }
            catch (Exception e) {
                throw new ExternalIdentityException("Error while binding user credentials", (Throwable)e);
            }
            finally {
                if (connection != null) {
                    try {
                        if (this.userPool == null) {
                            this.userConnectionFactory.destroyObject(connection);
                        } else {
                            this.userPool.releaseConnection(connection);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return user;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Map<String, ExternalIdentityRef> getDeclaredGroupRefs(ExternalIdentityRef ref, String dn) throws ExternalIdentityException {
        HashMap<String, ExternalIdentityRef> hashMap;
        LdapConnection connection;
        block13: {
            if (!this.isMyRef(ref)) {
                return Collections.emptyMap();
            }
            String searchFilter = this.config.getMemberOfSearchFilter(dn);
            connection = null;
            SearchCursor searchCursor = null;
            try {
                SearchRequestImpl req = new SearchRequestImpl();
                req.setScope(SearchScope.SUBTREE);
                String idAttribute = this.config.getGroupConfig().getIdAttribute();
                req.addAttributes(new String[]{idAttribute == null ? "1.1" : idAttribute});
                req.setTimeLimit((int)this.config.getSearchTimeout());
                req.setBase(new Dn(new String[]{this.config.getGroupConfig().getBaseDN()}));
                req.setFilter(searchFilter);
                if (log.isDebugEnabled()) {
                    log.debug("getDeclaredGroupRefs: using SearchRequest {}.", (Object)req);
                }
                HashMap<String, ExternalIdentityRef> groups = new HashMap<String, ExternalIdentityRef>();
                DebugTimer timer = new DebugTimer();
                connection = this.connect();
                timer.mark("connect");
                searchCursor = connection.search((SearchRequest)req);
                timer.mark("search");
                while (searchCursor.next()) {
                    Response response = (Response)searchCursor.get();
                    if (!(response instanceof SearchResultEntry)) continue;
                    Entry resultEntry = ((SearchResultEntry)response).getEntry();
                    ExternalIdentityRef groupRef = new ExternalIdentityRef(resultEntry.getDn().toString(), this.getName());
                    groups.put(groupRef.getId(), groupRef);
                }
                timer.mark("iterate");
                if (log.isDebugEnabled()) {
                    log.debug("getDeclaredGroupRefs: search below {} with {} found {} entries. {}", new Object[]{this.config.getGroupConfig().getBaseDN(), searchFilter, groups.size(), timer.getString()});
                }
                hashMap = groups;
                if (searchCursor == null) break block13;
            }
            catch (Exception e) {
                try {
                    log.error("Error during ldap membership search.", (Throwable)e);
                    throw new ExternalIdentityException("Error during ldap membership search.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (searchCursor != null) {
                        try {
                            searchCursor.close();
                        }
                        catch (IOException e2) {
                            log.warn("Failed to close search cursor.", (Throwable)e2);
                        }
                    }
                    this.disconnect(connection);
                    throw throwable;
                }
            }
            try {
                searchCursor.close();
            }
            catch (IOException e) {
                log.warn("Failed to close search cursor.", (Throwable)e);
            }
        }
        this.disconnect(connection);
        return hashMap;
    }

    Map<String, ExternalIdentityRef> getDeclaredMemberRefs(ExternalIdentityRef ref, String dn) throws ExternalIdentityException {
        if (!this.isMyRef(ref)) {
            return Collections.emptyMap();
        }
        LdapConnection connection = null;
        try {
            HashMap<String, ExternalIdentityRef> members = new HashMap<String, ExternalIdentityRef>();
            DebugTimer timer = new DebugTimer();
            connection = this.connect();
            timer.mark("connect");
            Entry entry = connection.lookup(dn);
            timer.mark("lookup");
            Attribute attr = entry.get(this.config.getGroupMemberAttribute());
            if (attr == null) {
                log.warn("LDAP group does not have configured attribute: {}", (Object)this.config.getGroupMemberAttribute());
            } else {
                for (Value value : attr) {
                    ExternalIdentityRef memberRef = new ExternalIdentityRef(value.getString(), this.getName());
                    members.put(memberRef.getId(), memberRef);
                }
            }
            timer.mark("iterate");
            if (log.isDebugEnabled()) {
                log.debug("members lookup of {} found {} members. {}", new Object[]{ref.getId(), members.size(), timer.getString()});
            }
            HashMap<String, ExternalIdentityRef> hashMap = members;
            this.disconnect(connection);
            return hashMap;
        }
        catch (Exception e) {
            try {
                String msg = "Error during ldap group members lookup.";
                log.error(msg, (Throwable)e);
                throw new ExternalIdentityException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.disconnect(connection);
                throw throwable;
            }
        }
    }

    private void init() {
        if (this.adminConnectionFactory != null) {
            throw new IllegalStateException("Provider already initialized.");
        }
        try {
            this.enabledSSLProtocols = null;
            SSLContext.getInstance("TLSv1.1");
        }
        catch (NoSuchAlgorithmException e) {
            log.warn("JDK does not support TLSv1.1. Disabling it.");
            this.enabledSSLProtocols = new String[]{"TLSv1"};
        }
        LdapConnectionConfig cc = this.createConnectionConfig();
        String bindDN = this.config.getBindDN();
        if (bindDN != null && !bindDN.isEmpty()) {
            cc.setName(bindDN);
            cc.setCredentials(this.config.getBindPassword());
        }
        this.adminConnectionFactory = new ValidatingPoolableLdapConnectionFactory(cc);
        if (this.config.getAdminPoolConfig().lookupOnValidate()) {
            this.adminConnectionFactory.setValidator((LdapConnectionValidator)new LookupLdapConnectionValidator());
        } else {
            this.adminConnectionFactory.setValidator((LdapConnectionValidator)new DefaultLdapConnectionValidator());
        }
        if (this.config.getAdminPoolConfig().getMaxActive() != 0) {
            this.adminPool = new LdapConnectionPool((PoolableObjectFactory)this.adminConnectionFactory);
            this.adminPool.setTestOnBorrow(true);
            this.adminPool.setMaxActive(this.config.getAdminPoolConfig().getMaxActive());
            this.adminPool.setWhenExhaustedAction((byte)1);
        }
        cc = this.createConnectionConfig();
        this.userConnectionFactory = new PoolableUnboundConnectionFactory(cc);
        if (this.config.getUserPoolConfig().lookupOnValidate()) {
            this.userConnectionFactory.setValidator(new UnboundLookupConnectionValidator());
        } else {
            this.userConnectionFactory.setValidator(new UnboundConnectionValidator());
        }
        if (this.config.getUserPoolConfig().getMaxActive() != 0) {
            this.userPool = new UnboundLdapConnectionPool(this.userConnectionFactory);
            this.userPool.setTestOnBorrow(true);
            this.userPool.setMaxActive(this.config.getUserPoolConfig().getMaxActive());
            this.userPool.setWhenExhaustedAction((byte)1);
        }
        log.info("LdapIdentityProvider initialized: {}", (Object)this.config);
    }

    @Nonnull
    private LdapConnectionConfig createConnectionConfig() {
        LdapConnectionConfig cc = new LdapConnectionConfig();
        cc.setLdapHost(this.config.getHostname());
        cc.setLdapPort(this.config.getPort());
        cc.setUseSsl(this.config.useSSL());
        cc.setUseTls(this.config.useTLS());
        if (this.config.noCertCheck()) {
            cc.setTrustManagers(new TrustManager[]{new NoVerificationTrustManager()});
        }
        if (this.enabledSSLProtocols != null) {
            cc.setEnabledProtocols(this.enabledSSLProtocols);
        }
        return cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private Entry getEntry(@Nonnull LdapConnection connection, @Nonnull LdapProviderConfig.Identity idConfig, @Nonnull String id, @Nonnull String[] customAttributes) throws CursorException, LdapException {
        String searchFilter = idConfig.getSearchFilter(id);
        SearchRequestImpl req = new SearchRequestImpl();
        req.setScope(SearchScope.SUBTREE);
        if (customAttributes.length == 0) {
            req.addAttributes(new String[]{"*"});
        } else {
            req.addAttributes(customAttributes);
        }
        req.setTimeLimit((int)this.config.getSearchTimeout());
        req.setBase(new Dn(new String[]{idConfig.getBaseDN()}));
        req.setFilter(searchFilter);
        if (log.isDebugEnabled()) {
            log.debug("getEntry: using SearchRequest {}.", (Object)req);
        }
        SearchCursor searchCursor = null;
        Entry resultEntry = null;
        try {
            searchCursor = connection.search((SearchRequest)req);
            while (searchCursor.next()) {
                if (resultEntry != null) {
                    log.warn("search for {} returned more than one entry. discarding additional ones.", (Object)searchFilter);
                    continue;
                }
                Response response = (Response)searchCursor.get();
                if (!(response instanceof SearchResultEntry)) continue;
                resultEntry = ((SearchResultEntry)response).getEntry();
            }
        }
        finally {
            if (searchCursor != null) {
                try {
                    searchCursor.close();
                }
                catch (IOException e) {
                    log.warn("Failed to close search cursor.", (Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            if (resultEntry == null) {
                log.debug("getEntry: search below {} with {} found 0 entries.", (Object)idConfig.getBaseDN(), (Object)searchFilter);
            } else {
                log.debug("getEntry: search below {} with {} found {}", new Object[]{idConfig.getBaseDN(), searchFilter, resultEntry.getDn()});
            }
        }
        return resultEntry;
    }

    @Nonnull
    private SearchResultIterator getEntryIterator(@Nonnull LdapProviderConfig.Identity idConfig) throws LdapException, CursorException, ExternalIdentityException {
        StringBuilder filter = new StringBuilder();
        int num = 0;
        for (String objectClass : idConfig.getObjectClasses()) {
            ++num;
            filter.append("(objectclass=").append(LdapProviderConfig.encodeFilterValue(objectClass)).append(')');
        }
        String extraFilter = idConfig.getExtraFilter();
        if (extraFilter != null && !extraFilter.isEmpty()) {
            ++num;
            filter.append(extraFilter);
        }
        String searchFilter = num > 1 ? "(&" + filter + ')' : filter.toString();
        return new SearchResultIterator(searchFilter, idConfig);
    }

    @Nonnull
    private ExternalUser createUser(@Nonnull Entry entry, @CheckForNull String id) throws LdapInvalidAttributeValueException {
        return (ExternalUser)this.createIdentity(entry, id, false);
    }

    @Nonnull
    private ExternalGroup createGroup(@Nonnull Entry entry, @CheckForNull String id) throws LdapInvalidAttributeValueException {
        return (ExternalGroup)this.createIdentity(entry, id, true);
    }

    @Nonnull
    private ExternalIdentity createIdentity(@Nonnull Entry entry, @CheckForNull String id, boolean isGroup) throws LdapInvalidAttributeValueException {
        LdapProviderConfig.Identity cfg;
        LdapProviderConfig.Identity identity = cfg = isGroup ? this.config.getGroupConfig() : this.config.getUserConfig();
        if (id == null) {
            String idAttribute = cfg.getIdAttribute();
            Attribute attr = entry.get(idAttribute);
            if (attr == null) {
                throw new LdapInvalidAttributeValueException(ResultCodeEnum.CONSTRAINT_VIOLATION, "no value found for attribute '" + idAttribute + "' for entry " + entry);
            }
            id = attr.getString();
        }
        String extId = this.config.getUseUidForExtId() ? id : entry.getDn().getName();
        ExternalIdentityRef ref = new ExternalIdentityRef(extId, this.getName());
        String path = cfg.makeDnPath() ? LdapIdentityProvider.createDNPath(entry.getDn()) : null;
        LdapIdentity identity2 = isGroup ? new LdapGroup(this, ref, id, path, entry) : new LdapUser(this, ref, id, path, entry);
        Map<String, Object> props = identity2.getProperties();
        this.applyAttributes(props, entry);
        return identity2;
    }

    private void applyAttributes(Map<String, Object> props, Entry entry) throws LdapInvalidAttributeValueException {
        for (Attribute attr : entry.getAttributes()) {
            Object propValue;
            if (!attr.isHumanReadable()) continue;
            if (attr.size() > 1) {
                ArrayList<String> values = new ArrayList<String>();
                for (Value value : attr) {
                    values.add(value.getString());
                }
                propValue = values;
            } else {
                propValue = attr.getString();
            }
            props.put(attr.getId(), propValue);
        }
    }

    @Nonnull
    private LdapConnection connect() throws ExternalIdentityException {
        try {
            if (this.adminPool == null) {
                return this.adminConnectionFactory.makeObject();
            }
            return this.adminPool.getConnection();
        }
        catch (Exception e) {
            String msg = "Error while connecting to the ldap server.";
            log.error(msg, (Throwable)e);
            throw new ExternalIdentityException(msg, (Throwable)e);
        }
    }

    private void disconnect(@Nullable LdapConnection connection) {
        try {
            if (connection != null) {
                if (this.adminPool == null) {
                    this.adminConnectionFactory.destroyObject(connection);
                } else {
                    this.adminPool.releaseConnection(connection);
                }
            }
        }
        catch (Exception e) {
            log.warn("Error while disconnecting from the ldap server.", (Throwable)e);
        }
    }

    private boolean isMyRef(@Nonnull ExternalIdentityRef ref) {
        String refProviderName = ref.getProviderName();
        return refProviderName == null || refProviderName.isEmpty() || this.getName().equals(refProviderName);
    }

    private static String createDNPath(Dn dn) {
        StringBuilder path = new StringBuilder();
        for (Rdn rnd : dn.getRdns()) {
            if (path.length() > 0) {
                path.append('/');
            }
            path.append(Text.escapeIllegalJcrChars((String)rnd.toString()));
        }
        return path.toString();
    }

    private static ExternalIdentityException lookupFailedException(@Nonnull Exception e, @CheckForNull DebugTimer timer) {
        String msg = "Error during ldap lookup. ";
        log.error(msg + (timer != null ? timer.getString() : ""), (Throwable)e);
        return new ExternalIdentityException(msg, (Throwable)e);
    }

    private final class SearchResultIterator
    implements Iterator<Entry> {
        private final String searchFilter;
        private final LdapProviderConfig.Identity idConfig;
        private byte[] cookie;
        private List page = Collections.emptyList();
        private boolean searchComplete;
        private int pos = -1;

        public SearchResultIterator(@Nonnull String searchFilter, LdapProviderConfig.Identity idConfig) throws LdapException, CursorException, ExternalIdentityException {
            this.searchFilter = searchFilter;
            this.idConfig = idConfig;
            this.findNextEntry();
        }

        @Override
        public boolean hasNext() {
            return this.pos >= 0;
        }

        @Override
        public Entry next() {
            if (this.hasNext()) {
                try {
                    Entry entry = (Entry)this.page.get(this.pos);
                    this.findNextEntry();
                    return entry;
                }
                catch (LdapException e) {
                    log.error("Error while performing LDAP search", (Throwable)e);
                }
                catch (CursorException e) {
                    log.error("Error while performing LDAP search", (Throwable)e);
                }
                catch (ExternalIdentityException e) {
                    log.error("Error while performing LDAP search", (Throwable)e);
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private SearchRequest createSearchRequest(LdapConnection connection, byte[] cookie, @Nonnull String[] userAttributes) throws LdapException {
            SearchRequestImpl req = new SearchRequestImpl();
            req.setScope(SearchScope.SUBTREE);
            if (userAttributes.length == 0) {
                req.addAttributes(new String[]{"*"});
            } else {
                req.addAttributes(userAttributes);
            }
            req.setTimeLimit((int)LdapIdentityProvider.this.config.getSearchTimeout());
            req.setBase(new Dn(new String[]{this.idConfig.getBaseDN()}));
            req.setFilter(this.searchFilter);
            PagedResultsDecorator pagedSearchControl = new PagedResultsDecorator(connection.getCodecService());
            pagedSearchControl.setSize(1000);
            pagedSearchControl.setCookie(cookie);
            req.addControl((Control)pagedSearchControl);
            return req;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean loadNextPage() throws ExternalIdentityException, LdapException, CursorException {
            if (this.searchComplete) {
                return false;
            }
            SearchCursor searchCursor = null;
            DebugTimer timer = new DebugTimer();
            LdapConnection connection = LdapIdentityProvider.this.connect();
            timer.mark("connect");
            this.page = new ArrayList();
            try {
                PagedResults ctrl;
                SearchRequest req = this.createSearchRequest(connection, this.cookie, LdapIdentityProvider.this.config.getCustomAttributes());
                if (log.isDebugEnabled()) {
                    log.debug("loadNextPage: using SearchRequest {}.", (Object)req);
                }
                searchCursor = connection.search(req);
                while (searchCursor.next()) {
                    Response response = (Response)searchCursor.get();
                    if (!(response instanceof SearchResultEntry)) continue;
                    Entry resultEntry = ((SearchResultEntry)response).getEntry();
                    this.page.add(resultEntry);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("loadNextPage: search below {} with {} found {}", new Object[]{this.idConfig.getBaseDN(), this.searchFilter, resultEntry.getDn()});
                }
                SearchResultDone done = searchCursor.getSearchResultDone();
                this.cookie = null;
                if (done.getLdapResult().getResultCode() != ResultCodeEnum.UNWILLING_TO_PERFORM && (ctrl = (PagedResults)done.getControl("1.2.840.113556.1.4.319")) != null) {
                    this.cookie = ctrl.getCookie();
                }
                this.searchComplete = this.cookie == null;
                timer.mark("lookup");
                boolean bl = !this.page.isEmpty();
                return bl;
            }
            finally {
                if (searchCursor != null) {
                    try {
                        searchCursor.close();
                    }
                    catch (IOException e) {
                        log.warn("Failed to close search cursor.", (Throwable)e);
                    }
                }
                LdapIdentityProvider.this.disconnect(connection);
            }
        }

        private void findNextEntry() throws LdapException, CursorException, ExternalIdentityException {
            if (this.pos == -1 && !this.loadNextPage()) {
                return;
            }
            if (this.pos + 1 == this.page.size()) {
                this.pos = -1;
                this.page = Collections.emptyList();
                if (!this.loadNextPage()) {
                    return;
                }
            }
            ++this.pos;
        }
    }
}

