/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.ldap.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class LdapIdentityProperties
extends HashMap<String, Object> {
    private final Map<String, String> keyMapping = new HashMap<String, String>();

    public LdapIdentityProperties(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public LdapIdentityProperties(int initialCapacity) {
        super(initialCapacity);
    }

    public LdapIdentityProperties() {
    }

    public LdapIdentityProperties(Map<? extends String, ?> m) {
        super(m);
        for (String string : m.keySet()) {
            this.keyMapping.put(this.convert(string), string);
        }
    }

    @Override
    public Object put(String key, Object value) {
        this.keyMapping.put(this.convert(key), key);
        return super.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        this.keyMapping.remove(this.convert(key));
        return super.remove(key);
    }

    @Override
    public Object get(Object key) {
        String realKey = this.keyMapping.get(this.convert(key));
        return realKey == null ? null : super.get(realKey);
    }

    @Override
    public boolean containsKey(Object key) {
        String realKey = this.keyMapping.get(this.convert(key));
        return realKey != null && super.containsKey(realKey);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        super.putAll(m);
        for (String string : m.keySet()) {
            this.keyMapping.put(this.convert(string), string);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.keyMapping.clear();
    }

    @CheckForNull
    private String convert(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        String key = obj instanceof String ? (String)obj : String.valueOf(obj);
        return key.toUpperCase(Locale.ENGLISH).toLowerCase(Locale.ENGLISH);
    }
}

