/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.ldap.impl;

import java.util.LinkedList;
import java.util.List;

public class DebugTimer {
    private static String[] units = new String[]{"ns", "us", "ms", "s"};
    private List<TimeStamp> timestamps = new LinkedList<TimeStamp>();
    private long now = System.nanoTime();

    public void mark(String msg) {
        long then = this.now;
        this.now = System.nanoTime();
        this.timestamps.add(new TimeStamp(this.now - then, msg));
    }

    public String getString() {
        if (this.timestamps.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (TimeStamp t : this.timestamps) {
            double time;
            if (b.length() > 0) {
                b.append(", ");
            } else {
                b.append('(');
            }
            int u = 0;
            for (time = (double)t.time; time > 1000.0 && u < units.length - 1; time /= 1000.0, ++u) {
            }
            b.append(String.format("%s=%.2f%s", t.msg, time, units[u]));
        }
        return b.append(')').toString();
    }

    private static final class TimeStamp {
        private final long time;
        private final String msg;

        private TimeStamp(long time, String msg) {
            this.time = time;
            this.msg = msg;
        }
    }
}

