/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.ldap.impl;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolableUnboundConnectionFactory
implements PoolableObjectFactory<LdapConnection> {
    private static final Logger log = LoggerFactory.getLogger(PoolableUnboundConnectionFactory.class);
    private LdapConnectionConfig config;

    public PoolableUnboundConnectionFactory(LdapConnectionConfig config) {
        this.config = config;
    }

    public void activateObject(LdapConnection connection) throws Exception {
        log.debug("activate connection: {}", (Object)connection);
    }

    public void destroyObject(LdapConnection connection) throws Exception {
        log.debug("destroy connection: {}", (Object)connection);
        connection.close();
    }

    public LdapConnection makeObject() throws Exception {
        TlsGuardingConnection connection = this.config.isUseTls() ? new TlsGuardingConnection(this.config) : new LdapNetworkConnection(this.config);
        connection.connect();
        log.debug("creating new connection: {}", (Object)connection);
        return connection;
    }

    public void passivateObject(LdapConnection connection) throws Exception {
        log.debug("passivate connection: {}", (Object)connection);
    }

    public boolean validateObject(LdapConnection connection) {
        boolean valid = false;
        if (connection.isConnected()) {
            try {
                valid = connection.lookup(Dn.ROOT_DSE, new String[]{"1.1"}) != null;
            }
            catch (LdapException le) {
                log.debug("error during connection validation: {}", (Object)le.toString());
            }
        }
        log.debug("validating connection {}: {}", (Object)connection, (Object)valid);
        return valid;
    }

    private static class TlsGuardingConnection
    extends LdapNetworkConnection {
        private boolean tlsStarted;

        private TlsGuardingConnection(LdapConnectionConfig config) {
            super(config);
        }

        public void startTls() throws LdapException {
            if (this.tlsStarted) {
                return;
            }
            super.startTls();
            this.tlsStarted = true;
        }
    }
}

