/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.ldap.impl;

import java.util.HashMap;
import java.util.Map;

public final class LdapSettings {
    public static final String KEY_HOST = "host";
    public static final String KEY_PORT = "port";
    public static final String KEY_SECURE = "secure";
    public static final String KEY_AUTHDN = "authDn";
    public static final String KEY_AUTHPW = "authPw";
    public static final String KEY_SEARCHTIMEOUT = "searchTimeout";
    public static final String KEY_USERROOT = "userRoot";
    public static final String KEY_USERFILTER = "userFilter";
    public static final String KEY_USERIDATTRIBUTE = "userIdAttribute";
    public static final String KEY_GROUPROOT = "groupRoot";
    public static final String KEY_GROUPFILTER = "groupFilter";
    public static final String KEY_GROUPMEMBERSHIPATTRIBUTE = "groupMembershipAttribute";
    public static final String KEY_GROUPNAMEATTRIBUTE = "groupNameAttribute";
    public static final String KEY_AUTOCREATEPATH = "autocreate.path";
    public static final String KEY_AUTOCREATEUSER = "autocreate.user.";
    public static final String KEY_AUTOCREATEGROUP = "autocreate.group.";
    private String host;
    private int port = 389;
    private boolean secure = false;
    private String authDn = "";
    private String authPw = "";
    private int searchTimeout = 60000;
    private String userRoot = "";
    private String userFilter = "(objectclass=person)";
    private String userIdAttribute = "uid";
    private String groupRoot = "";
    private String groupFilter = "(objectclass=groupOfUniqueNames)";
    private String groupMembershipAttribute = "uniquemember";
    private String groupNameAttribute = "cn";
    private boolean splitPath = false;
    private final Map<String, String> userAttributes = new HashMap<String, String>();
    private final Map<String, String> groupAttributes = new HashMap<String, String>();

    public LdapSettings(Map<String, ?> options) {
        String s;
        if (options.containsKey(KEY_HOST)) {
            this.host = (String)options.get(KEY_HOST);
        }
        if (options.containsKey(KEY_PORT) && (s = (String)options.get(KEY_PORT)) != null && s.length() > 0) {
            this.port = Integer.parseInt(s);
        }
        if (options.containsKey(KEY_SECURE) && (s = (String)options.get(KEY_SECURE)) != null && s.length() > 0) {
            this.secure = Boolean.parseBoolean(s);
        }
        if (options.containsKey(KEY_AUTHDN)) {
            this.authDn = (String)options.get(KEY_AUTHDN);
        }
        if (options.containsKey(KEY_AUTHPW)) {
            this.authPw = (String)options.get(KEY_AUTHPW);
        }
        if (options.containsKey(KEY_SEARCHTIMEOUT) && (s = (String)options.get(KEY_SEARCHTIMEOUT)) != null && s.length() > 0) {
            this.searchTimeout = Integer.parseInt(s);
        }
        if (options.containsKey(KEY_USERROOT)) {
            this.userRoot = (String)options.get(KEY_USERROOT);
        }
        if (options.containsKey(KEY_USERFILTER)) {
            this.userFilter = (String)options.get(KEY_USERFILTER);
        }
        if (options.containsKey(KEY_USERIDATTRIBUTE)) {
            this.userIdAttribute = (String)options.get(KEY_USERIDATTRIBUTE);
        }
        if (options.containsKey(KEY_GROUPROOT)) {
            this.groupRoot = (String)options.get(KEY_GROUPROOT);
        }
        if (options.containsKey(KEY_GROUPFILTER)) {
            this.groupFilter = (String)options.get(KEY_GROUPFILTER);
        }
        if (options.containsKey(KEY_GROUPMEMBERSHIPATTRIBUTE)) {
            this.groupMembershipAttribute = (String)options.get(KEY_GROUPMEMBERSHIPATTRIBUTE);
        }
        if (options.containsKey(KEY_GROUPNAMEATTRIBUTE)) {
            this.groupNameAttribute = (String)options.get(KEY_GROUPNAMEATTRIBUTE);
        }
        if (options.containsKey(KEY_AUTOCREATEPATH)) {
            this.splitPath = "splitdn".equals(options.get(KEY_AUTOCREATEPATH));
        }
        for (String key : options.keySet()) {
            if (key.startsWith(KEY_AUTOCREATEUSER)) {
                this.userAttributes.put(key.substring(KEY_AUTOCREATEUSER.length()), (String)options.get(key));
            }
            if (!key.startsWith(KEY_AUTOCREATEGROUP)) continue;
            this.groupAttributes.put(key.substring(KEY_AUTOCREATEGROUP.length()), (String)options.get(key));
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getAuthDn() {
        return this.authDn;
    }

    public String getAuthPw() {
        return this.authPw;
    }

    public int getSearchTimeout() {
        return this.searchTimeout;
    }

    public String getUserRoot() {
        return this.userRoot;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public String getUserIdAttribute() {
        return this.userIdAttribute;
    }

    public String getGroupRoot() {
        return this.groupRoot;
    }

    public String getGroupFilter() {
        return this.groupFilter;
    }

    public String getGroupMembershipAttribute() {
        return this.groupMembershipAttribute;
    }

    public String getGroupNameAttribute() {
        return this.groupNameAttribute;
    }

    public boolean isSplitPath() {
        return this.splitPath;
    }

    public Map<String, String> getUserAttributes() {
        return this.userAttributes;
    }

    public Map<String, String> getGroupAttributes() {
        return this.groupAttributes;
    }
}

