/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.ldap.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.net.ssl.TrustManager;
import javax.security.auth.login.LoginException;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionPool;
import org.apache.directory.ldap.client.api.NoVerificationTrustManager;
import org.apache.directory.ldap.client.api.PoolableLdapConnectionFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.DebugTimer;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapGroup;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapProviderConfig;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapUser;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.PoolableUnboundConnectionFactory;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.UnboundLdapConnectionPool;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalGroup;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalUser;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service
public class LdapIdentityProvider
implements ExternalIdentityProvider {
    private static final Logger log = LoggerFactory.getLogger(LdapIdentityProvider.class);
    private LdapProviderConfig config;
    private LdapConnectionPool adminPool;
    private PoolableLdapConnectionFactory adminConnectionFactory;
    private UnboundLdapConnectionPool userPool;
    private PoolableUnboundConnectionFactory userConnectionFactory;

    public LdapIdentityProvider() {
    }

    public LdapIdentityProvider(LdapProviderConfig config) {
        this.config = config;
        this.init();
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        ConfigurationParameters cfg = ConfigurationParameters.of(properties);
        this.config = LdapProviderConfig.of(cfg);
        this.init();
    }

    @Deactivate
    private void deactivate() {
        this.close();
    }

    private void init() {
        if (this.adminConnectionFactory != null) {
            throw new IllegalStateException("Provider already initialized.");
        }
        LdapConnectionConfig cc = this.createConnectionConfig();
        if (!this.config.getBindDN().isEmpty()) {
            cc.setName(this.config.getBindDN());
            cc.setCredentials(this.config.getBindPassword());
        }
        this.adminConnectionFactory = new PoolableLdapConnectionFactory(cc);
        if (this.config.getAdminPoolConfig().getMaxActive() != 0) {
            this.adminPool = new LdapConnectionPool(this.adminConnectionFactory);
            this.adminPool.setTestOnBorrow(true);
            this.adminPool.setMaxActive(this.config.getAdminPoolConfig().getMaxActive());
            this.adminPool.setWhenExhaustedAction((byte)1);
        }
        cc = this.createConnectionConfig();
        this.userConnectionFactory = new PoolableUnboundConnectionFactory(cc);
        if (this.config.getUserPoolConfig().getMaxActive() != 0) {
            this.userPool = new UnboundLdapConnectionPool(this.userConnectionFactory);
            this.userPool.setTestOnBorrow(true);
            this.userPool.setMaxActive(this.config.getUserPoolConfig().getMaxActive());
            this.userPool.setWhenExhaustedAction((byte)1);
        }
        log.info("LdapIdentityProvider initialized: {}", (Object)this.config);
    }

    @Nonnull
    private LdapConnectionConfig createConnectionConfig() {
        LdapConnectionConfig cc = new LdapConnectionConfig();
        cc.setLdapHost(this.config.getHostname());
        cc.setLdapPort(this.config.getPort());
        cc.setUseSsl(this.config.useSSL());
        cc.setUseTls(this.config.useTLS());
        if (this.config.noCertCheck()) {
            cc.setTrustManagers(new TrustManager[]{new NoVerificationTrustManager()});
        }
        return cc;
    }

    public void close() {
        if (this.adminPool != null) {
            try {
                this.adminPool.close();
            }
            catch (Exception e) {
                log.warn("Error while closing LDAP connection pool", (Throwable)e);
            }
            this.adminPool = null;
        }
        if (this.userPool != null) {
            try {
                this.userPool.close();
            }
            catch (Exception e) {
                log.warn("Error while closing LDAP connection pool", (Throwable)e);
            }
            this.userPool = null;
        }
    }

    @Nonnull
    public String getName() {
        return this.config.getName();
    }

    public ExternalIdentity getIdentity(@Nonnull ExternalIdentityRef ref) throws ExternalIdentityException {
        if (!this.isMyRef(ref)) {
            return null;
        }
        LdapConnection connection = this.connect();
        try {
            Entry entry = connection.lookup(ref.getId(), new String[]{"*"});
            if (entry == null) {
                ExternalIdentity externalIdentity = null;
                return externalIdentity;
            }
            if (entry.hasObjectClass(this.config.getUserConfig().getObjectClasses())) {
                ExternalUser externalUser = this.createUser(entry, null);
                return externalUser;
            }
            if (entry.hasObjectClass(this.config.getGroupConfig().getObjectClasses())) {
                ExternalGroup externalGroup = this.createGroup(entry, null);
                return externalGroup;
            }
            log.warn("referenced identity is neither user or group: {}", (Object)ref.getString());
            ExternalIdentity externalIdentity = null;
            return externalIdentity;
        }
        catch (LdapException e) {
            log.error("Error during ldap lookup", (Throwable)e);
            throw new ExternalIdentityException("Error during ldap lookup.", (Throwable)e);
        }
        finally {
            this.disconnect(connection);
        }
    }

    public ExternalUser getUser(@Nonnull String userId) throws ExternalIdentityException {
        DebugTimer timer = new DebugTimer();
        LdapConnection connection = this.connect();
        timer.mark("connect");
        try {
            Entry entry = this.getEntry(connection, this.config.getUserConfig(), userId);
            timer.mark("lookup");
            if (log.isDebugEnabled()) {
                log.debug("getUser({}) {}", (Object)userId, (Object)timer.getString());
            }
            if (entry != null) {
                ExternalUser externalUser = this.createUser(entry, userId);
                return externalUser;
            }
            ExternalUser externalUser = null;
            return externalUser;
        }
        catch (LdapException e) {
            log.error("Error during ldap lookup. " + timer.getString(), (Throwable)e);
            throw new ExternalIdentityException("Error during ldap lookup.", (Throwable)e);
        }
        catch (CursorException e) {
            log.error("Error during ldap lookup. " + timer.getString(), (Throwable)e);
            throw new ExternalIdentityException("Error during ldap lookup.", (Throwable)e);
        }
        finally {
            this.disconnect(connection);
        }
    }

    public ExternalGroup getGroup(@Nonnull String name) throws ExternalIdentityException {
        DebugTimer timer = new DebugTimer();
        LdapConnection connection = this.connect();
        timer.mark("connect");
        try {
            Entry entry = this.getEntry(connection, this.config.getGroupConfig(), name);
            timer.mark("lookup");
            if (log.isDebugEnabled()) {
                log.debug("getGroup({}) {}", (Object)name, (Object)timer.getString());
            }
            if (entry != null) {
                ExternalGroup externalGroup = this.createGroup(entry, name);
                return externalGroup;
            }
            ExternalGroup externalGroup = null;
            return externalGroup;
        }
        catch (LdapException e) {
            log.error("Error during ldap lookup. " + timer.getString(), (Throwable)e);
            throw new ExternalIdentityException("Error during ldap lookup.", (Throwable)e);
        }
        catch (CursorException e) {
            log.error("Error during ldap lookup. " + timer.getString(), (Throwable)e);
            throw new ExternalIdentityException("Error during ldap lookup.", (Throwable)e);
        }
        finally {
            this.disconnect(connection);
        }
    }

    public Iterator<ExternalUser> listUsers() throws ExternalIdentityException {
        DebugTimer timer = new DebugTimer();
        LdapConnection connection = this.connect();
        timer.mark("connect");
        try {
            final List<Entry> entries = this.getEntries(connection, this.config.getUserConfig());
            timer.mark("lookup");
            if (log.isDebugEnabled()) {
                log.debug("listUsers() {}", (Object)timer.getString());
            }
            AbstractLazyIterator<ExternalUser> abstractLazyIterator = new AbstractLazyIterator<ExternalUser>(){
                private final Iterator<Entry> iter;
                {
                    this.iter = entries.iterator();
                }

                protected ExternalUser getNext() {
                    while (this.iter.hasNext()) {
                        try {
                            return LdapIdentityProvider.this.createUser(this.iter.next(), null);
                        }
                        catch (LdapInvalidAttributeValueException e) {
                            log.warn("Error while creating external user object", (Throwable)e);
                        }
                    }
                    return null;
                }
            };
            return abstractLazyIterator;
        }
        catch (LdapException e) {
            log.error("Error during ldap lookup. " + timer.getString(), (Throwable)e);
            throw new ExternalIdentityException("Error during ldap lookup.", (Throwable)e);
        }
        catch (CursorException e) {
            log.error("Error during ldap lookup. " + timer.getString(), (Throwable)e);
            throw new ExternalIdentityException("Error during ldap lookup.", (Throwable)e);
        }
        finally {
            this.disconnect(connection);
        }
    }

    public Iterator<ExternalGroup> listGroups() throws ExternalIdentityException {
        DebugTimer timer = new DebugTimer();
        LdapConnection connection = this.connect();
        timer.mark("connect");
        try {
            final List<Entry> entries = this.getEntries(connection, this.config.getGroupConfig());
            timer.mark("lookup");
            if (log.isDebugEnabled()) {
                log.debug("listGroups() {}", (Object)timer.getString());
            }
            AbstractLazyIterator<ExternalGroup> abstractLazyIterator = new AbstractLazyIterator<ExternalGroup>(){
                private final Iterator<Entry> iter;
                {
                    this.iter = entries.iterator();
                }

                protected ExternalGroup getNext() {
                    while (this.iter.hasNext()) {
                        try {
                            return LdapIdentityProvider.this.createGroup(this.iter.next(), null);
                        }
                        catch (LdapInvalidAttributeValueException e) {
                            log.warn("Error while creating external user object", (Throwable)e);
                        }
                    }
                    return null;
                }
            };
            return abstractLazyIterator;
        }
        catch (LdapException e) {
            log.error("Error during ldap lookup. " + timer.getString(), (Throwable)e);
            throw new ExternalIdentityException("Error during ldap lookup.", (Throwable)e);
        }
        catch (CursorException e) {
            log.error("Error during ldap lookup. " + timer.getString(), (Throwable)e);
            throw new ExternalIdentityException("Error during ldap lookup.", (Throwable)e);
        }
        finally {
            this.disconnect(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getEntry(LdapConnection connection, LdapProviderConfig.Identity idConfig, String id) throws CursorException, LdapException {
        String searchFilter = idConfig.getSearchFilter(id);
        SearchRequestImpl req = new SearchRequestImpl();
        req.setScope(SearchScope.SUBTREE);
        req.addAttributes(new String[]{"*"});
        req.setTimeLimit((int)this.config.getSearchTimeout());
        req.setBase(new Dn(new String[]{idConfig.getBaseDN()}));
        req.setFilter(searchFilter);
        SearchCursor searchCursor = null;
        try {
            searchCursor = connection.search((SearchRequest)req);
            while (searchCursor.next()) {
                Response response = (Response)searchCursor.get();
                if (!(response instanceof SearchResultEntry)) continue;
                Entry resultEntry = ((SearchResultEntry)response).getEntry();
                if (searchCursor.next()) {
                    log.warn("search for {} returned more than one entry. discarding additional ones.", (Object)searchFilter);
                }
                if (log.isDebugEnabled()) {
                    log.debug("search below {} with {} found {}", new Object[]{idConfig.getBaseDN(), searchFilter, resultEntry.getDn()});
                }
                Entry entry = resultEntry;
                return entry;
            }
        }
        finally {
            if (searchCursor != null) {
                searchCursor.close();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("search below {} with {} found 0 entries.", (Object)idConfig.getBaseDN(), (Object)searchFilter);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Entry> getEntries(LdapConnection connection, LdapProviderConfig.Identity idConfig) throws CursorException, LdapException {
        StringBuilder filter = new StringBuilder();
        int num = 0;
        for (String objectClass : idConfig.getObjectClasses()) {
            ++num;
            filter.append("(objectclass=").append(LdapProviderConfig.encodeFilterValue(objectClass)).append(')');
        }
        String extraFilter = idConfig.getExtraFilter();
        if (extraFilter != null && extraFilter.length() > 0) {
            ++num;
            filter.append(extraFilter);
        }
        String searchFilter = num > 1 ? "(&" + filter + ")" : filter.toString();
        SearchRequestImpl req = new SearchRequestImpl();
        req.setScope(SearchScope.SUBTREE);
        req.addAttributes(new String[]{"*"});
        req.setTimeLimit((int)this.config.getSearchTimeout());
        req.setBase(new Dn(new String[]{idConfig.getBaseDN()}));
        req.setFilter(searchFilter);
        LinkedList<Entry> result = new LinkedList<Entry>();
        SearchCursor searchCursor = null;
        try {
            searchCursor = connection.search((SearchRequest)req);
            while (searchCursor.next()) {
                Response response = (Response)searchCursor.get();
                if (!(response instanceof SearchResultEntry)) continue;
                Entry resultEntry = ((SearchResultEntry)response).getEntry();
                result.add(resultEntry);
                if (!log.isDebugEnabled()) continue;
                log.debug("search below {} with {} found {}", new Object[]{idConfig.getBaseDN(), searchFilter, resultEntry.getDn()});
            }
        }
        finally {
            if (searchCursor != null) {
                searchCursor.close();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("search below {} with {} found {} entries.", new Object[]{idConfig.getBaseDN(), searchFilter, result.size()});
        }
        return result;
    }

    private ExternalUser createUser(Entry e, String id) throws LdapInvalidAttributeValueException {
        ExternalIdentityRef ref = new ExternalIdentityRef(e.getDn().getName(), this.getName());
        if (id == null) {
            id = e.get(this.config.getUserConfig().getIdAttribute()).getString();
        }
        String path = this.config.getUserConfig().makeDnPath() ? this.createDNPath(e.getDn()) : null;
        LdapUser user = new LdapUser(this, ref, id, path);
        Map<String, Object> props = user.getProperties();
        for (Attribute attr : e.getAttributes()) {
            if (!attr.isHumanReadable()) continue;
            props.put(attr.getId(), attr.getString());
        }
        return user;
    }

    private ExternalGroup createGroup(Entry e, String name) throws LdapInvalidAttributeValueException {
        ExternalIdentityRef ref = new ExternalIdentityRef(e.getDn().getName(), this.getName());
        if (name == null) {
            name = e.get(this.config.getGroupConfig().getIdAttribute()).getString();
        }
        String path = this.config.getGroupConfig().makeDnPath() ? this.createDNPath(e.getDn()) : null;
        LdapGroup group = new LdapGroup(this, ref, name, path);
        Map<String, Object> props = group.getProperties();
        for (Attribute attr : e.getAttributes()) {
            if (!attr.isHumanReadable()) continue;
            props.put(attr.getId(), attr.getString());
        }
        return group;
    }

    @Nonnull
    private LdapConnection connect() throws ExternalIdentityException {
        try {
            if (this.adminPool == null) {
                return this.adminConnectionFactory.makeObject();
            }
            return this.adminPool.getConnection();
        }
        catch (Throwable e) {
            log.error("Error while connecting to the ldap server.", e);
            throw new ExternalIdentityException("Error while connecting and binding to the ldap server", e);
        }
    }

    private void disconnect(@Nullable LdapConnection connection) throws ExternalIdentityException {
        try {
            if (connection != null) {
                if (this.adminPool == null) {
                    this.adminConnectionFactory.destroyObject(connection);
                } else {
                    this.adminPool.releaseConnection(connection);
                }
            }
        }
        catch (Exception e) {
            log.warn("Error while disconnecting from the ldap server.", (Throwable)e);
        }
    }

    public ExternalUser authenticate(@Nonnull Credentials credentials) throws ExternalIdentityException, LoginException {
        if (!(credentials instanceof SimpleCredentials)) {
            log.debug("LDAP IDP can only authenticate SimpleCredentials.");
            return null;
        }
        SimpleCredentials creds = (SimpleCredentials)credentials;
        ExternalUser user = this.getUser(creds.getUserID());
        if (user != null) {
            if (creds.getPassword().length == 0) {
                throw new LoginException("Refusing to authenticate against LDAP server: Empty passwords not allowed.");
            }
            LdapConnection connection = null;
            try {
                DebugTimer timer = new DebugTimer();
                connection = this.userPool == null ? this.userConnectionFactory.makeObject() : this.userPool.getConnection();
                timer.mark("connect");
                connection.bind(user.getExternalId().getId(), new String(creds.getPassword()));
                timer.mark("bind");
                if (log.isDebugEnabled()) {
                    log.debug("authenticate({}) {}", (Object)user.getId(), (Object)timer.getString());
                }
            }
            catch (LdapAuthenticationException e) {
                throw new LoginException("Unable to authenticate against LDAP server: " + e.getMessage());
            }
            catch (Exception e) {
                throw new ExternalIdentityException("Error while binding user credentials", (Throwable)e);
            }
            finally {
                if (connection != null) {
                    try {
                        if (this.userPool == null) {
                            this.userConnectionFactory.destroyObject(connection);
                        } else {
                            this.userPool.releaseConnection(connection);
                        }
                    }
                    catch (Exception e) {}
                }
            }
        }
        return user;
    }

    private boolean isMyRef(@Nonnull ExternalIdentityRef ref) {
        String refProviderName = ref.getProviderName();
        return refProviderName == null || refProviderName.length() == 0 || this.getName().equals(refProviderName);
    }

    public Map<String, ExternalIdentityRef> getDeclaredGroupRefs(ExternalIdentityRef ref) throws ExternalIdentityException {
        HashMap<String, ExternalIdentityRef> hashMap;
        LdapConnection connection;
        block8: {
            if (!this.isMyRef(ref)) {
                return Collections.emptyMap();
            }
            String searchFilter = this.config.getMemberOfSearchFilter(ref.getId());
            connection = null;
            SearchCursor searchCursor = null;
            try {
                SearchRequestImpl req = new SearchRequestImpl();
                req.setScope(SearchScope.SUBTREE);
                req.addAttributes(new String[]{"1.1"});
                req.setTimeLimit((int)this.config.getSearchTimeout());
                req.setBase(new Dn(new String[]{this.config.getGroupConfig().getBaseDN()}));
                req.setFilter(searchFilter);
                HashMap<String, ExternalIdentityRef> groups = new HashMap<String, ExternalIdentityRef>();
                DebugTimer timer = new DebugTimer();
                connection = this.connect();
                timer.mark("connect");
                searchCursor = connection.search((SearchRequest)req);
                timer.mark("search");
                while (searchCursor.next()) {
                    Response response = (Response)searchCursor.get();
                    if (!(response instanceof SearchResultEntry)) continue;
                    Entry resultEntry = ((SearchResultEntry)response).getEntry();
                    ExternalIdentityRef groupRef = new ExternalIdentityRef(resultEntry.getDn().toString(), this.getName());
                    groups.put(groupRef.getId(), groupRef);
                }
                timer.mark("iterate");
                if (log.isDebugEnabled()) {
                    log.debug("search below {} with {} found {} entries. {}", new Object[]{this.config.getGroupConfig().getBaseDN(), searchFilter, groups.size(), timer.getString()});
                }
                hashMap = groups;
                if (searchCursor == null) break block8;
            }
            catch (Exception e) {
                try {
                    log.error("Error during ldap membership search.", (Throwable)e);
                    throw new ExternalIdentityException("Error during ldap membership search.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (searchCursor != null) {
                        searchCursor.close();
                    }
                    this.disconnect(connection);
                    throw throwable;
                }
            }
            searchCursor.close();
        }
        this.disconnect(connection);
        return hashMap;
    }

    public Map<String, ExternalIdentityRef> getDeclaredMemberRefs(ExternalIdentityRef ref) throws ExternalIdentityException {
        HashMap<String, ExternalIdentityRef> hashMap;
        if (!this.isMyRef(ref)) {
            return Collections.emptyMap();
        }
        LdapConnection connection = null;
        try {
            HashMap<String, ExternalIdentityRef> members = new HashMap<String, ExternalIdentityRef>();
            DebugTimer timer = new DebugTimer();
            connection = this.connect();
            timer.mark("connect");
            Entry entry = connection.lookup(ref.getId());
            timer.mark("lookup");
            Attribute attr = entry.get(this.config.getGroupMemberAttribute());
            for (Value value : attr) {
                ExternalIdentityRef memberRef = new ExternalIdentityRef(value.getString(), this.getName());
                members.put(memberRef.getId(), memberRef);
            }
            timer.mark("iterate");
            if (log.isDebugEnabled()) {
                log.debug("members lookup of {} found {} members. {}", new Object[]{ref.getId(), members.size(), timer.getString()});
            }
            hashMap = members;
        }
        catch (Exception e) {
            try {
                log.error("Error during ldap group members lookup.", (Throwable)e);
                throw new ExternalIdentityException("Error during ldap group members lookup.", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.disconnect(connection);
                throw throwable;
            }
        }
        this.disconnect(connection);
        return hashMap;
    }

    public String createDNPath(Dn dn) {
        StringBuilder path = new StringBuilder();
        for (Rdn rnd : dn.getRdns()) {
            if (path.length() > 0) {
                path.append('/');
            }
            path.append(Text.escapeIllegalJcrChars((String)rnd.toString()));
        }
        return path.toString();
    }
}

