/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.ldap.impl;

import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapIdentityProperties;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;

public abstract class LdapIdentity
implements ExternalIdentity {
    protected final LdapIdentityProvider provider;
    protected final ExternalIdentityRef ref;
    protected final String id;
    protected final String path;
    private Map<String, ExternalIdentityRef> groups;
    private final LdapIdentityProperties properties = new LdapIdentityProperties();

    protected LdapIdentity(LdapIdentityProvider provider, ExternalIdentityRef ref, String id, String path) {
        this.provider = provider;
        this.ref = ref;
        this.id = id;
        this.path = path;
    }

    @Nonnull
    public ExternalIdentityRef getExternalId() {
        return this.ref;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getPrincipalName() {
        return this.ref.getId();
    }

    public String getIntermediatePath() {
        return this.path;
    }

    @Nonnull
    public Iterable<ExternalIdentityRef> getDeclaredGroups() throws ExternalIdentityException {
        if (this.groups == null) {
            this.groups = this.provider.getDeclaredGroupRefs(this.ref);
        }
        return this.groups.values();
    }

    @Nonnull
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "LdapIdentity{ref=" + this.ref + ", id='" + this.id + '\'' + '}';
    }
}

