/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.ldap.impl;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;

public class PoolableUnboundConnectionFactory
implements PoolableObjectFactory<LdapConnection> {
    private LdapConnectionConfig config;

    public PoolableUnboundConnectionFactory(LdapConnectionConfig config) {
        this.config = config;
    }

    public void activateObject(LdapConnection connection) throws Exception {
    }

    public void destroyObject(LdapConnection connection) throws Exception {
        connection.close();
    }

    public LdapConnection makeObject() throws Exception {
        TlsGuardingConnection connection = this.config.isUseTls() ? new TlsGuardingConnection(this.config) : new LdapNetworkConnection(this.config);
        connection.connect();
        return connection;
    }

    public void passivateObject(LdapConnection connection) throws Exception {
    }

    public boolean validateObject(LdapConnection connection) {
        return connection.isConnected();
    }

    private static class TlsGuardingConnection
    extends LdapNetworkConnection {
        private boolean tlsStarted;

        private TlsGuardingConnection(LdapConnectionConfig config) {
            super(config);
        }

        public void startTls() throws LdapException {
            if (this.tlsStarted) {
                return;
            }
            super.startTls();
            this.tlsStarted = true;
        }
    }
}

