/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.ldap.impl;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;

@Component(label="Apache Jackrabbit Oak LDAP Identity Provider", name="org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapIdentityProvider", configurationFactory=true, metatype=true, ds=false)
public class LdapProviderConfig {
    public static final String PARAM_NAME_DEFAULT = "ldap";
    @Property(label="LDAP Provider Name", description="Name of this LDAP provider configuration. This is used to reference this provider by the login modules.", value={"ldap"})
    public static final String PARAM_NAME = "provider.name";
    public static final String PARAM_LDAP_HOST_DEFAULT = "localhost";
    @Property(label="LDAP Server Hostname", description="Hostname of the LDAP server", value={"localhost"})
    public static final String PARAM_LDAP_HOST = "host.name";
    public static final int PARAM_LDAP_PORT_DEFAULT = 389;
    @Property(label="LDAP Server Port", description="Port of the LDAP server", intValue={389})
    public static final String PARAM_LDAP_PORT = "host.port";
    public static final boolean PARAM_USE_SSL_DEFAULT = false;
    @Property(label="Use SSL", description="Indicates if an SSL (LDAPs) connection should be used.", boolValue={false})
    public static final String PARAM_USE_SSL = "host.ssl";
    public static final boolean PARAM_USE_TLS_DEFAULT = false;
    @Property(label="Use TLS", description="Indicates if TLS should be started on connections.", boolValue={false})
    public static final String PARAM_USE_TLS = "host.tls";
    public static final boolean PARAM_NO_CERT_CHECK_DEFAULT = false;
    @Property(label="Disable certificate checking", description="Indicates if server certificate validation should be disabled.", boolValue={false})
    public static final String PARAM_NO_CERT_CHECK = "host.noCertCheck";
    public static final String PARAM_BIND_DN_DEFAULT = "";
    @Property(label="Bind DN", description="DN of the user for authentication. Leave empty for anonymous bind.", value={""})
    public static final String PARAM_BIND_DN = "bind.dn";
    public static final String PARAM_BIND_PASSWORD_DEFAULT = "";
    @Property(label="Bind Password", description="Password of the user for authentication.", passwordValue={""})
    public static final String PARAM_BIND_PASSWORD = "bind.password";
    public static final int PARAM_SEARCH_TIMEOUT_DEFAULT = 60000;
    @Property(label="Search Timeout", description="Time in milliseconds until a search times out.", intValue={60000})
    public static final String PARAM_SEARCH_TIMEOUT = "searchTimeout";
    public static final String PARAM_USER_BASE_DN_DEFAULT = "ou=people,o=example,dc=com";
    @Property(label="User base DN", description="The base DN for user searches.", value={"ou=people,o=example,dc=com"})
    public static final String PARAM_USER_BASE_DN = "user.baseDN";
    public static final String[] PARAM_USER_OBJECTCLASS_DEFAULT = new String[]{"person"};
    @Property(label="User object classes", description="The list of object classes an user entry must contain.", value={"person"}, cardinality=0x7FFFFFFF)
    public static final String PARAM_USER_OBJECTCLASS = "user.objectclass";
    public static final String PARAM_USER_ID_ATTRIBUTE_DEFAULT = "uid";
    @Property(label="User id attribute", description="Name of the attribute that contains the user id.", value={"uid"})
    public static final String PARAM_USER_ID_ATTRIBUTE = "user.idAttribute";
    public static final String PARAM_USER_EXTRA_FILTER_DEFAULT = "";
    @Property(label="User extra filter", description="Extra LDAP filter to use when searching for users. The final filter isformatted like: '(&(<idAttr>=<userId>)(objectclass=<objectclass>)<extraFilter>)'", value={""})
    public static final String PARAM_USER_EXTRA_FILTER = "user.extraFilter";
    public static final boolean PARAM_USER_MAKE_DN_PATH_DEFAULT = false;
    @Property(label="User DN paths", description="Controls if the DN should be used for calculating a portion of the intermediate path.", boolValue={false})
    public static final String PARAM_USER_MAKE_DN_PATH = "user.makeDnPath";
    public static final String PARAM_GROUP_BASE_DN_DEFAULT = "ou=groups,o=example,dc=com";
    @Property(label="Group base DN", description="The base DN for group searches.", value={"ou=groups,o=example,dc=com"})
    public static final String PARAM_GROUP_BASE_DN = "group.baseDN";
    public static final String[] PARAM_GROUP_OBJECTCLASS_DEFAULT = new String[]{"groupOfUniqueNames"};
    @Property(label="Group object classes", description="The list of object classes a group entry must contain.", value={"groupOfUniqueNames"}, cardinality=0x7FFFFFFF)
    public static final String PARAM_GROUP_OBJECTCLASS = "group.objectclass";
    public static final String PARAM_GROUP_NAME_ATTRIBUTE_DEFAULT = "cn";
    @Property(label="Group name attribute", description="Name of the attribute that contains the group name.", value={"cn"})
    public static final String PARAM_GROUP_NAME_ATTRIBUTE = "group.nameAttribute";
    public static final String PARAM_GROUP_EXTRA_FILTER_DEFAULT = "";
    @Property(label="Group extra filter", description="Extra LDAP filter to use when searching for groups. The final filter isformatted like: '(&(<nameAttr>=<groupName>)(objectclass=<objectclass>)<extraFilter>)'", value={""})
    public static final String PARAM_GROUP_EXTRA_FILTER = "group.extraFilter";
    public static final boolean PARAM_GROUP_MAKE_DN_PATH_DEFAULT = false;
    @Property(label="Group DN paths", description="Controls if the DN should be used for calculating a portion of the intermediate path.", boolValue={false})
    public static final String PARAM_GROUP_MAKE_DN_PATH = "group.makeDnPath";
    public static final String PARAM_GROUP_MEMBER_ATTRIBUTE_DEFAULT = "uniquemember";
    @Property(label="Group member attribute", description="Group attribute that contains the member(s) of a group.", value={"uniquemember"})
    public static final String PARAM_GROUP_MEMBER_ATTRIBUTE = "group.memberAttribute";
    private String name = "ldap";
    private String hostname = "localhost";
    private int port = 389;
    private boolean useSSL = false;
    private boolean useTLS = false;
    private boolean noCertCheck = false;
    private String bindDN = "";
    private String bindPassword = "";
    private int searchTimeout = 60000;
    private String groupMemberAttribute = "group.memberAttribute";
    private String memberOfFilterTemplate;
    private final Identity userConfig = new Identity().setBaseDN("ou=people,o=example,dc=com").setExtraFilter("").setIdAttribute("uid").setMakeDnPath(false).setObjectClasses(PARAM_USER_OBJECTCLASS_DEFAULT);
    private final Identity groupConfig = new Identity().setBaseDN("ou=groups,o=example,dc=com").setExtraFilter("").setIdAttribute("cn").setMakeDnPath(false).setObjectClasses(PARAM_GROUP_OBJECTCLASS_DEFAULT);

    public static LdapProviderConfig of(ConfigurationParameters params) {
        LdapProviderConfig cfg = new LdapProviderConfig().setName((String)params.getConfigValue(PARAM_NAME, (Object)PARAM_NAME_DEFAULT)).setHostname((String)params.getConfigValue(PARAM_LDAP_HOST, (Object)PARAM_LDAP_HOST_DEFAULT)).setPort((Integer)params.getConfigValue(PARAM_LDAP_PORT, (Object)389)).setUseSSL((Boolean)params.getConfigValue(PARAM_USE_SSL, (Object)false)).setUseTLS((Boolean)params.getConfigValue(PARAM_USE_TLS, (Object)false)).setNoCertCheck((Boolean)params.getConfigValue(PARAM_NO_CERT_CHECK, (Object)false)).setBindDN((String)params.getConfigValue(PARAM_BIND_DN, (Object)"")).setBindPassword((String)params.getConfigValue(PARAM_BIND_PASSWORD, (Object)"")).setSearchTimeout((Integer)params.getConfigValue(PARAM_SEARCH_TIMEOUT, (Object)60000)).setGroupMemberAttribute((String)params.getConfigValue(PARAM_GROUP_MEMBER_ATTRIBUTE, (Object)PARAM_GROUP_MEMBER_ATTRIBUTE_DEFAULT));
        cfg.getUserConfig().setBaseDN((String)params.getConfigValue(PARAM_USER_BASE_DN, (Object)PARAM_USER_BASE_DN)).setIdAttribute((String)params.getConfigValue(PARAM_USER_ID_ATTRIBUTE, (Object)PARAM_USER_ID_ATTRIBUTE_DEFAULT)).setExtraFilter((String)params.getConfigValue(PARAM_USER_EXTRA_FILTER, (Object)"")).setObjectClasses((String[])params.getConfigValue(PARAM_USER_OBJECTCLASS, (Object)PARAM_USER_OBJECTCLASS_DEFAULT)).setMakeDnPath((Boolean)params.getConfigValue(PARAM_USER_MAKE_DN_PATH, (Object)false));
        cfg.getGroupConfig().setBaseDN((String)params.getConfigValue(PARAM_GROUP_BASE_DN, (Object)PARAM_GROUP_BASE_DN)).setIdAttribute((String)params.getConfigValue(PARAM_GROUP_NAME_ATTRIBUTE, (Object)PARAM_GROUP_NAME_ATTRIBUTE_DEFAULT)).setExtraFilter((String)params.getConfigValue(PARAM_GROUP_EXTRA_FILTER, (Object)"")).setObjectClasses((String[])params.getConfigValue(PARAM_GROUP_OBJECTCLASS, (Object)PARAM_GROUP_OBJECTCLASS_DEFAULT)).setMakeDnPath((Boolean)params.getConfigValue(PARAM_GROUP_MAKE_DN_PATH, (Object)false));
        return cfg;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public LdapProviderConfig setName(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getHostname() {
        return this.hostname;
    }

    @Nonnull
    public LdapProviderConfig setHostname(@Nonnull String hostname) {
        this.hostname = hostname;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    @Nonnull
    public LdapProviderConfig setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    @Nonnull
    public LdapProviderConfig setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
        return this;
    }

    public boolean useTLS() {
        return this.useTLS;
    }

    @Nonnull
    public LdapProviderConfig setUseTLS(boolean useTLS) {
        this.useTLS = useTLS;
        return this;
    }

    public boolean noCertCheck() {
        return this.noCertCheck;
    }

    @Nonnull
    public LdapProviderConfig setNoCertCheck(boolean noCertCheck) {
        this.noCertCheck = noCertCheck;
        return this;
    }

    @CheckForNull
    public String getBindDN() {
        return this.bindDN;
    }

    @Nonnull
    public LdapProviderConfig setBindDN(@Nullable String bindDN) {
        this.bindDN = bindDN;
        return this;
    }

    @CheckForNull
    public String getBindPassword() {
        return this.bindPassword;
    }

    @Nonnull
    public LdapProviderConfig setBindPassword(@Nullable String bindPassword) {
        this.bindPassword = bindPassword;
        return this;
    }

    public int getSearchTimeout() {
        return this.searchTimeout;
    }

    @Nonnull
    public LdapProviderConfig setSearchTimeout(int searchTimeout) {
        this.searchTimeout = searchTimeout;
        return this;
    }

    @Nonnull
    public String getGroupMemberAttribute() {
        return this.groupMemberAttribute;
    }

    @Nonnull
    public LdapProviderConfig setGroupMemberAttribute(@Nonnull String groupMemberAttribute) {
        this.groupMemberAttribute = groupMemberAttribute;
        return this;
    }

    public String getMemberOfSearchFilter(@Nonnull String dn) {
        if (this.memberOfFilterTemplate == null) {
            StringBuilder filter = new StringBuilder("(&(").append(this.groupMemberAttribute).append("=%s)");
            for (String objectClass : this.groupConfig.objectClasses) {
                filter.append("(objectclass=").append(LdapProviderConfig.encodeFilterValue(objectClass)).append(')');
            }
            if (this.groupConfig.extraFilter != null && this.groupConfig.extraFilter.length() > 0) {
                filter.append(this.groupConfig.extraFilter);
            }
            filter.append(')');
            this.memberOfFilterTemplate = filter.toString();
        }
        return String.format(this.memberOfFilterTemplate, LdapProviderConfig.encodeFilterValue(dn));
    }

    @Nonnull
    public Identity getUserConfig() {
        return this.userConfig;
    }

    @Nonnull
    public Identity getGroupConfig() {
        return this.groupConfig;
    }

    private static String encodeFilterValue(String value) {
        StringBuilder sb = null;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            String replace = null;
            switch (ch) {
                case '*': {
                    replace = "\\2A";
                    break;
                }
                case '(': {
                    replace = "\\28";
                    break;
                }
                case ')': {
                    replace = "\\29";
                    break;
                }
                case '\\': {
                    replace = "\\5C";
                    break;
                }
                case '\u0000': {
                    replace = "\\00";
                }
            }
            if (replace != null) {
                if (sb == null) {
                    sb = new StringBuilder(value.length() * 2);
                    sb.append(value.substring(0, i));
                }
                sb.append(replace);
                continue;
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        return sb == null ? value : sb.toString();
    }

    public class Identity {
        private String baseDN;
        private String[] objectClasses;
        private String idAttribute;
        private String extraFilter;
        private String filterTemplate;
        private boolean makeDnPath;

        @Nonnull
        public String getBaseDN() {
            return this.baseDN;
        }

        @Nonnull
        public Identity setBaseDN(@Nonnull String baseDN) {
            this.baseDN = baseDN;
            return this;
        }

        @Nonnull
        public String[] getObjectClasses() {
            return this.objectClasses;
        }

        @Nonnull
        public Identity setObjectClasses(String ... objectClasses) {
            this.objectClasses = objectClasses;
            this.filterTemplate = null;
            LdapProviderConfig.this.memberOfFilterTemplate = null;
            return this;
        }

        @Nonnull
        public String getIdAttribute() {
            return this.idAttribute;
        }

        @Nonnull
        public Identity setIdAttribute(@Nonnull String idAttribute) {
            this.idAttribute = idAttribute;
            this.filterTemplate = null;
            LdapProviderConfig.this.memberOfFilterTemplate = null;
            return this;
        }

        @CheckForNull
        public String getExtraFilter() {
            return this.extraFilter;
        }

        @Nonnull
        public Identity setExtraFilter(@Nullable String extraFilter) {
            this.extraFilter = extraFilter;
            this.filterTemplate = null;
            LdapProviderConfig.this.memberOfFilterTemplate = null;
            return this;
        }

        public boolean makeDnPath() {
            return this.makeDnPath;
        }

        @Nonnull
        public Identity setMakeDnPath(boolean makeDnPath) {
            this.makeDnPath = makeDnPath;
            return this;
        }

        @Nonnull
        public String getSearchFilter(@Nonnull String id) {
            if (this.filterTemplate == null) {
                StringBuilder filter = new StringBuilder("(&(").append(this.idAttribute).append("=%s)");
                for (String objectClass : this.objectClasses) {
                    filter.append("(objectclass=").append(LdapProviderConfig.encodeFilterValue(objectClass)).append(')');
                }
                if (this.extraFilter != null && this.extraFilter.length() > 0) {
                    filter.append(this.extraFilter);
                }
                filter.append(')');
                this.filterTemplate = filter.toString();
            }
            return String.format(this.filterTemplate, LdapProviderConfig.encodeFilterValue(id));
        }
    }
}

