/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.SyncHandlerMapping;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalGroupPrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalIdentityImporter;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalIdentityRepositoryInitializer;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalIdentityValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.principal.EmptyPrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalManagerImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Jackrabbit Oak External PrincipalConfiguration", immediate=true)
@Service(value={PrincipalConfiguration.class, SecurityConfiguration.class})
@Properties(value={@Property(name="protectExternalId", label="External Identity Protection", description="If disabled rep:externalId properties won't be properly protected (backwards compatible behavior). NOTE: for security reasons it is strongly recommend to keep the protection enabled!", boolValue={true}), @Property(name="oak.security.name", propertyPrivate=true, value={"org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalPrincipalConfiguration"})})
public class ExternalPrincipalConfiguration
extends ConfigurationBase
implements PrincipalConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ExternalPrincipalConfiguration.class);
    private SyncConfigTracker syncConfigTracker;
    private SyncHandlerMappingTracker syncHandlerMappingTracker;

    public ExternalPrincipalConfiguration() {
    }

    public ExternalPrincipalConfiguration(SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.principal"));
    }

    @NotNull
    public PrincipalManager getPrincipalManager(Root root, NamePathMapper namePathMapper) {
        return new PrincipalManagerImpl(this.getPrincipalProvider(root, namePathMapper));
    }

    @NotNull
    public PrincipalProvider getPrincipalProvider(Root root, NamePathMapper namePathMapper) {
        if (this.dynamicMembershipEnabled()) {
            UserConfiguration uc = (UserConfiguration)this.getSecurityProvider().getConfiguration(UserConfiguration.class);
            return new ExternalGroupPrincipalProvider(root, uc, namePathMapper, this.syncConfigTracker.getAutoMembership());
        }
        return EmptyPrincipalProvider.INSTANCE;
    }

    @NotNull
    public String getName() {
        return "org.apache.jackrabbit.oak.principal";
    }

    @NotNull
    public RepositoryInitializer getRepositoryInitializer() {
        return new ExternalIdentityRepositoryInitializer(this.protectedExternalIds());
    }

    @NotNull
    public List<? extends ValidatorProvider> getValidators(@NotNull String workspaceName, @NotNull Set<Principal> principals, @NotNull MoveTracker moveTracker) {
        return ImmutableList.of((Object)new ExternalIdentityValidatorProvider(principals, this.protectedExternalIds()));
    }

    @NotNull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        return ImmutableList.of((Object)new ExternalIdentityImporter());
    }

    @Activate
    private void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
        this.syncHandlerMappingTracker = new SyncHandlerMappingTracker(bundleContext);
        this.syncHandlerMappingTracker.open();
        this.syncConfigTracker = new SyncConfigTracker(bundleContext, this.syncHandlerMappingTracker);
        this.syncConfigTracker.open();
    }

    @Deactivate
    private void deactivate() {
        if (this.syncConfigTracker != null) {
            this.syncConfigTracker.close();
        }
        if (this.syncHandlerMappingTracker != null) {
            this.syncHandlerMappingTracker.close();
        }
    }

    private boolean dynamicMembershipEnabled() {
        return this.syncConfigTracker != null && this.syncConfigTracker.isEnabled;
    }

    private boolean protectedExternalIds() {
        return (Boolean)this.getParameters().getConfigValue("protectExternalId", (Object)true);
    }

    private static final class SyncHandlerMappingTracker
    extends ServiceTracker {
        private Map<ServiceReference, String[]> referenceMap = new HashMap<ServiceReference, String[]>();

        public SyncHandlerMappingTracker(@NotNull BundleContext context) {
            super(context, SyncHandlerMapping.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            this.addMapping(reference);
            return super.addingService(reference);
        }

        public void modifiedService(ServiceReference reference, Object service) {
            this.addMapping(reference);
            super.modifiedService(reference, service);
        }

        public void removedService(ServiceReference reference, Object service) {
            this.referenceMap.remove(reference);
            super.removedService(reference, service);
        }

        private void addMapping(ServiceReference reference) {
            String idpName = PropertiesUtil.toString((Object)reference.getProperty("idp.name"), null);
            String syncHandlerName = PropertiesUtil.toString((Object)reference.getProperty("sync.handlerName"), null);
            if (idpName != null && syncHandlerName != null) {
                this.referenceMap.put(reference, new String[]{syncHandlerName, idpName});
            } else {
                log.warn("Ignoring SyncHandlerMapping with incomplete mapping of IDP '{}' and SyncHandler '{}'", (Object)idpName, (Object)syncHandlerName);
            }
        }

        private Iterable<String> getIdpNames(final @NotNull String syncHandlerName) {
            return Iterables.filter((Iterable)Iterables.transform(this.referenceMap.values(), (Function)new Function<String[], String>(){

                @Nullable
                public String apply(@Nullable String[] input) {
                    if (input != null && input.length == 2) {
                        if (syncHandlerName.equals(input[0])) {
                            return input[1];
                        }
                    } else {
                        log.warn("Unexpected value of reference map. Expected String[] with length = 2");
                    }
                    return null;
                }
            }), (Predicate)Predicates.notNull());
        }
    }

    private static final class SyncConfigTracker
    extends ServiceTracker {
        private final SyncHandlerMappingTracker mappingTracker;
        private Set<ServiceReference> enablingRefs = new HashSet<ServiceReference>();
        private boolean isEnabled = false;

        public SyncConfigTracker(@NotNull BundleContext context, @NotNull SyncHandlerMappingTracker mappingTracker) {
            super(context, SyncHandler.class.getName(), null);
            this.mappingTracker = mappingTracker;
        }

        public Object addingService(ServiceReference reference) {
            if (SyncConfigTracker.hasDynamicMembership(reference)) {
                this.enablingRefs.add(reference);
                this.isEnabled = true;
            }
            return super.addingService(reference);
        }

        public void modifiedService(ServiceReference reference, Object service) {
            if (SyncConfigTracker.hasDynamicMembership(reference)) {
                this.enablingRefs.add(reference);
                this.isEnabled = true;
            } else {
                this.enablingRefs.remove(reference);
                this.isEnabled = !this.enablingRefs.isEmpty();
            }
            super.modifiedService(reference, service);
        }

        public void removedService(ServiceReference reference, Object service) {
            this.enablingRefs.remove(reference);
            this.isEnabled = !this.enablingRefs.isEmpty();
            super.removedService(reference, service);
        }

        private static boolean hasDynamicMembership(ServiceReference reference) {
            return PropertiesUtil.toBoolean((Object)reference.getProperty("user.dynamicMembership"), (boolean)false);
        }

        private Map<String, String[]> getAutoMembership() {
            HashMap<String, String[]> autoMembership = new HashMap<String, String[]>();
            for (ServiceReference ref : this.enablingRefs) {
                String syncHandlerName = PropertiesUtil.toString((Object)ref.getProperty("handler.name"), (String)"default");
                Object[] userAuthMembership = PropertiesUtil.toStringArray((Object)ref.getProperty("user.autoMembership"), (String[])new String[0]);
                Object[] groupAuthMembership = PropertiesUtil.toStringArray((Object)ref.getProperty("group.autoMembership"), (String[])new String[0]);
                Object[] membership = (String[])ObjectArrays.concat((Object[])userAuthMembership, (Object[])groupAuthMembership, String.class);
                for (String idpName : this.mappingTracker.getIdpNames(syncHandlerName)) {
                    Object[] previous = autoMembership.put(idpName, (String[])membership);
                    if (previous == null) continue;
                    String msg = Arrays.equals(previous, membership) ? "Duplicate" : "Colliding";
                    log.debug(msg + " auto-membership configuration for IDP '{}'; replacing previous values {} by {} defined by SyncHandler '{}'", new Object[]{idpName, Arrays.toString(previous), Arrays.toString(membership), syncHandlerName});
                }
            }
            return autoMembership;
        }
    }
}

