/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import javax.annotation.Nonnull;
import javax.jcr.Session;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.ExternalIdentityConstants;
import org.apache.jackrabbit.oak.spi.security.principal.SystemPrincipal;
import org.apache.jackrabbit.oak.spi.xml.PropInfo;
import org.apache.jackrabbit.oak.spi.xml.ProtectedPropertyImporter;
import org.apache.jackrabbit.oak.spi.xml.ReferenceChangeTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalIdentityImporter
implements ProtectedPropertyImporter,
ExternalIdentityConstants {
    private static final Logger log = LoggerFactory.getLogger(ExternalIdentityImporter.class);
    private boolean isSystemSession;

    ExternalIdentityImporter() {
    }

    public boolean init(@Nonnull Session session, @Nonnull Root root, @Nonnull NamePathMapper namePathMapper, boolean isWorkspaceImport, int uuidBehavior, @Nonnull ReferenceChangeTracker referenceTracker, @Nonnull SecurityProvider securityProvider) {
        this.isSystemSession = root.getContentSession().getAuthInfo().getPrincipals().contains(SystemPrincipal.INSTANCE);
        return true;
    }

    public void processReferences() {
    }

    public boolean handlePropInfo(@Nonnull Tree parent, @Nonnull PropInfo protectedPropInfo, @Nonnull PropertyDefinition def) {
        return false;
    }

    public void propertiesCompleted(@Nonnull Tree protectedParent) {
        if (!this.isSystemSession && protectedParent.hasProperty("rep:externalPrincipalNames")) {
            log.debug("Found reserved property rep:externalPrincipalNames managed by the system => Removed from imported scope.");
            protectedParent.removeProperty("rep:externalPrincipalNames");
            protectedParent.removeProperty("rep:lastSynced");
        }
    }
}

