/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx;

import javax.annotation.Nonnull;
import javax.jcr.Repository;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProviderManager;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncManager;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx.Delegatee;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx.SynchronizationMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncMBeanImpl
implements SynchronizationMBean {
    private static final Logger log = LoggerFactory.getLogger(SyncMBeanImpl.class);
    private final Repository repository;
    private final SyncManager syncManager;
    private final String syncName;
    private final ExternalIdentityProviderManager idpManager;
    private final String idpName;

    public SyncMBeanImpl(Repository repository, SyncManager syncManager, String syncName, ExternalIdentityProviderManager idpManager, String idpName) {
        this.repository = repository;
        this.syncManager = syncManager;
        this.syncName = syncName;
        this.idpManager = idpManager;
        this.idpName = idpName;
    }

    @Nonnull
    private Delegatee getDelegatee() {
        SyncHandler handler = this.syncManager.getSyncHandler(this.syncName);
        if (handler == null) {
            log.error("No sync manager available for name {}.", (Object)this.syncName);
            throw new IllegalArgumentException("No sync manager available for name " + this.syncName);
        }
        ExternalIdentityProvider idp = this.idpManager.getProvider(this.idpName);
        if (idp == null) {
            log.error("No idp available for name", (Object)this.idpName);
            throw new IllegalArgumentException("No idp manager available for name " + this.idpName);
        }
        return Delegatee.createInstance(this.repository, handler, idp);
    }

    @Override
    @Nonnull
    public String getSyncHandlerName() {
        return this.syncName;
    }

    @Override
    @Nonnull
    public String getIDPName() {
        return this.idpName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String[] syncUsers(@Nonnull String[] userIds, boolean purge) {
        Delegatee delegatee = this.getDelegatee();
        try {
            String[] stringArray = delegatee.syncUsers(userIds, purge);
            return stringArray;
        }
        finally {
            delegatee.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String[] syncAllUsers(boolean purge) {
        Delegatee delegatee = this.getDelegatee();
        try {
            String[] stringArray = delegatee.syncAllUsers(purge);
            return stringArray;
        }
        finally {
            delegatee.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String[] syncExternalUsers(@Nonnull String[] externalIds) {
        Delegatee delegatee = this.getDelegatee();
        try {
            String[] stringArray = delegatee.syncExternalUsers(externalIds);
            return stringArray;
        }
        finally {
            delegatee.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String[] syncAllExternalUsers() {
        Delegatee delegatee = this.getDelegatee();
        try {
            String[] stringArray = delegatee.syncAllExternalUsers();
            return stringArray;
        }
        finally {
            delegatee.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String[] listOrphanedUsers() {
        Delegatee delegatee = this.getDelegatee();
        try {
            String[] stringArray = delegatee.listOrphanedUsers();
            return stringArray;
        }
        finally {
            delegatee.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String[] purgeOrphanedUsers() {
        Delegatee delegatee = this.getDelegatee();
        try {
            String[] stringArray = delegatee.purgeOrphanedUsers();
            return stringArray;
        }
        finally {
            delegatee.close();
        }
    }
}

