/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.json.JsonUtil;
import org.apache.jackrabbit.oak.spi.security.authentication.SystemSubject;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalUser;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncResult;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncedIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncResultImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncedIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx.SyncRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Delegatee {
    private static final Logger log = LoggerFactory.getLogger(Delegatee.class);
    private static final String ERROR_CREATE_DELEGATEE = "Unable to create delegatee";
    private static final String ERROR_SYNC_USER = "Error while syncing user {}";
    private final SyncHandler handler;
    private final ExternalIdentityProvider idp;
    private final UserManager userMgr;
    private final Session systemSession;
    private SyncContext context;

    private Delegatee(@Nonnull SyncHandler handler, @Nonnull ExternalIdentityProvider idp, @Nonnull JackrabbitSession systemSession) throws SyncException, RepositoryException {
        this.handler = handler;
        this.idp = idp;
        this.systemSession = systemSession;
        this.userMgr = systemSession.getUserManager();
        this.context = handler.createContext(idp, this.userMgr, systemSession.getValueFactory());
        log.info("Created delegatee for SyncMBean with session: {} {}", (Object)systemSession, (Object)systemSession.getUserID());
    }

    static Delegatee createInstance(final @Nonnull Repository repository, @Nonnull SyncHandler handler, @Nonnull ExternalIdentityProvider idp) {
        Session systemSession;
        try {
            systemSession = Subject.doAs(SystemSubject.INSTANCE, new PrivilegedExceptionAction<Session>(){

                @Override
                public Session run() throws RepositoryException {
                    if (repository instanceof JackrabbitRepository) {
                        return ((JackrabbitRepository)repository).login(null, null, null);
                    }
                    return repository.login(null, null);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new SyncRuntimeException(ERROR_CREATE_DELEGATEE, e);
        }
        if (!(systemSession instanceof JackrabbitSession)) {
            systemSession.logout();
            throw new SyncRuntimeException("Unable to create SyncContext: JackrabbitSession required.");
        }
        try {
            return new Delegatee(handler, idp, (JackrabbitSession)systemSession);
        }
        catch (RepositoryException e) {
            systemSession.logout();
            throw new SyncRuntimeException(ERROR_CREATE_DELEGATEE, e);
        }
        catch (SyncException e) {
            systemSession.logout();
            throw new SyncRuntimeException(ERROR_CREATE_DELEGATEE, e);
        }
    }

    void close() {
        if (this.context != null) {
            this.context.close();
            this.context = null;
        }
        if (this.systemSession.isLive()) {
            this.systemSession.logout();
        }
    }

    @Nonnull
    String[] syncUsers(@Nonnull String[] userIds, boolean purge) {
        this.context.setKeepMissing(!purge).setForceGroupSync(true).setForceUserSync(true);
        ArrayList<String> list = new ArrayList<String>();
        for (String userId : userIds) {
            try {
                Delegatee.append(list, this.syncUser(userId));
            }
            catch (SyncException e) {
                log.warn(ERROR_SYNC_USER, (Object)userId, (Object)e);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Nonnull
    String[] syncAllUsers(boolean purge) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            this.context.setKeepMissing(!purge).setForceGroupSync(true).setForceUserSync(true);
            Iterator<SyncedIdentity> iter = this.handler.listIdentities(this.userMgr);
            while (iter.hasNext()) {
                SyncedIdentity id = iter.next();
                if (!this.isMyIDP(id)) continue;
                try {
                    Delegatee.append(list, this.syncUser(id.getId()));
                }
                catch (SyncException e) {
                    log.error(ERROR_SYNC_USER, (Object)id, (Object)e);
                    Delegatee.append(list, id, (Exception)e);
                }
            }
            return list.toArray(new String[list.size()]);
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Error retrieving users for syncing", e);
        }
    }

    @Nonnull
    String[] syncExternalUsers(@Nonnull String[] externalIds) {
        ArrayList<String> list = new ArrayList<String>();
        this.context.setForceGroupSync(true).setForceUserSync(true);
        for (String externalId : externalIds) {
            ExternalIdentityRef ref = ExternalIdentityRef.fromString(externalId);
            try {
                ExternalIdentity id = this.idp.getIdentity(ref);
                SyncResult r = id != null ? this.syncUser(id) : new DefaultSyncResultImpl(new DefaultSyncedIdentity("", ref, false, -1L), SyncResult.Status.NO_SUCH_IDENTITY);
                Delegatee.append(list, r);
            }
            catch (ExternalIdentityException e) {
                log.warn("error while fetching the external identity {}", (Object)externalId, (Object)e);
                Delegatee.append(list, ref, (Exception)e);
            }
            catch (SyncException e) {
                log.error(ERROR_SYNC_USER, (Object)ref, (Object)e);
                Delegatee.append(list, ref, (Exception)e);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Nonnull
    String[] syncAllExternalUsers() {
        ArrayList<String> list = new ArrayList<String>();
        this.context.setForceGroupSync(true).setForceUserSync(true);
        try {
            Iterator<ExternalUser> iter = this.idp.listUsers();
            while (iter.hasNext()) {
                ExternalUser user = iter.next();
                try {
                    SyncResult r = this.syncUser(user);
                    if (r.getIdentity() == null) {
                        r = new DefaultSyncResultImpl(new DefaultSyncedIdentity(user.getId(), user.getExternalId(), false, -1L), SyncResult.Status.NO_SUCH_IDENTITY);
                        log.warn("sync failed. {}", (Object)r.getIdentity());
                    } else {
                        log.info("synced {}", (Object)r.getIdentity());
                    }
                    Delegatee.append(list, r);
                }
                catch (SyncException e) {
                    log.error(ERROR_SYNC_USER, (Object)user, (Object)e);
                    Delegatee.append(list, user.getExternalId(), (Exception)e);
                }
            }
            return list.toArray(new String[list.size()]);
        }
        catch (ExternalIdentityException e) {
            throw new SyncRuntimeException("Unable to retrieve external users", e);
        }
    }

    @Nonnull
    String[] listOrphanedUsers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Iterator<SyncedIdentity> iter = this.handler.listIdentities(this.userMgr);
            while (iter.hasNext()) {
                SyncedIdentity id = iter.next();
                if (!this.isMyIDP(id)) continue;
                try {
                    ExternalIdentityRef ref = id.getExternalIdRef();
                    ExternalIdentity extId = ref == null ? null : this.idp.getIdentity(ref);
                    if (extId != null) continue;
                    list.add(id.getId());
                }
                catch (ExternalIdentityException e) {
                    log.error("Error while fetching external identity {}", (Object)id, (Object)e);
                }
            }
        }
        catch (RepositoryException e) {
            log.error("Error while listing orphaned users", (Throwable)e);
        }
        return list.toArray(new String[list.size()]);
    }

    @Nonnull
    String[] purgeOrphanedUsers() {
        this.context.setKeepMissing(false);
        ArrayList<String> list = new ArrayList<String>();
        for (String userId : this.listOrphanedUsers()) {
            try {
                Delegatee.append(list, this.syncUser(userId));
            }
            catch (SyncException e) {
                log.warn(ERROR_SYNC_USER, (Object)userId, (Object)e);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private boolean isMyIDP(@Nonnull SyncedIdentity id) {
        ExternalIdentityRef ref = id.getExternalIdRef();
        String providerName = ref == null ? null : ref.getProviderName();
        return providerName != null && (providerName.isEmpty() || providerName.equals(this.idp.getName()));
    }

    @Nonnull
    private SyncResult syncUser(@Nonnull ExternalIdentity id) throws SyncException {
        try {
            SyncResult r = this.context.sync(id);
            this.systemSession.save();
            return r;
        }
        catch (RepositoryException e) {
            throw new SyncException(e);
        }
    }

    @Nonnull
    private SyncResult syncUser(@Nonnull String userId) throws SyncException {
        try {
            SyncResult r = this.context.sync(userId);
            this.systemSession.save();
            return r;
        }
        catch (RepositoryException e) {
            throw new SyncException(e);
        }
    }

    private static void append(@Nonnull List<String> list, @Nonnull SyncResult r) {
        SyncedIdentity syncedIdentity = r.getIdentity();
        String uid = JsonUtil.getJsonString((String)(syncedIdentity == null ? null : syncedIdentity.getId()));
        ExternalIdentityRef externalIdentityRef = syncedIdentity == null ? null : syncedIdentity.getExternalIdRef();
        String eid = externalIdentityRef == null ? "\"\"" : JsonUtil.getJsonString((String)externalIdentityRef.getString());
        String jsonStr = String.format("{op:\"%s\",uid:%s,eid:%s}", Delegatee.getOperationFromStatus(r.getStatus()), uid, eid);
        list.add(jsonStr);
    }

    private static void append(@Nonnull List<String> list, @Nonnull ExternalIdentityRef idRef, @Nonnull Exception e) {
        String eid = JsonUtil.getJsonString((String)idRef.getString());
        String msg = JsonUtil.getJsonString((String)e.toString());
        String jsonStr = String.format("{op:\"ERR\",uid:\"\",eid:%s,msg:%s}", eid, msg);
        list.add(jsonStr);
    }

    private static void append(@Nonnull List<String> list, @Nonnull SyncedIdentity id, @Nonnull Exception e) {
        String uid = JsonUtil.getJsonString((String)id.getId());
        ExternalIdentityRef ref = id.getExternalIdRef();
        String eid = ref == null ? "\"\"" : JsonUtil.getJsonString((String)ref.getString());
        String msg = JsonUtil.getJsonString((String)e.toString());
        list.add(String.format("{op:\"ERR\",uid:%s,eid:%s,msg:%s}", uid, eid, msg));
    }

    private static String getOperationFromStatus(SyncResult.Status syncStatus) {
        String op;
        switch (syncStatus) {
            case NOP: {
                op = "nop";
                break;
            }
            case ADD: {
                op = "add";
                break;
            }
            case UPDATE: {
                op = "upd";
                break;
            }
            case DELETE: {
                op = "del";
                break;
            }
            case NO_SUCH_AUTHORIZABLE: {
                op = "nsa";
                break;
            }
            case NO_SUCH_IDENTITY: {
                op = "nsi";
                break;
            }
            case MISSING: {
                op = "mis";
                break;
            }
            case FOREIGN: {
                op = "for";
                break;
            }
            default: {
                op = "";
            }
        }
        return op;
    }
}

