/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external;

import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalIdentityRef {
    private final String id;
    private final String providerName;
    private final String string;

    public ExternalIdentityRef(@NotNull String id, @Nullable String providerName) {
        this.id = id;
        this.providerName = providerName == null || providerName.isEmpty() ? null : providerName;
        StringBuilder b = new StringBuilder();
        ExternalIdentityRef.escape(b, id);
        if (this.providerName != null) {
            b.append(';');
            ExternalIdentityRef.escape(b, this.providerName);
        }
        this.string = b.toString();
    }

    @Nullable
    public String getProviderName() {
        return this.providerName;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getString() {
        return this.string;
    }

    @NotNull
    public static ExternalIdentityRef fromString(@NotNull String str) {
        int idx = str.indexOf(59);
        if (idx < 0) {
            return new ExternalIdentityRef(Text.unescape((String)str), null);
        }
        return new ExternalIdentityRef(Text.unescape((String)str.substring(0, idx)), Text.unescape((String)str.substring(idx + 1)));
    }

    private static void escape(@NotNull StringBuilder builder, @NotNull CharSequence str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '%') {
                builder.append("%25");
                continue;
            }
            if (c == ';') {
                builder.append("%3b");
                continue;
            }
            builder.append(c);
        }
    }

    public String toString() {
        return "ExternalIdentityRef{id='" + this.id + '\'' + ", providerName='" + this.providerName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ExternalIdentityRef) {
            return this.string.equals(((ExternalIdentityRef)o).string);
        }
        return false;
    }

    public int hashCode() {
        return this.string.hashCode();
    }
}

