/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalGroup;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalUser;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncResult;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncConfig;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncResultImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncedIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSyncContext
extends DefaultSyncContext {
    private static final Logger log = LoggerFactory.getLogger(DynamicSyncContext.class);

    public DynamicSyncContext(@Nonnull DefaultSyncConfig config, @Nonnull ExternalIdentityProvider idp, @Nonnull UserManager userManager, @Nonnull ValueFactory valueFactory) {
        super(config, idp, userManager, valueFactory);
    }

    @Override
    @Nonnull
    public SyncResult sync(@Nonnull ExternalIdentity identity) throws SyncException {
        if (identity instanceof ExternalUser) {
            return super.sync(identity);
        }
        if (identity instanceof ExternalGroup) {
            try {
                Group group = this.getAuthorizable(identity, Group.class);
                if (group != null) {
                    return this.syncGroup((ExternalGroup)identity, group);
                }
                ExternalIdentityRef ref = identity.getExternalId();
                log.debug("ExternalGroup {}: Not synchronized as authorizable Group into the repository.", (Object)ref.getString());
                SyncResult.Status status = this.isSameIDP(ref) ? SyncResult.Status.NOP : SyncResult.Status.FOREIGN;
                return new DefaultSyncResultImpl(new DefaultSyncedIdentity(identity.getId(), ref, true, -1L), status);
            }
            catch (RepositoryException e) {
                throw new SyncException(e);
            }
        }
        throw new IllegalArgumentException("identity must be user or group but was: " + identity);
    }

    @Override
    protected void syncMembership(@Nonnull ExternalIdentity external, @Nonnull Authorizable auth, long depth) throws RepositoryException {
        if (auth.isGroup()) {
            return;
        }
        if (auth.hasProperty("rep:lastSynced") && !auth.hasProperty("rep:externalPrincipalNames")) {
            super.syncMembership(external, auth, depth);
        } else {
            try {
                Value[] vs;
                if (depth <= 0L) {
                    vs = new Value[]{};
                } else {
                    HashSet<String> principalsNames = new HashSet<String>();
                    this.collectPrincipalNames(principalsNames, external.getDeclaredGroups(), depth);
                    vs = this.createValues(principalsNames);
                }
                auth.setProperty("rep:externalPrincipalNames", vs);
            }
            catch (ExternalIdentityException e) {
                log.error("Failed to synchronize membership information for external identity " + external.getId(), (Throwable)e);
            }
        }
    }

    @Override
    protected void applyMembership(@Nonnull Authorizable member, @Nonnull Set<String> groups) throws RepositoryException {
        log.debug("Dynamic membership sync enabled => omit setting auto-membership for {} ", (Object)member.getID());
    }

    private void collectPrincipalNames(@Nonnull Set<String> principalNames, @Nonnull Iterable<ExternalIdentityRef> declaredGroupIdRefs, long depth) throws ExternalIdentityException {
        for (ExternalIdentityRef ref : declaredGroupIdRefs) {
            ExternalIdentity extId = this.idp.getIdentity(ref);
            if (extId instanceof ExternalGroup) {
                principalNames.add(extId.getPrincipalName());
                if (depth <= 1L) continue;
                this.collectPrincipalNames(principalNames, extId.getDeclaredGroups(), depth - 1L);
                continue;
            }
            log.debug("Not an external group ({}) => ignore.", (Object)extId);
        }
    }
}

