/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;

@Component(label="Apache Jackrabbit Oak Default Sync Handler", name="org.apache.jackrabbit.oak.spi.security.authentication.external.impl.DefaultSyncHandler", configurationFactory=true, metatype=true, ds=false)
public class DefaultSyncConfig {
    public static final String PARAM_NAME_DEFAULT = "default";
    @Property(label="Sync Handler Name", description="Name of this sync configuration. This is used to reference this handler by the login modules.", value={"default"})
    public static final String PARAM_NAME = "handler.name";
    public static final String PARAM_USER_EXPIRATION_TIME_DEFAULT = "1h";
    @Property(label="User Expiration Time", description="Duration until a synced user gets expired (eg. '1h 30m' or '1d').", value={"1h"})
    public static final String PARAM_USER_EXPIRATION_TIME = "user.expirationTime";
    public static final String[] PARAM_USER_AUTO_MEMBERSHIP_DEFAULT = new String[0];
    @Property(label="User auto membership", description="List of groups that a synced user is added to automatically", value={}, cardinality=0x7FFFFFFF)
    public static final String PARAM_USER_AUTO_MEMBERSHIP = "user.autoMembership";
    public static final String[] PARAM_USER_PROPERTY_MAPPING_DEFAULT = new String[]{"rep:fullname=cn"};
    @Property(label="User property mapping", description="List mapping definition of local properties from external ones. eg: 'profile/email=mail'.Use double quotes for fixed values. eg: 'profile/nt:primaryType=\"nt:unstructured\"", value={"rep:fullname=cn"}, cardinality=0x7FFFFFFF)
    public static final String PARAM_USER_PROPERTY_MAPPING = "user.propertyMapping";
    public static final String PARAM_USER_PATH_PREFIX_DEFAULT = "";
    @Property(label="User Path Prefix", description="The path prefix used when creating new users.", value={""})
    public static final String PARAM_USER_PATH_PREFIX = "user.pathPrefix";
    public static final String PARAM_USER_MEMBERSHIP_EXPIRATION_TIME_DEFAULT = "1h";
    @Property(label="User Membership Expiration", description="Time after which membership expires (eg. '1h 30m' or '1d').", value={"1h"})
    public static final String PARAM_USER_MEMBERSHIP_EXPIRATION_TIME = "user.membershipExpTime";
    public static final int PARAM_USER_MEMBERSHIP_NESTING_DEPTH_DEFAULT = 0;
    @Property(label="User membership nesting depth", description="Returns the maximum depth of group nesting when membership relations are synced. A value of 0 effectively disables group membership lookup. A value of 1 only adds the direct groups of a user. This value has no effect when syncing individual groups only when syncing a users membership ancestry.", intValue={0})
    public static final String PARAM_USER_MEMBERSHIP_NESTING_DEPTH = "user.membershipNestingDepth";
    public static final String PARAM_GROUP_EXPIRATION_TIME_DEFAULT = "1d";
    @Property(label="Group Expiration Time", description="Duration until a synced group expires (eg. '1h 30m' or '1d').", value={"1d"})
    public static final String PARAM_GROUP_EXPIRATION_TIME = "group.expirationTime";
    public static final String[] PARAM_GROUP_AUTO_MEMBERSHIP_DEFAULT = new String[0];
    @Property(label="Group auto membership", description="List of groups that a synced group is added to automatically", value={}, cardinality=0x7FFFFFFF)
    public static final String PARAM_GROUP_AUTO_MEMBERSHIP = "group.autoMembership";
    public static final String[] PARAM_GROUP_PROPERTY_MAPPING_DEFAULT = new String[0];
    @Property(label="Group property mapping", description="List mapping definition of local properties from external ones.", value={}, cardinality=0x7FFFFFFF)
    public static final String PARAM_GROUP_PROPERTY_MAPPING = "group.propertyMapping";
    public static final String PARAM_GROUP_PATH_PREFIX_DEFAULT = "";
    @Property(label="Group Path Prefix", description="The path prefix used when creating new groups.", value={""})
    public static final String PARAM_GROUP_PATH_PREFIX = "group.pathPrefix";
    private String name = "default";
    private final User user = new User();
    private final Group group = new Group();

    public static DefaultSyncConfig of(ConfigurationParameters params) {
        DefaultSyncConfig cfg = new DefaultSyncConfig().setName((String)params.getConfigValue(PARAM_NAME, (Object)PARAM_NAME_DEFAULT));
        cfg.user().setMembershipExpirationTime(ConfigurationParameters.Milliseconds.of((String)((String)params.getConfigValue((String)PARAM_USER_MEMBERSHIP_EXPIRATION_TIME, (Object)"1h"))).value).setMembershipNestingDepth(((Integer)params.getConfigValue(PARAM_USER_MEMBERSHIP_NESTING_DEPTH, (Object)0)).intValue()).setExpirationTime(ConfigurationParameters.Milliseconds.of((String)((String)params.getConfigValue((String)PARAM_USER_EXPIRATION_TIME, (Object)"1h"))).value).setPathPrefix((String)params.getConfigValue(PARAM_USER_PATH_PREFIX, (Object)"")).setAutoMembership((String[])params.getConfigValue(PARAM_USER_AUTO_MEMBERSHIP, (Object)PARAM_USER_AUTO_MEMBERSHIP_DEFAULT)).setPropertyMapping(DefaultSyncConfig.createMapping((String[])params.getConfigValue(PARAM_USER_PROPERTY_MAPPING, (Object)PARAM_USER_PROPERTY_MAPPING_DEFAULT)));
        cfg.group().setExpirationTime(ConfigurationParameters.Milliseconds.of((String)((String)params.getConfigValue((String)PARAM_GROUP_EXPIRATION_TIME, (Object)PARAM_GROUP_EXPIRATION_TIME_DEFAULT))).value).setPathPrefix((String)params.getConfigValue(PARAM_GROUP_PATH_PREFIX, (Object)"")).setAutoMembership((String[])params.getConfigValue(PARAM_GROUP_AUTO_MEMBERSHIP, (Object)PARAM_GROUP_AUTO_MEMBERSHIP_DEFAULT)).setPropertyMapping(DefaultSyncConfig.createMapping((String[])params.getConfigValue(PARAM_GROUP_PROPERTY_MAPPING, (Object)PARAM_GROUP_PROPERTY_MAPPING_DEFAULT)));
        return cfg;
    }

    private static Map<String, String> createMapping(String[] patterns) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (String pattern : patterns) {
            int idx = pattern.indexOf(61);
            if (idx <= 0) continue;
            String relPath = pattern.substring(0, idx).trim();
            String value = pattern.substring(idx + 1).trim();
            mapping.put(relPath, value);
        }
        return mapping;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public DefaultSyncConfig setName(@Nonnull String name) {
        this.name = name;
        return this;
    }

    public User user() {
        return this.user;
    }

    public Group group() {
        return this.group;
    }

    public static class Group
    extends Authorizable {
    }

    public static class User
    extends Authorizable {
        private long membershipExpirationTime;
        private long membershipNestingDepth;

        public long getMembershipExpirationTime() {
            return this.membershipExpirationTime;
        }

        @Nonnull
        public User setMembershipExpirationTime(long membershipExpirationTime) {
            this.membershipExpirationTime = membershipExpirationTime;
            return this;
        }

        public long getMembershipNestingDepth() {
            return this.membershipNestingDepth;
        }

        @Nonnull
        public User setMembershipNestingDepth(long membershipNestingDepth) {
            this.membershipNestingDepth = membershipNestingDepth;
            return this;
        }
    }

    public static abstract class Authorizable {
        private long expirationTime;
        private Set<String> autoMembership;
        private Map<String, String> propertyMapping;
        private String pathPrefix;

        public long getExpirationTime() {
            return this.expirationTime;
        }

        @Nonnull
        public Authorizable setExpirationTime(long expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        @Nonnull
        public Set<String> getAutoMembership() {
            return this.autoMembership == null ? Collections.emptySet() : this.autoMembership;
        }

        @Nonnull
        public Authorizable setAutoMembership(String ... autoMembership) {
            this.autoMembership = new HashSet<String>();
            for (String groupName : autoMembership) {
                if (groupName.trim().length() <= 0) continue;
                this.autoMembership.add(groupName.trim());
            }
            return this;
        }

        @Nonnull
        public Map<String, String> getPropertyMapping() {
            return this.propertyMapping == null ? Collections.emptyMap() : this.propertyMapping;
        }

        @Nonnull
        public Authorizable setPropertyMapping(Map<String, String> propertyMapping) {
            this.propertyMapping = propertyMapping;
            return this;
        }

        @Nonnull
        public String getPathPrefix() {
            return this.pathPrefix == null ? "" : this.pathPrefix;
        }

        @Nonnull
        public Authorizable setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
            return this;
        }
    }
}

