/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.value.ValueFactoryImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalGroup;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalUser;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.DefaultSyncConfig;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service
public class DefaultSyncHandler
implements SyncHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultSyncHandler.class);
    private DefaultSyncConfig config;

    public DefaultSyncHandler() {
    }

    public DefaultSyncHandler(DefaultSyncConfig config) {
        this.config = config;
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        ConfigurationParameters cfg = ConfigurationParameters.of(properties);
        this.config = DefaultSyncConfig.of(cfg);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.config.getName();
    }

    @Override
    @Nonnull
    public SyncContext createContext(@Nonnull ExternalIdentityProvider idp, @Nonnull UserManager userManager, @Nonnull Root root) throws SyncException {
        return new ContextImpl(idp, userManager, root);
    }

    private static String concatPaths(String ... paths) {
        StringBuilder result = new StringBuilder();
        for (String path : paths) {
            int i0;
            if (path == null || path.isEmpty()) continue;
            int i1 = path.length();
            for (i0 = 0; i0 < i1 && path.charAt(i0) == '/'; ++i0) {
            }
            while (i1 > i0 && path.charAt(i1 - 1) == '/') {
                --i1;
            }
            if (i1 <= i0) continue;
            if (result.length() > 0) {
                result.append('/');
            }
            result.append(path.substring(i0, i1));
        }
        return result.length() == 0 ? null : result.toString();
    }

    private class ContextImpl
    implements SyncContext {
        private final ExternalIdentityProvider idp;
        private final UserManager userManager;
        private final Root root;
        private final ValueFactory valueFactory;

        private ContextImpl(ExternalIdentityProvider idp, UserManager userManager, Root root) {
            this.idp = idp;
            this.userManager = userManager;
            this.root = root;
            this.valueFactory = new ValueFactoryImpl(root, NamePathMapper.DEFAULT);
        }

        @Override
        public void close() {
        }

        @Override
        public boolean sync(@Nonnull ExternalIdentity identity) throws SyncException {
            try {
                if (identity instanceof ExternalUser) {
                    User user = this.getUser(identity);
                    if (user == null) {
                        this.createUser((ExternalUser)identity);
                    } else {
                        this.updateUser((ExternalUser)identity, user);
                    }
                    return true;
                }
                if (identity instanceof ExternalGroup) {
                    return false;
                }
                throw new IllegalArgumentException("identity must be user or group but was: " + identity);
            }
            catch (RepositoryException e) {
                throw new SyncException(e);
            }
            catch (ExternalIdentityException e) {
                throw new SyncException(e);
            }
        }

        @CheckForNull
        private User getUser(@Nonnull ExternalIdentity externalUser) throws RepositoryException {
            Authorizable authorizable = this.userManager.getAuthorizable(externalUser.getId());
            if (authorizable == null) {
                authorizable = this.userManager.getAuthorizable(externalUser.getPrincipalName());
            }
            if (authorizable == null) {
                return null;
            }
            if (authorizable instanceof User) {
                return (User)authorizable;
            }
            log.warn("unexpected authorizable: {}", (Object)authorizable);
            return null;
        }

        @CheckForNull
        private User createUser(ExternalUser externalUser) throws RepositoryException, SyncException, ExternalIdentityException {
            PrincipalImpl principal = new PrincipalImpl(externalUser.getPrincipalName());
            User user = this.userManager.createUser(externalUser.getId(), null, (Principal)principal, DefaultSyncHandler.concatPaths(new String[]{DefaultSyncHandler.this.config.user().getPathPrefix(), externalUser.getIntermediatePath()}));
            this.syncAuthorizable(externalUser, (Authorizable)user);
            return user;
        }

        @CheckForNull
        private Group createGroup(ExternalGroup externalGroup) throws RepositoryException, SyncException, ExternalIdentityException {
            PrincipalImpl principal = new PrincipalImpl(externalGroup.getPrincipalName());
            Group group = this.userManager.createGroup(externalGroup.getId(), (Principal)principal, DefaultSyncHandler.concatPaths(new String[]{DefaultSyncHandler.this.config.user().getPathPrefix(), externalGroup.getIntermediatePath()}));
            this.syncAuthorizable(externalGroup, (Authorizable)group);
            return group;
        }

        private void updateUser(ExternalUser externalUser, User user) throws RepositoryException, SyncException, ExternalIdentityException {
            this.syncAuthorizable(externalUser, (Authorizable)user);
        }

        private void syncAuthorizable(ExternalIdentity externalUser, Authorizable authorizable) throws RepositoryException, SyncException, ExternalIdentityException {
            for (ExternalIdentityRef externalGroupRef : externalUser.getDeclaredGroups()) {
                Group group;
                ExternalIdentity id = this.idp.getIdentity(externalGroupRef);
                if (!(id instanceof ExternalGroup)) continue;
                ExternalGroup externalGroup = (ExternalGroup)id;
                String groupId = externalGroup.getId();
                Authorizable a = this.userManager.getAuthorizable(groupId);
                if (a == null) {
                    group = this.createGroup(externalGroup);
                } else {
                    Group group2 = group = a.isGroup() ? (Group)a : null;
                }
                if (group != null) {
                    group.addMember(authorizable);
                    continue;
                }
                log.debug("No such group " + groupId + "; Ignoring group membership.");
            }
            Map<String, ?> properties = externalUser.getProperties();
            for (String key : properties.keySet()) {
                Object prop = properties.get(key);
                if (prop instanceof Collection) {
                    Value[] values = this.createValues((Collection)prop);
                    if (values == null) continue;
                    authorizable.setProperty(key, values);
                    continue;
                }
                Value value = this.createValue(prop);
                if (value == null) continue;
                authorizable.setProperty(key, value);
            }
        }

        @CheckForNull
        private Value createValue(Object propValue) throws ValueFormatException {
            int type = this.getType(propValue);
            if (type == 0) {
                return null;
            }
            return this.valueFactory.createValue(propValue.toString(), type);
        }

        @CheckForNull
        private Value[] createValues(Collection<?> propValues) throws ValueFormatException {
            ArrayList<Value> values = new ArrayList<Value>();
            for (Object obj : propValues) {
                Value v = this.createValue(obj);
                if (v == null) continue;
                values.add(v);
            }
            return values.toArray(new Value[values.size()]);
        }

        private int getType(Object propValue) {
            if (propValue == null) {
                return 0;
            }
            return 1;
        }
    }
}

