/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.api.jmx;

import aQute.bnd.annotation.ProviderType;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.jackrabbit.oak.api.jmx.Description;
import org.apache.jackrabbit.oak.api.jmx.Name;

@ProviderType
public interface RepositoryManagementMBean {
    public static final String TYPE = "RepositoryManagement";

    @Nonnull
    @Description(value="Creates a backup of the persistent state of the repository")
    public CompositeData startBackup();

    @Nonnull
    @Description(value="The status of the ongoing operation, or the terminal status of the last completed backup operation")
    public CompositeData getBackupStatus();

    @Nonnull
    @Description(value="Restores the repository from a backup")
    public CompositeData startRestore();

    @Nonnull
    @Description(value="The status of the ongoing operation, or the terminal status of the last completed restore operation")
    public CompositeData getRestoreStatus();

    @Nonnull
    @Description(value="Initiates a data store garbage collection operation")
    public CompositeData startDataStoreGC(@Name(value="markOnly") @Description(value="Set to true to only mark references and not sweep in the mark and sweep operation. This mode is to be used when the underlying BlobStore is shared between multiple different repositories. For all other cases set it to false to perform full garbage collection") boolean var1);

    @Nonnull
    @Description(value="Data store garbage collection status")
    public CompositeData getDataStoreGCStatus();

    @Nonnull
    @Description(value="Initiates a revision garbage collection operation")
    public CompositeData startRevisionGC();

    @Nonnull
    @Description(value="Cancel a running revision garbage collection operation. Does nothing if revision garbage collection is not running.")
    public CompositeData cancelRevisionGC();

    @Nonnull
    @Description(value="Revision garbage collection status")
    public CompositeData getRevisionGCStatus();

    @Deprecated
    @CheckForNull
    public String checkpoint(long var1);

    @Nonnull
    @Description(value="Initiates a reindex operation for the property indexes marked for reindexing")
    public CompositeData startPropertyIndexAsyncReindex();

    @Nonnull
    @Description(value="Asynchronous Property Index reindexing status")
    public CompositeData getPropertyIndexAsyncReindexStatus();

    @Nonnull
    @Description(value="Refresh all currently open sessions")
    public TabularData refreshAllSessions();

    public static enum StatusCode {
        UNAVAILABLE("Operation not available"),
        NONE("Status not available"),
        INITIATED("Operation initiated"),
        RUNNING("Operation running"),
        SUCCEEDED("Operation succeeded"),
        FAILED("Operation failed");

        public final String name;

        private StatusCode(String name) {
            this.name = name;
        }
    }
}

