/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdfparser.BaseParser;

public class PDFObjectStreamParser
extends BaseParser {
    private List streamObjects = null;
    private List objectNumbers = null;
    private COSStream stream;

    public PDFObjectStreamParser(COSStream strm, COSDocument doc) throws IOException {
        super(strm.getUnfilteredStream());
        this.setDocument(doc);
        this.stream = strm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        try {
            int numberOfObjects = this.stream.getInt("N");
            this.objectNumbers = new ArrayList(numberOfObjects);
            this.streamObjects = new ArrayList(numberOfObjects);
            for (int i = 0; i < numberOfObjects; ++i) {
                int objectNumber = this.readInt();
                int offset = this.readInt();
                this.objectNumbers.add(new Integer(objectNumber));
            }
            COSObject object = null;
            COSBase cosObject = null;
            int objectCounter = 0;
            while ((cosObject = this.parseDirObject()) != null) {
                object = new COSObject(cosObject);
                object.setGenerationNumber(COSInteger.ZERO);
                COSInteger objNum = new COSInteger((Integer)this.objectNumbers.get(objectCounter));
                object.setObjectNumber(objNum);
                this.streamObjects.add(object);
                ++objectCounter;
            }
        }
        finally {
            this.pdfSource.close();
        }
    }

    public List getObjects() {
        return this.streamObjects;
    }
}

