/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Mp3Parser
implements Parser {
    private static final String[] GENRES = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall", ""};

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        metadata.set("Content-Type", "audio/mpeg");
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        byte[] tag = Mp3Parser.getSuffix(stream, 128);
        if (tag.length == 128 && tag[0] == 84 && tag[1] == 65 && tag[2] == 71) {
            String title = Mp3Parser.getString(tag, 3, 33);
            String artist = Mp3Parser.getString(tag, 33, 63);
            String album = Mp3Parser.getString(tag, 63, 93);
            String year = Mp3Parser.getString(tag, 93, 97);
            String comment = Mp3Parser.getString(tag, 97, 127);
            int genre = tag[127] & 0xFF;
            metadata.set("title", title);
            metadata.set("Author", artist);
            xhtml.element("h1", title);
            xhtml.element("p", artist);
            if (tag[125] == 0 && tag[126] != 0) {
                int track = tag[126] & 0xFF;
                xhtml.element("p", album + ", track " + track);
            } else {
                xhtml.element("p", album);
            }
            xhtml.element("p", year);
            xhtml.element("p", comment);
            xhtml.element("p", GENRES[Math.min(genre, GENRES.length - 1)]);
        }
        xhtml.endDocument();
    }

    private static String getString(byte[] buffer, int start, int end) throws TikaException {
        for (int zero = start; zero < end && buffer[zero] != 0; ++zero) {
        }
        for (end = zero; start < end && buffer[end - 1] <= 32; --end) {
        }
        while (start < end && buffer[start] <= 32) {
            ++start;
        }
        try {
            return new String(buffer, start, end - start, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new TikaException("ISO-8859-1 encoding is not available", e);
        }
    }

    private static byte[] getSuffix(InputStream stream, int length) throws IOException {
        byte[] buffer = new byte[2 * length];
        int bytesInBuffer = 0;
        int n = stream.read(buffer);
        while (n != -1) {
            if ((bytesInBuffer += n) == buffer.length) {
                System.arraycopy(buffer, bytesInBuffer - length, buffer, 0, length);
                bytesInBuffer = length;
            }
            n = stream.read(buffer, bytesInBuffer, buffer.length - bytesInBuffer);
        }
        if (bytesInBuffer < length) {
            length = bytesInBuffer;
        }
        byte[] result = new byte[length];
        System.arraycopy(buffer, bytesInBuffer - length, result, 0, length);
        return result;
    }
}

