/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.model.XWPFCommentsDecorator;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.model.XWPFHyperlinkDecorator;
import org.apache.poi.xwpf.model.XWPFParagraphDecorator;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.xml.sax.SAXException;

public class XWPFWordExtractorDecorator
extends AbstractOOXMLExtractor {
    public XWPFWordExtractorDecorator(XWPFWordExtractor extractor) {
        super(extractor, "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
    }

    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        XWPFDocument document = (XWPFDocument)this.extractor.getDocument();
        XWPFHeaderFooterPolicy hfPolicy = document.getHeaderFooterPolicy();
        if (hfPolicy.getFirstPageHeader() != null) {
            xhtml.element("p", hfPolicy.getFirstPageHeader().getText());
        }
        if (hfPolicy.getEvenPageHeader() != null) {
            xhtml.element("p", hfPolicy.getEvenPageHeader().getText());
        }
        if (hfPolicy.getDefaultHeader() != null) {
            xhtml.element("p", hfPolicy.getDefaultHeader().getText());
        }
        Iterator<XWPFParagraph> i = document.getParagraphsIterator();
        while (i.hasNext()) {
            XWPFCommentsDecorator decorator = new XWPFCommentsDecorator(new XWPFHyperlinkDecorator(i.next(), null, true));
            xhtml.element("p", ((XWPFParagraphDecorator)decorator).getText());
        }
        this.extractTableContent(document.getDocument().getBody().getTblArray(), xhtml);
        if (hfPolicy.getFirstPageFooter() != null) {
            xhtml.element("p", hfPolicy.getFirstPageFooter().getText());
        }
        if (hfPolicy.getEvenPageFooter() != null) {
            xhtml.element("p", hfPolicy.getEvenPageFooter().getText());
        }
        if (hfPolicy.getDefaultFooter() != null) {
            xhtml.element("p", hfPolicy.getDefaultFooter().getText());
        }
    }

    private void extractTableContent(CTTbl[] tables, XHTMLContentHandler xhtml) throws SAXException {
        for (CTTbl table : tables) {
            CTRow[] rows;
            xhtml.startElement("table");
            xhtml.startElement("tbody");
            for (CTRow row : rows = table.getTrArray()) {
                CTTc[] cells;
                xhtml.startElement("tr");
                for (CTTc tc : cells = row.getTcArray()) {
                    CTP[] content;
                    xhtml.startElement("td");
                    for (CTP ctp : content = tc.getPArray()) {
                        CTR[] inner;
                        for (CTR ctr : inner = ctp.getRArray()) {
                            CTText[] text;
                            for (CTText textContent : text = ctr.getTArray()) {
                                xhtml.characters(textContent.getStringValue());
                            }
                        }
                    }
                    xhtml.endElement("td");
                }
                xhtml.endElement("tr");
            }
            xhtml.endElement("tbody");
            xhtml.endElement("table");
        }
    }
}

