/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.helpers;

import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.util.CTColComparator;
import org.apache.poi.xssf.util.NumericRanges;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class ColumnHelper {
    private CTWorksheet worksheet;
    private CTCols newCols;

    public ColumnHelper(CTWorksheet worksheet) {
        this.worksheet = worksheet;
        this.cleanColumns();
    }

    public void cleanColumns() {
        this.newCols = CTCols.Factory.newInstance();
        CTCols[] colsArray = this.worksheet.getColsArray();
        int i = 0;
        for (i = 0; i < colsArray.length; ++i) {
            CTCols cols = colsArray[i];
            CTCol[] colArray = cols.getColArray();
            for (int y = 0; y < colArray.length; ++y) {
                CTCol col = colArray[y];
                this.newCols = this.addCleanColIntoCols(this.newCols, col);
            }
        }
        for (int y = i - 1; y >= 0; --y) {
            this.worksheet.removeCols(y);
        }
        this.worksheet.addNewCols();
        this.worksheet.setColsArray(0, this.newCols);
    }

    public void sortColumns(CTCols newCols) {
        CTCol[] colArray = newCols.getColArray();
        Arrays.sort(colArray, new CTColComparator());
        newCols.setColArray(colArray);
    }

    public CTCol cloneCol(CTCols cols, CTCol col) {
        CTCol newCol = cols.addNewCol();
        newCol.setMin(col.getMin());
        newCol.setMax(col.getMax());
        this.setColumnAttributes(col, newCol);
        return newCol;
    }

    public CTCol getColumn(long index, boolean splitColumns) {
        return this.getColumn1Based(index + 1L, splitColumns);
    }

    public CTCol getColumn1Based(long index1, boolean splitColumns) {
        CTCols colsArray = this.worksheet.getColsArray(0);
        for (int i = 0; i < colsArray.sizeOfColArray(); ++i) {
            CTCol colArray = colsArray.getColArray(i);
            if (colArray.getMin() > index1 || colArray.getMax() < index1) continue;
            if (splitColumns) {
                if (colArray.getMin() < index1) {
                    this.insertCol(colsArray, colArray.getMin(), index1 - 1L, new CTCol[]{colArray});
                }
                if (colArray.getMax() > index1) {
                    this.insertCol(colsArray, index1 + 1L, colArray.getMax(), new CTCol[]{colArray});
                }
                colArray.setMin(index1);
                colArray.setMax(index1);
            }
            return colArray;
        }
        return null;
    }

    public CTCols addCleanColIntoCols(CTCols cols, CTCol col) {
        boolean colOverlaps = false;
        for (int i = 0; i < cols.sizeOfColArray(); ++i) {
            CTCol newColAfter;
            CTCol newColBefore;
            CTCol newCol;
            CTCol rangeCol;
            CTCol ithCol = cols.getColArray(i);
            long[] range1 = new long[]{ithCol.getMin(), ithCol.getMax()};
            long[] range2 = new long[]{col.getMin(), col.getMax()};
            long[] overlappingRange = NumericRanges.getOverlappingRange(range1, range2);
            int overlappingType = NumericRanges.getOverlappingType(range1, range2);
            if (overlappingType == NumericRanges.OVERLAPS_1_MINOR) {
                ithCol.setMax(overlappingRange[0] - 1L);
                rangeCol = this.insertCol(cols, overlappingRange[0], overlappingRange[1], new CTCol[]{ithCol, col});
                ++i;
                newCol = this.insertCol(cols, overlappingRange[1] + 1L, col.getMax(), new CTCol[]{col});
                ++i;
            } else if (overlappingType == NumericRanges.OVERLAPS_2_MINOR) {
                ithCol.setMin(overlappingRange[1] + 1L);
                rangeCol = this.insertCol(cols, overlappingRange[0], overlappingRange[1], new CTCol[]{ithCol, col});
                ++i;
                newCol = this.insertCol(cols, col.getMin(), overlappingRange[0] - 1L, new CTCol[]{col});
                ++i;
            } else if (overlappingType == NumericRanges.OVERLAPS_2_WRAPS) {
                this.setColumnAttributes(col, ithCol);
                if (col.getMin() != ithCol.getMin()) {
                    newColBefore = this.insertCol(cols, col.getMin(), ithCol.getMin() - 1L, new CTCol[]{col});
                    ++i;
                }
                if (col.getMax() != ithCol.getMax()) {
                    newColAfter = this.insertCol(cols, ithCol.getMax() + 1L, col.getMax(), new CTCol[]{col});
                    ++i;
                }
            } else if (overlappingType == NumericRanges.OVERLAPS_1_WRAPS) {
                if (col.getMin() != ithCol.getMin()) {
                    newColBefore = this.insertCol(cols, ithCol.getMin(), col.getMin() - 1L, new CTCol[]{ithCol});
                    ++i;
                }
                if (col.getMax() != ithCol.getMax()) {
                    newColAfter = this.insertCol(cols, col.getMax() + 1L, ithCol.getMax(), new CTCol[]{ithCol});
                    ++i;
                }
                ithCol.setMin(overlappingRange[0]);
                ithCol.setMax(overlappingRange[1]);
                this.setColumnAttributes(col, ithCol);
            }
            if (overlappingType == NumericRanges.NO_OVERLAPS) continue;
            colOverlaps = true;
        }
        if (!colOverlaps) {
            CTCol newCol = this.cloneCol(cols, col);
        }
        this.sortColumns(cols);
        return cols;
    }

    private CTCol insertCol(CTCols cols, long min, long max, CTCol[] colsWithAttributes) {
        if (!this.columnExists(cols, min, max)) {
            CTCol newCol = cols.insertNewCol(0);
            newCol.setMin(min);
            newCol.setMax(max);
            for (CTCol col : colsWithAttributes) {
                this.setColumnAttributes(col, newCol);
            }
            return newCol;
        }
        return null;
    }

    public boolean columnExists(CTCols cols, long index) {
        return this.columnExists1Based(cols, index + 1L);
    }

    private boolean columnExists1Based(CTCols cols, long index1) {
        for (int i = 0; i < cols.sizeOfColArray(); ++i) {
            if (cols.getColArray(i).getMin() != index1) continue;
            return true;
        }
        return false;
    }

    public void setColumnAttributes(CTCol fromCol, CTCol toCol) {
        if (fromCol.isSetBestFit()) {
            toCol.setBestFit(fromCol.getBestFit());
        }
        if (fromCol.isSetCustomWidth()) {
            toCol.setCustomWidth(fromCol.getCustomWidth());
        }
        if (fromCol.isSetHidden()) {
            toCol.setHidden(fromCol.getHidden());
        }
        if (fromCol.isSetStyle()) {
            toCol.setStyle(fromCol.getStyle());
        }
        if (fromCol.isSetWidth()) {
            toCol.setWidth(fromCol.getWidth());
        }
        if (fromCol.isSetCollapsed()) {
            toCol.setCollapsed(fromCol.getCollapsed());
        }
        if (fromCol.isSetPhonetic()) {
            toCol.setPhonetic(fromCol.getPhonetic());
        }
        if (fromCol.isSetOutlineLevel()) {
            toCol.setOutlineLevel(fromCol.getOutlineLevel());
        }
        toCol.setCollapsed(fromCol.isSetCollapsed());
    }

    public void setColBestFit(long index, boolean bestFit) {
        CTCol col = this.getOrCreateColumn1Based(index + 1L, false);
        col.setBestFit(bestFit);
    }

    public void setCustomWidth(long index, boolean bestFit) {
        CTCol col = this.getOrCreateColumn1Based(index + 1L, false);
        col.setCustomWidth(bestFit);
    }

    public void setColWidth(long index, double width) {
        CTCol col = this.getOrCreateColumn1Based(index + 1L, false);
        col.setWidth(width);
    }

    public void setColHidden(long index, boolean hidden) {
        CTCol col = this.getOrCreateColumn1Based(index + 1L, false);
        col.setHidden(hidden);
    }

    protected CTCol getOrCreateColumn1Based(long index1, boolean splitColumns) {
        CTCol col = this.getColumn1Based(index1, splitColumns);
        if (col == null) {
            col = this.worksheet.getColsArray(0).addNewCol();
            col.setMin(index1);
            col.setMax(index1);
        }
        return col;
    }

    public void setColDefaultStyle(long index, CellStyle style) {
        this.setColDefaultStyle(index, style.getIndex());
    }

    public void setColDefaultStyle(long index, int styleId) {
        CTCol col = this.getOrCreateColumn1Based(index + 1L, true);
        col.setStyle(styleId);
    }

    public int getColDefaultStyle(long index) {
        if (this.getColumn(index, false) != null) {
            return (int)this.getColumn(index, false).getStyle();
        }
        return -1;
    }

    private boolean columnExists(CTCols cols, long min, long max) {
        for (int i = 0; i < cols.sizeOfColArray(); ++i) {
            if (cols.getColArray(i).getMin() != min || cols.getColArray(i).getMax() != max) continue;
            return true;
        }
        return false;
    }

    public int getIndexOfColumn(CTCols cols, CTCol col) {
        for (int i = 0; i < cols.sizeOfColArray(); ++i) {
            if (cols.getColArray(i).getMin() != col.getMin() || cols.getColArray(i).getMax() != col.getMax()) continue;
            return i;
        }
        return -1;
    }

    public static double getColumnWidth(XSSFSheet sheet, int column, boolean useMergedCells) {
        char defaultChar = '0';
        double fontHeightMultiple = 2.0;
        FontRenderContext frc = new FontRenderContext(null, true, true);
        XSSFWorkbook wb = sheet.getWorkbook();
        XSSFFont defaultFont = wb.getFontAt((short)0);
        AttributedString str = new AttributedString("" + defaultChar);
        ColumnHelper.copyAttributes(defaultFont, str, 0, 1);
        TextLayout layout = new TextLayout(str.getIterator(), frc);
        int defaultCharWidth = (int)layout.getAdvance();
        double width = -1.0;
        Iterator<Row> it = sheet.rowIterator();
        block2: while (it.hasNext()) {
            String sval;
            XSSFFont font;
            XSSFCellStyle style;
            int colspan;
            XSSFCell cell;
            block15: {
                XSSFRow row = (XSSFRow)it.next();
                cell = row.getCell(column);
                if (cell == null) continue;
                colspan = 1;
                for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
                    CellRangeAddress region = sheet.getMergedRegion(i);
                    if (!ColumnHelper.containsCell(region, row.getRowNum(), column)) continue;
                    if (!useMergedCells) continue block2;
                    cell = row.getCell(region.getFirstColumn());
                    colspan = 1 + region.getLastColumn() - region.getFirstColumn();
                }
                style = cell.getCellStyle();
                int cellType = cell.getCellType();
                if (cellType == 2) {
                    cellType = cell.getCachedFormulaResultType();
                }
                font = wb.getFontAt(style.getFontIndex());
                if (cellType == 1) {
                    XSSFRichTextString rt = cell.getRichStringCellValue();
                    String[] lines = rt.getString().split("\\n");
                    for (int i = 0; i < lines.length; ++i) {
                        String txt = lines[i] + defaultChar;
                        str = new AttributedString(txt);
                        ColumnHelper.copyAttributes(font, str, 0, txt.length());
                        if (rt.numFormattingRuns() > 0) {
                            int pos = 0;
                            for (int j = 0; j < rt.numFormattingRuns(); ++j) {
                                XSSFFont fnt = rt.getFontOfFormattingRun(j);
                                if (fnt == null) continue;
                                int len = rt.getLengthOfFormattingRun(j);
                                ColumnHelper.copyAttributes(fnt, str, pos, pos + len);
                                pos += len;
                            }
                        }
                        layout = new TextLayout(str.getIterator(), frc);
                        if (style.getRotation() != 0) {
                            AffineTransform trans = new AffineTransform();
                            trans.concatenate(AffineTransform.getRotateInstance((double)style.getRotation() * 2.0 * Math.PI / 360.0));
                            trans.concatenate(AffineTransform.getScaleInstance(1.0, fontHeightMultiple));
                            width = Math.max(width, layout.getOutline(trans).getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
                            continue;
                        }
                        width = Math.max(width, layout.getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
                    }
                    continue;
                }
                sval = null;
                if (cellType == 0) {
                    String dfmt = style.getDataFormatString();
                    String format = dfmt == null ? null : dfmt.replaceAll("\"", "");
                    double value = cell.getNumericCellValue();
                    try {
                        if ("General".equals(format)) {
                            sval = "" + value;
                            break block15;
                        }
                        DecimalFormat fmt = new DecimalFormat(format);
                        sval = fmt.format(value);
                    }
                    catch (Exception e) {
                        sval = "" + value;
                    }
                } else if (cellType == 4) {
                    sval = String.valueOf(cell.getBooleanCellValue());
                }
            }
            if (sval == null) continue;
            String txt = sval + defaultChar;
            str = new AttributedString(txt);
            ColumnHelper.copyAttributes(font, str, 0, txt.length());
            layout = new TextLayout(str.getIterator(), frc);
            if (style.getRotation() != 0) {
                AffineTransform trans = new AffineTransform();
                trans.concatenate(AffineTransform.getRotateInstance((double)style.getRotation() * 2.0 * Math.PI / 360.0));
                trans.concatenate(AffineTransform.getScaleInstance(1.0, fontHeightMultiple));
                width = Math.max(width, layout.getOutline(trans).getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
                continue;
            }
            width = Math.max(width, layout.getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
        }
        return width;
    }

    private static void copyAttributes(XSSFFont font, AttributedString str, int startIdx, int endIdx) {
        str.addAttribute(TextAttribute.FAMILY, font.getFontName(), startIdx, endIdx);
        str.addAttribute(TextAttribute.SIZE, new Float(font.getFontHeightInPoints()));
        if (font.getBoldweight() == 700) {
            str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, startIdx, endIdx);
        }
        if (font.getItalic()) {
            str.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, startIdx, endIdx);
        }
        if (font.getUnderline() == 1) {
            str.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, startIdx, endIdx);
        }
    }

    private static boolean containsCell(CellRangeAddress cr, int rowIx, int colIx) {
        return cr.getFirstRow() <= rowIx && cr.getLastRow() >= rowIx && cr.getFirstColumn() <= colIx && cr.getLastColumn() >= colIx;
    }
}

