/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualPictureProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTPicture;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTPictureNonVisual;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class XSSFPicture
extends XSSFShape
implements Picture {
    private static final POILogger logger = POILogFactory.getLogger(XSSFPicture.class);
    private static float DEFAULT_COLUMN_WIDTH = 9.140625f;
    private static CTPicture prototype = null;
    private CTPicture ctPicture;

    protected XSSFPicture(XSSFDrawing drawing, CTPicture ctPicture) {
        this.drawing = drawing;
        this.ctPicture = ctPicture;
    }

    protected static CTPicture prototype() {
        if (prototype == null) {
            CTPicture pic = CTPicture.Factory.newInstance();
            CTPictureNonVisual nvpr = pic.addNewNvPicPr();
            CTNonVisualDrawingProps nvProps = nvpr.addNewCNvPr();
            nvProps.setId(1L);
            nvProps.setName("Picture 1");
            nvProps.setDescr("Picture");
            CTNonVisualPictureProperties nvPicProps = nvpr.addNewCNvPicPr();
            nvPicProps.addNewPicLocks().setNoChangeAspect(true);
            CTBlipFillProperties blip = pic.addNewBlipFill();
            blip.addNewBlip().setEmbed("");
            blip.addNewStretch().addNewFillRect();
            CTShapeProperties sppr = pic.addNewSpPr();
            CTTransform2D t2d = sppr.addNewXfrm();
            CTPositiveSize2D ext = t2d.addNewExt();
            ext.setCx(0L);
            ext.setCy(0L);
            CTPoint2D off = t2d.addNewOff();
            off.setX(0L);
            off.setY(0L);
            CTPresetGeometry2D prstGeom = sppr.addNewPrstGeom();
            prstGeom.setPrst(STShapeType.RECT);
            prstGeom.addNewAvLst();
            prototype = pic;
        }
        return prototype;
    }

    protected void setPictureReference(PackageRelationship rel) {
        this.ctPicture.getBlipFill().getBlip().setEmbed(rel.getId());
    }

    public CTPicture getCTPicture() {
        return this.ctPicture;
    }

    public void resize() {
        this.resize(1.0);
    }

    public void resize(double scale) {
        XSSFClientAnchor anchor = (XSSFClientAnchor)this.getAnchor();
        XSSFClientAnchor pref = this.getPreferredSize(scale);
        int row2 = anchor.getRow1() + (pref.getRow2() - pref.getRow1());
        int col2 = anchor.getCol1() + (pref.getCol2() - pref.getCol1());
        anchor.setCol2(col2);
        anchor.setDx1(0);
        anchor.setDx2(pref.getDx2());
        anchor.setRow2(row2);
        anchor.setDy1(0);
        anchor.setDy2(pref.getDy2());
    }

    public XSSFClientAnchor getPreferredSize() {
        return this.getPreferredSize(1.0);
    }

    public XSSFClientAnchor getPreferredSize(double scale) {
        XSSFClientAnchor anchor = (XSSFClientAnchor)this.getAnchor();
        XSSFPictureData data = this.getPictureData();
        Dimension size = XSSFPicture.getImageDimension(data.getPackagePart(), data.getPictureType());
        double scaledWidth = size.getWidth() * scale;
        double scaledHeight = size.getHeight() * scale;
        float w = 0.0f;
        int col2 = anchor.getCol1();
        int dx2 = 0;
        if (anchor.getDx1() > 0) {
            w += this.getColumnWidthInPixels(col2) - (float)anchor.getDx1();
            ++col2;
        }
        while (!((double)(w += this.getColumnWidthInPixels(col2)) > scaledWidth)) {
            ++col2;
        }
        if ((double)w > scaledWidth) {
            double cw = this.getColumnWidthInPixels(col2 + 1);
            double delta = (double)w - scaledWidth;
            dx2 = (int)(9525.0 * (cw - delta));
        }
        anchor.setCol2(col2);
        anchor.setDx2(dx2);
        double h = 0.0;
        int row2 = anchor.getRow1();
        int dy2 = 0;
        if (anchor.getDy1() > 0) {
            h += (double)(this.getRowHeightInPixels(row2) - (float)anchor.getDy1());
            ++row2;
        }
        while (!((h += (double)this.getRowHeightInPixels(row2)) > scaledHeight)) {
            ++row2;
        }
        if (h > scaledHeight) {
            double ch = this.getRowHeightInPixels(row2 + 1);
            double delta = h - scaledHeight;
            dy2 = (int)(9525.0 * (ch - delta));
        }
        anchor.setRow2(row2);
        anchor.setDy2(dy2);
        CTPositiveSize2D size2d = this.ctPicture.getSpPr().getXfrm().getExt();
        size2d.setCx((long)(scaledWidth * 9525.0));
        size2d.setCy((long)(scaledHeight * 9525.0));
        return anchor;
    }

    private float getColumnWidthInPixels(int columnIndex) {
        XSSFSheet sheet = (XSSFSheet)this.getDrawing().getParent();
        CTCol col = sheet.getColumnHelper().getColumn(columnIndex, false);
        double numChars = col == null || !col.isSetWidth() ? (double)DEFAULT_COLUMN_WIDTH : col.getWidth();
        return (float)numChars * 7.0017f;
    }

    private float getRowHeightInPixels(int rowIndex) {
        XSSFSheet sheet = (XSSFSheet)this.getDrawing().getParent();
        XSSFRow row = sheet.getRow(rowIndex);
        float height = row != null ? row.getHeightInPoints() : sheet.getDefaultRowHeightInPoints();
        return height * 96.0f / 72.0f;
    }

    protected static Dimension getImageDimension(PackagePart part, int type) {
        Dimension size = new Dimension();
        switch (type) {
            case 5: 
            case 6: 
            case 7: {
                try {
                    ImageInputStream iis = ImageIO.createImageInputStream(part.getInputStream());
                    Iterator<ImageReader> i = ImageIO.getImageReaders(iis);
                    ImageReader r = i.next();
                    r.setInput(iis);
                    BufferedImage img = r.read(0);
                    int[] dpi = XSSFPicture.getResolution(r);
                    if (dpi[0] == 0) {
                        dpi[0] = 96;
                    }
                    if (dpi[1] == 0) {
                        dpi[1] = 96;
                    }
                    size.width = img.getWidth() * 96 / dpi[0];
                    size.height = img.getHeight() * 96 / dpi[1];
                }
                catch (IOException e) {
                    logger.log(5, e);
                }
                break;
            }
            default: {
                logger.log(5, "Only JPEG, PNG and DIB pictures can be automatically sized");
            }
        }
        return size;
    }

    protected static int[] getResolution(ImageReader r) throws IOException {
        int hdpi = 96;
        int vdpi = 96;
        double mm2inch = 25.4;
        Element node = (Element)r.getImageMetadata(0).getAsTree("javax_imageio_1.0");
        NodeList lst = node.getElementsByTagName("HorizontalPixelSize");
        if (lst != null && lst.getLength() == 1) {
            hdpi = (int)(mm2inch / (double)Float.parseFloat(((Element)lst.item(0)).getAttribute("value")));
        }
        if ((lst = node.getElementsByTagName("VerticalPixelSize")) != null && lst.getLength() == 1) {
            vdpi = (int)(mm2inch / (double)Float.parseFloat(((Element)lst.item(0)).getAttribute("value")));
        }
        return new int[]{hdpi, vdpi};
    }

    public XSSFPictureData getPictureData() {
        String blipId = this.ctPicture.getBlipFill().getBlip().getEmbed();
        for (POIXMLDocumentPart part : this.getDrawing().getRelations()) {
            if (!part.getPackageRelationship().getId().equals(blipId)) continue;
            return (XSSFPictureData)part;
        }
        logger.log(5, "Picture data was not found for blipId=" + blipId);
        return null;
    }

    protected CTShapeProperties getShapeProperties() {
        return this.ctPicture.getSpPr();
    }
}

