/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class NumberToTextConverter {
    private static final long expMask = 0x7FF0000000000000L;
    private static final long FRAC_MASK = 0xFFFFFFFFFFFFFL;
    private static final int EXPONENT_SHIFT = 52;
    private static final int FRAC_BITS_WIDTH = 52;
    private static final int EXPONENT_BIAS = 1023;
    private static final long FRAC_ASSUMED_HIGH_BIT = 0x10000000000000L;
    private static final long EXCEL_NAN_BITS = -276939487313920L;
    private static final int MAX_TEXT_LEN = 20;
    private static final int DEFAULT_COUNT_SIGNIFICANT_DIGITS = 15;
    private static final int MAX_EXTRA_ZEROS = 5;
    private static final float LOG2_10 = 3.32f;

    private NumberToTextConverter() {
    }

    public static String toText(double value) {
        return NumberToTextConverter.rawDoubleBitsToText(Double.doubleToLongBits(value));
    }

    static String rawDoubleBitsToText(long pRawBits) {
        int biasedExponent;
        boolean isNegative;
        long rawBits = pRawBits;
        boolean bl = isNegative = rawBits < 0L;
        if (isNegative) {
            rawBits &= Long.MAX_VALUE;
        }
        if ((biasedExponent = (int)((rawBits & 0x7FF0000000000000L) >> 52)) == 0) {
            return "0";
        }
        int exponent = biasedExponent - 1023;
        long fracBits = 0x10000000000000L | rawBits & 0xFFFFFFFFFFFFFL;
        if (biasedExponent == 2047) {
            if (rawBits == -276939487313920L) {
                return "3.484840871308E+308";
            }
            isNegative = false;
        }
        BigDecimal bd = NumberToTextConverter.convertToBigDecimal(exponent, fracBits);
        return NumberToTextConverter.formatBigInteger(isNegative, bd.unscaledValue(), bd.scale());
    }

    private static BigDecimal convertToBigDecimal(int exponent, long fracBits) {
        byte[] joob = new byte[]{(byte)(fracBits >> 48), (byte)(fracBits >> 40), (byte)(fracBits >> 32), (byte)(fracBits >> 24), (byte)(fracBits >> 16), (byte)(fracBits >> 8), (byte)(fracBits >> 0)};
        BigInteger bigInt = new BigInteger(joob);
        int lastSigBitIndex = exponent - 52;
        if (lastSigBitIndex < 0) {
            BigInteger shifto = new BigInteger("1").shiftLeft(-lastSigBitIndex);
            int scale = 1 - (int)((float)lastSigBitIndex / 3.32f);
            BigDecimal bd1 = new BigDecimal(bigInt);
            BigDecimal bdShifto = new BigDecimal(shifto);
            return bd1.divide(bdShifto, scale, 4);
        }
        BigInteger sl = bigInt.shiftLeft(lastSigBitIndex);
        return new BigDecimal(sl);
    }

    private static String formatBigInteger(boolean isNegative, BigInteger unscaledValue, int scale) {
        if (scale < 0) {
            throw new RuntimeException("negative scale");
        }
        StringBuffer sb = new StringBuffer(unscaledValue.toString());
        int numberOfLeadingZeros = -1;
        int unscaledLength = sb.length();
        if (scale > 0 && scale >= unscaledLength) {
            numberOfLeadingZeros = scale - unscaledLength;
            NumberToTextConverter.formatLessThanOne(sb, numberOfLeadingZeros + 1);
        } else {
            int decimalPointIndex = unscaledLength - scale;
            NumberToTextConverter.formatGreaterThanOne(sb, decimalPointIndex);
        }
        if (isNegative) {
            sb.insert(0, '-');
        }
        return sb.toString();
    }

    private static int getNumberOfSignificantFiguresDisplayed(int exponent) {
        int nLostDigits = exponent > 99 ? 1 : (exponent < -98 ? 1 : 0);
        return 15 - nLostDigits;
    }

    private static boolean needsScientificNotation(int nDigits) {
        return nDigits > 20;
    }

    private static void formatGreaterThanOne(StringBuffer sb, int nIntegerDigits) {
        int nSigFigures;
        int maxSigFigs = NumberToTextConverter.getNumberOfSignificantFiguresDisplayed(nIntegerDigits);
        int decimalPointIndex = nIntegerDigits;
        boolean roundCausedCarry = NumberToTextConverter.performRound(sb, 0, maxSigFigs);
        int endIx = Math.min(maxSigFigs, sb.length() - 1);
        if (roundCausedCarry) {
            sb.insert(0, '1');
            ++decimalPointIndex;
            nSigFigures = 1;
        } else {
            nSigFigures = NumberToTextConverter.countSignifantDigits(sb, endIx);
        }
        if (NumberToTextConverter.needsScientificNotation(decimalPointIndex)) {
            sb.setLength(nSigFigures);
            if (nSigFigures > 1) {
                sb.insert(1, '.');
            }
            sb.append("E+");
            NumberToTextConverter.appendExp(sb, decimalPointIndex - 1);
            return;
        }
        if (NumberToTextConverter.isAllZeros(sb, decimalPointIndex, maxSigFigs)) {
            sb.setLength(decimalPointIndex);
            return;
        }
        sb.setLength(nSigFigures);
        sb.insert(decimalPointIndex, '.');
    }

    private static void formatLessThanOne(StringBuffer sb, int pAbsExponent) {
        int nRemainingSigFigs;
        if (sb.charAt(0) == '\u0000') {
            throw new IllegalArgumentException("First digit of significand should be non-zero");
        }
        if (pAbsExponent < 1) {
            throw new IllegalArgumentException("abs(exponent) must be positive");
        }
        int numberOfLeadingZeros = pAbsExponent - 1;
        int absExponent = pAbsExponent;
        int maxSigFigs = NumberToTextConverter.getNumberOfSignificantFiguresDisplayed(-absExponent);
        boolean roundCausedCarry = NumberToTextConverter.performRound(sb, 0, maxSigFigs);
        if (roundCausedCarry) {
            --absExponent;
            --numberOfLeadingZeros;
            nRemainingSigFigs = 1;
            sb.setLength(0);
            sb.append("1");
        } else {
            nRemainingSigFigs = NumberToTextConverter.countSignifantDigits(sb, 0 + maxSigFigs);
            sb.setLength(nRemainingSigFigs);
        }
        int normalLength = 2 + numberOfLeadingZeros + nRemainingSigFigs;
        if (NumberToTextConverter.needsScientificNotation(normalLength)) {
            if (sb.length() > 1) {
                sb.insert(1, '.');
            }
            sb.append('E');
            sb.append('-');
            NumberToTextConverter.appendExp(sb, absExponent);
        } else {
            sb.insert(0, "0.");
            for (int i = numberOfLeadingZeros; i > 0; --i) {
                sb.insert(2, '0');
            }
        }
    }

    private static int countSignifantDigits(StringBuffer sb, int startIx) {
        int result = startIx;
        while (sb.charAt(result) == '0') {
            if (--result >= 0) continue;
            throw new RuntimeException("No non-zero digits found");
        }
        return result + 1;
    }

    private static void appendExp(StringBuffer sb, int val) {
        if (val < 10) {
            sb.append('0');
            sb.append((char)(48 + val));
            return;
        }
        sb.append(val);
    }

    private static boolean isAllZeros(StringBuffer sb, int startIx, int endIx) {
        for (int i = startIx; i <= endIx && i < sb.length(); ++i) {
            if (sb.charAt(i) == '0') continue;
            return false;
        }
        return true;
    }

    private static boolean performRound(StringBuffer sb, int firstSigFigIx, int nSigFigs) {
        int nextDigitIx = firstSigFigIx + nSigFigs;
        if (nextDigitIx == sb.length()) {
            return false;
        }
        if (nextDigitIx > sb.length()) {
            throw new RuntimeException("Buffer too small to fit all significant digits");
        }
        boolean hadCarryOutOfFirstDigit = sb.charAt(nextDigitIx) < '5' ? false : NumberToTextConverter.roundAndCarry(sb, nextDigitIx);
        int endIx = Math.min(nextDigitIx + 5, sb.length());
        for (int i = nextDigitIx; i < endIx; ++i) {
            sb.setCharAt(i, '0');
        }
        return hadCarryOutOfFirstDigit;
    }

    private static boolean roundAndCarry(StringBuffer sb, int nextDigitIx) {
        int changeDigitIx = nextDigitIx - 1;
        while (sb.charAt(changeDigitIx) == '9') {
            sb.setCharAt(changeDigitIx, '0');
            if (--changeDigitIx >= 0) continue;
            return true;
        }
        char prevDigit = sb.charAt(changeDigitIx);
        sb.setCharAt(changeDigitIx, (char)(prevDigit + '\u0001'));
        return false;
    }
}

