/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class Picture {
    private static final POILogger log = POILogFactory.getLogger(Picture.class);
    static final int MFPMM_OFFSET = 6;
    static final int BLOCK_TYPE_OFFSET = 14;
    static final int PICT_HEADER_OFFSET = 4;
    static final int UNKNOWN_HEADER_SIZE = 73;
    public static final byte[] GIF = new byte[]{71, 73, 70};
    public static final byte[] PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    public static final byte[] JPG = new byte[]{-1, -40};
    public static final byte[] BMP = new byte[]{66, 77};
    public static final byte[] TIFF = new byte[]{73, 73, 42, 0};
    public static final byte[] TIFF1 = new byte[]{77, 77, 0, 42};
    public static final byte[] EMF = new byte[]{1, 0, 0, 0};
    public static final byte[] WMF1 = new byte[]{-41, -51, -58, -102, 0, 0};
    public static final byte[] WMF2 = new byte[]{1, 0, 9, 0, 0, 3};
    public static final byte[] IHDR = new byte[]{73, 72, 68, 82};
    public static final byte[] COMPRESSED1 = new byte[]{-2, 120, -38};
    public static final byte[] COMPRESSED2 = new byte[]{-2, 120, -100};
    private int dataBlockStartOfsset;
    private int pictureBytesStartOffset;
    private int dataBlockSize;
    private int size;
    private byte[] rawContent;
    private byte[] content;
    private byte[] _dataStream;
    private int aspectRatioX;
    private int aspectRatioY;
    private int height = -1;
    private int width = -1;

    public Picture(int dataBlockStartOfsset, byte[] _dataStream, boolean fillBytes) {
        this._dataStream = _dataStream;
        this.dataBlockStartOfsset = dataBlockStartOfsset;
        this.dataBlockSize = LittleEndian.getInt(_dataStream, dataBlockStartOfsset);
        this.pictureBytesStartOffset = Picture.getPictureBytesStartOffset(dataBlockStartOfsset, _dataStream, this.dataBlockSize);
        this.size = this.dataBlockSize - (this.pictureBytesStartOffset - dataBlockStartOfsset);
        if (this.size < 0) {
            // empty if block
        }
        this.aspectRatioX = Picture.extractAspectRatioX(_dataStream, dataBlockStartOfsset);
        this.aspectRatioY = Picture.extractAspectRatioY(_dataStream, dataBlockStartOfsset);
        if (fillBytes) {
            this.fillImageContent();
        }
    }

    public Picture(byte[] _dataStream) {
        this._dataStream = _dataStream;
        this.dataBlockStartOfsset = 0;
        this.dataBlockSize = _dataStream.length;
        this.pictureBytesStartOffset = 0;
        this.size = _dataStream.length;
    }

    private void fillWidthHeight() {
        String ext = this.suggestFileExtension();
        if ("jpg".equalsIgnoreCase(ext)) {
            this.fillJPGWidthHeight();
        } else if ("png".equalsIgnoreCase(ext)) {
            this.fillPNGWidthHeight();
        }
    }

    private static int extractAspectRatioX(byte[] _dataStream, int dataBlockStartOffset) {
        return LittleEndian.getShort(_dataStream, dataBlockStartOffset + 32) / 10;
    }

    private static int extractAspectRatioY(byte[] _dataStream, int dataBlockStartOffset) {
        return LittleEndian.getShort(_dataStream, dataBlockStartOffset + 34) / 10;
    }

    public String suggestFullFileName() {
        String fileExt = this.suggestFileExtension();
        return Integer.toHexString(this.dataBlockStartOfsset) + (fileExt.length() > 0 ? "." + fileExt : "");
    }

    public void writeImageContent(OutputStream out) throws IOException {
        if (this.rawContent != null && this.rawContent.length > 0) {
            out.write(this.rawContent, 0, this.size);
        } else {
            out.write(this._dataStream, this.pictureBytesStartOffset, this.size);
        }
    }

    public byte[] getContent() {
        if (this.content == null || this.content.length <= 0) {
            this.fillImageContent();
        }
        return this.content;
    }

    public byte[] getRawContent() {
        if (this.rawContent == null || this.rawContent.length <= 0) {
            this.fillRawImageContent();
        }
        return this.rawContent;
    }

    public int getSize() {
        return this.size;
    }

    public int getAspectRatioX() {
        return this.aspectRatioX;
    }

    public int getAspectRatioY() {
        return this.aspectRatioY;
    }

    public String suggestFileExtension() {
        String extension = this.suggestFileExtension(this._dataStream, this.pictureBytesStartOffset);
        if ("".equals(extension)) {
            extension = this.suggestFileExtension(this.getContent(), 0);
        }
        return extension;
    }

    private String suggestFileExtension(byte[] _dataStream, int pictureBytesStartOffset) {
        if (Picture.matchSignature(_dataStream, JPG, pictureBytesStartOffset)) {
            return "jpg";
        }
        if (Picture.matchSignature(_dataStream, PNG, pictureBytesStartOffset)) {
            return "png";
        }
        if (Picture.matchSignature(_dataStream, GIF, pictureBytesStartOffset)) {
            return "gif";
        }
        if (Picture.matchSignature(_dataStream, BMP, pictureBytesStartOffset)) {
            return "bmp";
        }
        if (Picture.matchSignature(_dataStream, TIFF, pictureBytesStartOffset) || Picture.matchSignature(_dataStream, TIFF1, pictureBytesStartOffset)) {
            return "tiff";
        }
        this.fillImageContent();
        if (Picture.matchSignature(this.content, WMF1, 0) || Picture.matchSignature(this.content, WMF2, 0)) {
            return "wmf";
        }
        if (Picture.matchSignature(this.content, EMF, 0)) {
            return "emf";
        }
        return "";
    }

    private static boolean matchSignature(byte[] dataStream, byte[] signature, int pictureBytesOffset) {
        boolean matched = pictureBytesOffset < dataStream.length;
        for (int i = 0; i + pictureBytesOffset < dataStream.length && i < signature.length; ++i) {
            if (dataStream[i + pictureBytesOffset] == signature[i]) continue;
            matched = false;
            break;
        }
        return matched;
    }

    private void fillRawImageContent() {
        this.rawContent = new byte[this.size];
        System.arraycopy(this._dataStream, this.pictureBytesStartOffset, this.rawContent, 0, this.size);
    }

    private void fillImageContent() {
        byte[] rawContent = this.getRawContent();
        if (Picture.matchSignature(rawContent, COMPRESSED1, 32) || Picture.matchSignature(rawContent, COMPRESSED2, 32)) {
            try {
                int readBytes;
                InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(rawContent, 33, rawContent.length - 33));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((readBytes = in.read(buf)) > 0) {
                    out.write(buf, 0, readBytes);
                }
                this.content = out.toByteArray();
            }
            catch (IOException e) {
                log.log(3, (Object)"Possibly corrupt compression or non-compressed data", e);
            }
        } else {
            this.content = rawContent;
        }
    }

    private static int getPictureBytesStartOffset(int dataBlockStartOffset, byte[] _dataStream, int dataBlockSize) {
        int unknownHeaderOffset;
        int dataBlockEndOffset = dataBlockSize + dataBlockStartOffset;
        int realPicoffset = dataBlockStartOffset;
        short PICTFBlockSize = LittleEndian.getShort(_dataStream, dataBlockStartOffset + 4);
        int PICTF1BlockOffset = PICTFBlockSize + 4;
        short PICTF1BlockSize = LittleEndian.getShort(_dataStream, dataBlockStartOffset + PICTF1BlockOffset);
        int n = unknownHeaderOffset = PICTF1BlockSize + PICTF1BlockOffset < dataBlockEndOffset ? PICTF1BlockSize + PICTF1BlockOffset : PICTF1BlockOffset;
        if ((realPicoffset += unknownHeaderOffset + 73) >= dataBlockEndOffset) {
            realPicoffset -= 73;
        }
        return realPicoffset;
    }

    private void fillJPGWidthHeight() {
        int pointer = this.pictureBytesStartOffset + 2;
        byte firstByte = this._dataStream[pointer];
        byte secondByte = this._dataStream[pointer + 1];
        int endOfPicture = this.pictureBytesStartOffset + this.size;
        while (pointer < endOfPicture - 1) {
            do {
                firstByte = this._dataStream[pointer];
                secondByte = this._dataStream[pointer + 1];
            } while (firstByte != -1 && (pointer += 2) < endOfPicture - 1);
            if (firstByte == -1 && pointer < endOfPicture - 1) {
                if (secondByte == -39 || secondByte == -38) break;
                if ((secondByte & 0xF0) == 192 && secondByte != -60 && secondByte != -56 && secondByte != -52) {
                    this.height = Picture.getBigEndianShort(this._dataStream, pointer += 5);
                    this.width = Picture.getBigEndianShort(this._dataStream, pointer + 2);
                    break;
                }
                ++pointer;
                int length = Picture.getBigEndianShort(this._dataStream, ++pointer);
                pointer += length;
                continue;
            }
            ++pointer;
        }
    }

    private void fillPNGWidthHeight() {
        int HEADER_START = this.pictureBytesStartOffset + PNG.length + 4;
        if (Picture.matchSignature(this._dataStream, IHDR, HEADER_START)) {
            int IHDR_CHUNK_WIDTH = HEADER_START + 4;
            this.width = Picture.getBigEndianInt(this._dataStream, IHDR_CHUNK_WIDTH);
            this.height = Picture.getBigEndianInt(this._dataStream, IHDR_CHUNK_WIDTH + 4);
        }
    }

    public int getWidth() {
        if (this.width == -1) {
            this.fillWidthHeight();
        }
        return this.width;
    }

    public int getHeight() {
        if (this.height == -1) {
            this.fillWidthHeight();
        }
        return this.height;
    }

    private static int getBigEndianInt(byte[] data, int offset) {
        return ((data[offset] & 0xFF) << 24) + ((data[offset + 1] & 0xFF) << 16) + ((data[offset + 2] & 0xFF) << 8) + (data[offset + 3] & 0xFF);
    }

    private static int getBigEndianShort(byte[] data, int offset) {
        return ((data[offset] & 0xFF) << 8) + (data[offset + 1] & 0xFF);
    }
}

