/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.parsers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.Chunks;
import org.apache.poi.hsmf.datatypes.Types;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.hsmf.exceptions.DirectoryChunkNotFoundException;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.POIFSDocument;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.DocumentProperty;
import org.apache.poi.poifs.storage.BlockWritable;

public class POIFSChunkParser {
    private static final long serialVersionUID = 1L;
    private POIFSFileSystem fs;
    private HashMap directoryMap;

    public POIFSChunkParser(POIFSFileSystem fs) throws IOException {
        this.setFileSystem(fs);
    }

    public void setFileSystem(POIFSFileSystem fs) throws IOException {
        this.fs = fs;
        this.reparseFileSystem();
    }

    public POIFSFileSystem getFileSystem() {
        return this.fs;
    }

    public void reparseFileSystem() throws IOException {
        DirectoryNode root = this.fs.getRoot();
        Iterator iter = root.getEntries();
        this.directoryMap = this.processPOIIterator(iter);
    }

    public Chunks identifyChunks() {
        return Chunks.getInstance(this.isNewChunkVersion(this.directoryMap));
    }

    private AttachmentChunks identifyAttachmentChunks(Map attachmentMap) {
        return AttachmentChunks.getInstance(this.isNewChunkVersion(attachmentMap));
    }

    private boolean isNewChunkVersion(Map map) {
        boolean hasOldStrings = false;
        boolean hasNewStrings = false;
        String oldStringEnd = Types.asFileEnding(Types.OLD_STRING);
        String newStringEnd = Types.asFileEnding(Types.NEW_STRING);
        for (String entry : map.keySet()) {
            if (entry.endsWith(oldStringEnd)) {
                hasOldStrings = true;
            }
            if (!entry.endsWith(newStringEnd)) continue;
            hasNewStrings = true;
        }
        if (hasOldStrings && hasNewStrings) {
            throw new IllegalStateException("Your file contains string chunks of both the old and new types. Giving up");
        }
        return hasNewStrings;
    }

    public Object getChunk(HashMap dirMap, String entryName) {
        if (dirMap == null) {
            return null;
        }
        return dirMap.get(entryName);
    }

    public HashMap getDirectoryChunk(String directoryName) throws DirectoryChunkNotFoundException {
        DirectoryChunkNotFoundException excep = new DirectoryChunkNotFoundException(directoryName);
        Object obj = this.getChunk(this.directoryMap, directoryName);
        if (obj == null || !(obj instanceof HashMap)) {
            throw excep;
        }
        return (HashMap)obj;
    }

    public Chunk getDocumentNode(HashMap dirNode, Chunk chunk) throws ChunkNotFoundException {
        String entryName = chunk.getEntryName();
        ChunkNotFoundException excep = new ChunkNotFoundException(entryName);
        Object obj = this.getChunk(dirNode, entryName);
        if (obj == null || !(obj instanceof ByteArrayOutputStream)) {
            throw excep;
        }
        chunk.setValue((ByteArrayOutputStream)obj);
        return chunk;
    }

    public Chunk getDocumentNode(Chunk chunk) throws ChunkNotFoundException {
        return this.getDocumentNode(this.directoryMap, chunk);
    }

    public Map getAttachmentList() {
        HashMap<String, ByteArrayInputStream> attachments = new HashMap<String, ByteArrayInputStream>();
        ArrayList<HashMap> attachmentList = new ArrayList<HashMap>();
        for (String entry : this.directoryMap.keySet()) {
            if (!entry.startsWith("__attach_version1.0_#")) continue;
            String attachmentIdString = entry.replace("__attach_version1.0_#", "");
            try {
                int attachmentId = Integer.parseInt(attachmentIdString);
                attachmentList.add((HashMap)this.directoryMap.get(entry));
            }
            catch (NumberFormatException nfe) {
                System.err.println("Invalid attachment id");
            }
        }
        for (HashMap AttachmentChunkMap : attachmentList) {
            AttachmentChunks attachmentChunks = this.identifyAttachmentChunks(AttachmentChunkMap);
            try {
                Chunk fileName = this.getDocumentNode(AttachmentChunkMap, attachmentChunks.attachLongFileName);
                Chunk content = this.getDocumentNode(AttachmentChunkMap, attachmentChunks.attachData);
                attachments.put(fileName.toString(), new ByteArrayInputStream(content.getValueByteArray().toByteArray()));
            }
            catch (ChunkNotFoundException e) {
                System.err.println("Invalid attachment chunk");
            }
        }
        return attachments;
    }

    private HashMap processPOIIterator(Iterator iter) throws IOException {
        HashMap<String, HashMap> currentNode = new HashMap<String, HashMap>();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof DocumentNode) {
                this.processDocumentNode((DocumentNode)obj, currentNode);
                continue;
            }
            if (obj instanceof DirectoryNode) {
                String blockName = ((DirectoryNode)obj).getName();
                Iterator viewIt = null;
                if (((DirectoryNode)obj).preferArray()) {
                    Object[] arr = ((DirectoryNode)obj).getViewableArray();
                    ArrayList<Object> viewList = new ArrayList<Object>(arr.length);
                    for (int i = 0; i < arr.length; ++i) {
                        viewList.add(arr[i]);
                    }
                    viewIt = viewList.iterator();
                } else {
                    viewIt = ((DirectoryNode)obj).getViewableIterator();
                }
                currentNode.put(blockName, this.processPOIIterator(viewIt));
                continue;
            }
            if (obj instanceof DirectoryProperty) continue;
            System.err.println("Unknown node: " + obj.toString());
        }
        return currentNode;
    }

    private void processDocumentNode(DocumentNode obj, HashMap currentObj) throws IOException {
        String blockName = obj.getName();
        Iterator viewIt = null;
        if (obj.preferArray()) {
            Object[] arr = obj.getViewableArray();
            ArrayList<Object> viewList = new ArrayList<Object>(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                viewList.add(arr[i]);
            }
            viewIt = viewList.iterator();
        } else {
            viewIt = obj.getViewableIterator();
        }
        while (viewIt.hasNext()) {
            Object view = viewIt.next();
            if (view instanceof DocumentProperty) continue;
            if (view instanceof POIFSDocument) {
                ByteArrayOutputStream out;
                int blockCount = ((POIFSDocument)view).countBlocks();
                if (blockCount <= 0) {
                    out = new ByteArrayOutputStream();
                    BlockWritable[] bws = ((POIFSDocument)view).getSmallBlocks();
                    for (int i = 0; i < bws.length; ++i) {
                        bws[i].writeBlocks(out);
                    }
                    currentObj.put(blockName, out);
                    continue;
                }
                out = new ByteArrayOutputStream();
                ((POIFSDocument)view).writeBlocks(out);
                currentObj.put(blockName, out);
                continue;
            }
            System.err.println("Unknown View Type: " + view.toString());
        }
    }
}

