/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.model.HeadersFooters;
import org.apache.poi.hslf.model.Hyperlink;
import org.apache.poi.hslf.model.MasterSheet;
import org.apache.poi.hslf.model.PPFont;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.SlideMaster;
import org.apache.poi.hslf.model.TitleMaster;
import org.apache.poi.hslf.record.Document;
import org.apache.poi.hslf.record.DocumentAtom;
import org.apache.poi.hslf.record.ExAviMovie;
import org.apache.poi.hslf.record.ExControl;
import org.apache.poi.hslf.record.ExHyperlink;
import org.apache.poi.hslf.record.ExHyperlinkAtom;
import org.apache.poi.hslf.record.ExMCIMovie;
import org.apache.poi.hslf.record.ExObjList;
import org.apache.poi.hslf.record.ExObjListAtom;
import org.apache.poi.hslf.record.ExOleObjAtom;
import org.apache.poi.hslf.record.ExVideoContainer;
import org.apache.poi.hslf.record.FontCollection;
import org.apache.poi.hslf.record.FontEntityAtom;
import org.apache.poi.hslf.record.HeadersFootersContainer;
import org.apache.poi.hslf.record.MainMaster;
import org.apache.poi.hslf.record.Notes;
import org.apache.poi.hslf.record.ParentAwareRecord;
import org.apache.poi.hslf.record.PersistPtrHolder;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.PositionDependentRecordContainer;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordContainer;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.Slide;
import org.apache.poi.hslf.record.SlideListWithText;
import org.apache.poi.hslf.record.SlidePersistAtom;
import org.apache.poi.hslf.record.UserEditAtom;
import org.apache.poi.hslf.usermodel.ObjectData;
import org.apache.poi.hslf.usermodel.PictureData;
import org.apache.poi.hslf.usermodel.SoundData;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class SlideShow {
    private HSLFSlideShow _hslfSlideShow;
    private Record[] _records;
    private Record[] _mostRecentCoreRecords;
    private Hashtable _sheetIdToCoreRecordsLookup;
    private Document _documentRecord;
    private SlideMaster[] _masters;
    private TitleMaster[] _titleMasters;
    private org.apache.poi.hslf.model.Slide[] _slides;
    private org.apache.poi.hslf.model.Notes[] _notes;
    private FontCollection _fonts;
    private POILogger logger = POILogFactory.getLogger(this.getClass());

    public SlideShow(HSLFSlideShow hslfSlideShow) {
        this._hslfSlideShow = hslfSlideShow;
        this._records = this._hslfSlideShow.getRecords();
        for (int i = 0; i < this._records.length; ++i) {
            this.handleParentAwareRecords(this._records[i]);
        }
        this.findMostRecentCoreRecords();
        this.buildSlidesAndNotes();
    }

    public SlideShow() {
        this(HSLFSlideShow.create());
    }

    public SlideShow(InputStream inputStream) throws IOException {
        this(new HSLFSlideShow(inputStream));
    }

    private void handleParentAwareRecords(Record baseRecord) {
        if (baseRecord instanceof RecordContainer) {
            RecordContainer br = (RecordContainer)baseRecord;
            Record[] childRecords = br.getChildRecords();
            for (int i = 0; i < childRecords.length; ++i) {
                Record record = childRecords[i];
                if (record instanceof ParentAwareRecord) {
                    ((ParentAwareRecord)((Object)record)).setParentRecord(br);
                }
                if (!(record instanceof RecordContainer)) continue;
                this.handleParentAwareRecords(record);
            }
        }
    }

    private void findMostRecentCoreRecords() {
        int i;
        Hashtable mostRecentByBytes = new Hashtable();
        for (int i2 = 0; i2 < this._records.length; ++i2) {
            if (!(this._records[i2] instanceof PersistPtrHolder)) continue;
            PersistPtrHolder pph = (PersistPtrHolder)this._records[i2];
            int[] ids = pph.getKnownSlideIDs();
            for (int j = 0; j < ids.length; ++j) {
                Integer id = new Integer(ids[j]);
                if (!mostRecentByBytes.containsKey(id)) continue;
                mostRecentByBytes.remove(id);
            }
            Hashtable thisSetOfLocations = pph.getSlideLocationsLookup();
            for (int j = 0; j < ids.length; ++j) {
                Integer id = new Integer(ids[j]);
                mostRecentByBytes.put(id, thisSetOfLocations.get(id));
            }
        }
        this._mostRecentCoreRecords = new Record[mostRecentByBytes.size()];
        this._sheetIdToCoreRecordsLookup = new Hashtable();
        int[] allIDs = new int[this._mostRecentCoreRecords.length];
        Enumeration ids = mostRecentByBytes.keys();
        for (i = 0; i < allIDs.length; ++i) {
            Integer id = (Integer)ids.nextElement();
            allIDs[i] = id;
        }
        Arrays.sort(allIDs);
        for (i = 0; i < allIDs.length; ++i) {
            this._sheetIdToCoreRecordsLookup.put(new Integer(allIDs[i]), new Integer(i));
        }
        for (i = 0; i < this._records.length; ++i) {
            if (!(this._records[i] instanceof PositionDependentRecord)) continue;
            PositionDependentRecord pdr = (PositionDependentRecord)((Object)this._records[i]);
            Integer recordAt = new Integer(pdr.getLastOnDiskOffset());
            for (int j = 0; j < allIDs.length; ++j) {
                Integer thisID = new Integer(allIDs[j]);
                Integer thatRecordAt = (Integer)mostRecentByBytes.get(thisID);
                if (!thatRecordAt.equals(recordAt)) continue;
                Integer storeAtI = (Integer)this._sheetIdToCoreRecordsLookup.get(thisID);
                int storeAt = storeAtI;
                if (pdr instanceof PositionDependentRecordContainer) {
                    PositionDependentRecordContainer pdrc = (PositionDependentRecordContainer)this._records[i];
                    pdrc.setSheetId(thisID);
                }
                this._mostRecentCoreRecords[storeAt] = this._records[i];
            }
        }
        for (i = 0; i < this._mostRecentCoreRecords.length; ++i) {
            if (this._mostRecentCoreRecords[i] == null || this._mostRecentCoreRecords[i].getRecordType() != (long)RecordTypes.Document.typeID) continue;
            this._documentRecord = (Document)this._mostRecentCoreRecords[i];
            this._fonts = this._documentRecord.getEnvironment().getFontCollection();
        }
    }

    private Record getCoreRecordForSAS(SlideListWithText.SlideAtomsSet sas) {
        SlidePersistAtom spa = sas.getSlidePersistAtom();
        int refID = spa.getRefID();
        return this.getCoreRecordForRefID(refID);
    }

    private Record getCoreRecordForRefID(int refID) {
        Integer coreRecordId = (Integer)this._sheetIdToCoreRecordsLookup.get(new Integer(refID));
        if (coreRecordId != null) {
            Record r = this._mostRecentCoreRecords[coreRecordId];
            return r;
        }
        this.logger.log(7, "We tried to look up a reference to a core record, but there was no core ID for reference ID " + refID);
        return null;
    }

    private void buildSlidesAndNotes() {
        int i;
        Slide[] slidesRecords;
        Notes[] notesRecords;
        if (this._documentRecord == null) {
            throw new CorruptPowerPointFileException("The PowerPoint file didn't contain a Document Record in its PersistPtr blocks. It is probably corrupt.");
        }
        SlideListWithText masterSLWT = this._documentRecord.getMasterSlideListWithText();
        SlideListWithText slidesSLWT = this._documentRecord.getSlideSlideListWithText();
        SlideListWithText notesSLWT = this._documentRecord.getNotesSlideListWithText();
        SlideListWithText.SlideAtomsSet[] masterSets = new SlideListWithText.SlideAtomsSet[]{};
        if (masterSLWT != null) {
            masterSets = masterSLWT.getSlideAtomsSets();
            ArrayList<MasterSheet> mmr = new ArrayList<MasterSheet>();
            ArrayList<MasterSheet> tmr = new ArrayList<MasterSheet>();
            for (int i2 = 0; i2 < masterSets.length; ++i2) {
                MasterSheet master;
                Record r = this.getCoreRecordForSAS(masterSets[i2]);
                SlideListWithText.SlideAtomsSet sas = masterSets[i2];
                int sheetNo = sas.getSlidePersistAtom().getSlideIdentifier();
                if (r instanceof Slide) {
                    master = new TitleMaster((Slide)r, sheetNo);
                    master.setSlideShow(this);
                    tmr.add(master);
                    continue;
                }
                if (!(r instanceof MainMaster)) continue;
                master = new SlideMaster((MainMaster)r, sheetNo);
                ((SlideMaster)master).setSlideShow(this);
                mmr.add(master);
            }
            this._masters = new SlideMaster[mmr.size()];
            mmr.toArray(this._masters);
            this._titleMasters = new TitleMaster[tmr.size()];
            tmr.toArray(this._titleMasters);
        }
        SlideListWithText.SlideAtomsSet[] notesSets = new SlideListWithText.SlideAtomsSet[]{};
        Hashtable<Integer, Integer> slideIdToNotes = new Hashtable<Integer, Integer>();
        if (notesSLWT == null) {
            notesRecords = new Notes[]{};
        } else {
            notesSets = notesSLWT.getSlideAtomsSets();
            ArrayList<Notes> notesRecordsL = new ArrayList<Notes>();
            for (int i3 = 0; i3 < notesSets.length; ++i3) {
                Record r = this.getCoreRecordForSAS(notesSets[i3]);
                if (r instanceof Notes) {
                    Notes notesRecord = (Notes)r;
                    notesRecordsL.add(notesRecord);
                    SlidePersistAtom spa = notesSets[i3].getSlidePersistAtom();
                    Integer slideId = new Integer(spa.getSlideIdentifier());
                    slideIdToNotes.put(slideId, new Integer(i3));
                    continue;
                }
                this.logger.log(7, "A Notes SlideAtomSet at " + i3 + " said its record was at refID " + notesSets[i3].getSlidePersistAtom().getRefID() + ", but that was actually a " + r);
            }
            notesRecords = new Notes[notesRecordsL.size()];
            notesRecords = notesRecordsL.toArray(notesRecords);
        }
        SlideListWithText.SlideAtomsSet[] slidesSets = new SlideListWithText.SlideAtomsSet[]{};
        if (slidesSLWT == null) {
            slidesRecords = new Slide[]{};
        } else {
            slidesSets = slidesSLWT.getSlideAtomsSets();
            slidesRecords = new Slide[slidesSets.length];
            for (int i4 = 0; i4 < slidesSets.length; ++i4) {
                Record r = this.getCoreRecordForSAS(slidesSets[i4]);
                if (r instanceof Slide) {
                    slidesRecords[i4] = (Slide)r;
                    continue;
                }
                this.logger.log(7, "A Slide SlideAtomSet at " + i4 + " said its record was at refID " + slidesSets[i4].getSlidePersistAtom().getRefID() + ", but that was actually a " + r);
            }
        }
        this._notes = new org.apache.poi.hslf.model.Notes[notesRecords.length];
        for (i = 0; i < this._notes.length; ++i) {
            this._notes[i] = new org.apache.poi.hslf.model.Notes(notesRecords[i]);
            this._notes[i].setSlideShow(this);
        }
        this._slides = new org.apache.poi.hslf.model.Slide[slidesRecords.length];
        for (i = 0; i < this._slides.length; ++i) {
            SlideListWithText.SlideAtomsSet sas = slidesSets[i];
            int slideIdentifier = sas.getSlidePersistAtom().getSlideIdentifier();
            org.apache.poi.hslf.model.Notes notes = null;
            int noteId = slidesRecords[i].getSlideAtom().getNotesID();
            if (noteId != 0) {
                Integer notesPos = (Integer)slideIdToNotes.get(new Integer(noteId));
                if (notesPos != null) {
                    notes = this._notes[notesPos];
                } else {
                    this.logger.log(7, "Notes not found for noteId=" + noteId);
                }
            }
            this._slides[i] = new org.apache.poi.hslf.model.Slide(slidesRecords[i], notes, sas, slideIdentifier, i + 1);
            this._slides[i].setSlideShow(this);
        }
    }

    public void write(OutputStream out) throws IOException {
        this._hslfSlideShow.write(out);
    }

    public Record[] getMostRecentCoreRecords() {
        return this._mostRecentCoreRecords;
    }

    public org.apache.poi.hslf.model.Slide[] getSlides() {
        return this._slides;
    }

    public org.apache.poi.hslf.model.Notes[] getNotes() {
        return this._notes;
    }

    public SlideMaster[] getSlidesMasters() {
        return this._masters;
    }

    public TitleMaster[] getTitleMasters() {
        return this._titleMasters;
    }

    public PictureData[] getPictureData() {
        return this._hslfSlideShow.getPictures();
    }

    public ObjectData[] getEmbeddedObjects() {
        return this._hslfSlideShow.getEmbeddedObjects();
    }

    public SoundData[] getSoundData() {
        return SoundData.find(this._documentRecord);
    }

    public Dimension getPageSize() {
        DocumentAtom docatom = this._documentRecord.getDocumentAtom();
        int pgx = (int)docatom.getSlideSizeX() * 72 / 576;
        int pgy = (int)docatom.getSlideSizeY() * 72 / 576;
        return new Dimension(pgx, pgy);
    }

    public void setPageSize(Dimension pgsize) {
        DocumentAtom docatom = this._documentRecord.getDocumentAtom();
        docatom.setSlideSizeX(pgsize.width * 576 / 72);
        docatom.setSlideSizeY(pgsize.height * 576 / 72);
    }

    protected FontCollection getFontCollection() {
        return this._fonts;
    }

    public Document getDocumentRecord() {
        return this._documentRecord;
    }

    public void reorderSlide(int oldSlideNumber, int newSlideNumber) {
        if (oldSlideNumber < 1 || newSlideNumber < 1) {
            throw new IllegalArgumentException("Old and new slide numbers must be greater than 0");
        }
        if (oldSlideNumber > this._slides.length || newSlideNumber > this._slides.length) {
            throw new IllegalArgumentException("Old and new slide numbers must not exceed the number of slides (" + this._slides.length + ")");
        }
        SlideListWithText slwt = this._documentRecord.getSlideSlideListWithText();
        SlideListWithText.SlideAtomsSet[] sas = slwt.getSlideAtomsSets();
        SlideListWithText.SlideAtomsSet tmp = sas[oldSlideNumber - 1];
        sas[oldSlideNumber - 1] = sas[newSlideNumber - 1];
        sas[newSlideNumber - 1] = tmp;
        ArrayList<Record> lst = new ArrayList<Record>();
        for (int i = 0; i < sas.length; ++i) {
            lst.add(sas[i].getSlidePersistAtom());
            Record[] r = sas[i].getSlideRecords();
            for (int j = 0; j < r.length; ++j) {
                lst.add(r[j]);
            }
            this._slides[i].setSlideNumber(i + 1);
        }
        Record[] r = lst.toArray(new Record[lst.size()]);
        slwt.setChildRecord(r);
    }

    public org.apache.poi.hslf.model.Slide removeSlide(int index) {
        int lastSlideIdx = this._slides.length - 1;
        if (index < 0 || index > lastSlideIdx) {
            throw new IllegalArgumentException("Slide index (" + index + ") is out of range (0.." + lastSlideIdx + ")");
        }
        SlideListWithText slwt = this._documentRecord.getSlideSlideListWithText();
        SlideListWithText.SlideAtomsSet[] sas = slwt.getSlideAtomsSets();
        org.apache.poi.hslf.model.Slide removedSlide = null;
        ArrayList<Record> records = new ArrayList<Record>();
        ArrayList<SlideListWithText.SlideAtomsSet> sa = new ArrayList<SlideListWithText.SlideAtomsSet>();
        ArrayList<org.apache.poi.hslf.model.Slide> sl = new ArrayList<org.apache.poi.hslf.model.Slide>();
        int num = 0;
        for (int i = 0; i < this._slides.length; ++i) {
            if (i != index) {
                sl.add(this._slides[i]);
                sa.add(sas[i]);
                this._slides[i].setSlideNumber(num++);
                records.add(sas[i].getSlidePersistAtom());
                records.addAll(Arrays.asList(sas[i].getSlideRecords()));
                continue;
            }
            removedSlide = this._slides[i];
        }
        slwt.setSlideAtomsSets(sa.toArray(new SlideListWithText.SlideAtomsSet[sa.size()]));
        slwt.setChildRecord(records.toArray(new Record[records.size()]));
        this._slides = sl.toArray(new org.apache.poi.hslf.model.Slide[sl.size()]);
        return removedSlide;
    }

    public org.apache.poi.hslf.model.Slide createSlide() {
        SlideListWithText slist = null;
        slist = this._documentRecord.getSlideSlideListWithText();
        if (slist == null) {
            slist = new SlideListWithText();
            slist.setInstance(0);
            this._documentRecord.addSlideListWithText(slist);
        }
        SlidePersistAtom prev = null;
        SlideListWithText.SlideAtomsSet[] sas = slist.getSlideAtomsSets();
        for (int j = 0; j < sas.length; ++j) {
            SlidePersistAtom spa = sas[j].getSlidePersistAtom();
            if (spa.getSlideIdentifier() < 0) continue;
            if (prev == null) {
                prev = spa;
            }
            if (prev.getSlideIdentifier() >= spa.getSlideIdentifier()) continue;
            prev = spa;
        }
        SlidePersistAtom sp = new SlidePersistAtom();
        sp.setSlideIdentifier(prev == null ? 256 : prev.getSlideIdentifier() + 1);
        slist.addSlidePersistAtom(sp);
        org.apache.poi.hslf.model.Slide slide = new org.apache.poi.hslf.model.Slide(sp.getSlideIdentifier(), sp.getRefID(), this._slides.length + 1);
        slide.setSlideShow(this);
        slide.onCreate();
        org.apache.poi.hslf.model.Slide[] s = new org.apache.poi.hslf.model.Slide[this._slides.length + 1];
        System.arraycopy(this._slides, 0, s, 0, this._slides.length);
        s[this._slides.length] = slide;
        this._slides = s;
        this.logger.log(3, "Added slide " + this._slides.length + " with ref " + sp.getRefID() + " and identifier " + sp.getSlideIdentifier());
        Slide slideRecord = slide.getSlideRecord();
        int slideRecordPos = this._hslfSlideShow.appendRootLevelRecord(slideRecord);
        this._records = this._hslfSlideShow.getRecords();
        int offset = 0;
        int slideOffset = 0;
        PersistPtrHolder ptr = null;
        UserEditAtom usr = null;
        for (int i = 0; i < this._records.length; ++i) {
            Record record = this._records[i];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                record.writeOut(out);
            }
            catch (IOException e) {
                throw new HSLFException(e);
            }
            if (this._records[i].getRecordType() == (long)RecordTypes.PersistPtrIncrementalBlock.typeID) {
                ptr = (PersistPtrHolder)this._records[i];
            }
            if (this._records[i].getRecordType() == (long)RecordTypes.UserEditAtom.typeID) {
                usr = (UserEditAtom)this._records[i];
            }
            if (i == slideRecordPos) {
                slideOffset = offset;
            }
            offset += out.size();
        }
        int psrId = usr.getMaxPersistWritten() + 1;
        sp.setRefID(psrId);
        slideRecord.setSheetId(psrId);
        usr.setLastViewType((short)1);
        usr.setMaxPersistWritten(psrId);
        slideRecord.setLastOnDiskOffset(slideOffset);
        ptr.addSlideLookup(sp.getRefID(), slideOffset);
        this.logger.log(3, "New slide ended up at " + slideOffset);
        slide.setMasterSheet(this._masters[0]);
        return slide;
    }

    public int addPicture(byte[] data, int format) throws IOException {
        EscherBSERecord bse;
        byte[] uid = PictureData.getChecksum(data);
        EscherContainerRecord dggContainer = this._documentRecord.getPPDrawingGroup().getDggContainer();
        EscherContainerRecord bstore = (EscherContainerRecord)Shape.getEscherChild(dggContainer, -4095);
        if (bstore == null) {
            bstore = new EscherContainerRecord();
            bstore.setRecordId((short)-4095);
            dggContainer.addChildBefore(bstore, -4085);
        } else {
            Iterator<EscherRecord> iter = bstore.getChildIterator();
            int i = 0;
            while (iter.hasNext()) {
                bse = (EscherBSERecord)iter.next();
                if (Arrays.equals(bse.getUid(), uid)) {
                    return i + 1;
                }
                ++i;
            }
        }
        PictureData pict = PictureData.create(format);
        pict.setData(data);
        int offset = this._hslfSlideShow.addPicture(pict);
        bse = new EscherBSERecord();
        bse.setRecordId((short)-4089);
        bse.setOptions((short)(2 | format << 4));
        bse.setSize(pict.getRawData().length + 8);
        bse.setUid(uid);
        bse.setBlipTypeMacOS((byte)format);
        bse.setBlipTypeWin32((byte)format);
        if (format == 2) {
            bse.setBlipTypeMacOS((byte)4);
        } else if (format == 3) {
            bse.setBlipTypeMacOS((byte)4);
        } else if (format == 4) {
            bse.setBlipTypeWin32((byte)3);
        }
        bse.setRef(0);
        bse.setOffset(offset);
        bse.setRemainingData(new byte[0]);
        bstore.addChildRecord(bse);
        int count = bstore.getChildRecords().size();
        bstore.setOptions((short)(count << 4 | 0xF));
        return count;
    }

    public int addPicture(File pict, int format) throws IOException {
        int length = (int)pict.length();
        byte[] data = new byte[length];
        try {
            FileInputStream is = new FileInputStream(pict);
            is.read(data);
            is.close();
        }
        catch (IOException e) {
            throw new HSLFException(e);
        }
        return this.addPicture(data, format);
    }

    public int addFont(PPFont font) {
        FontCollection fonts = this.getDocumentRecord().getEnvironment().getFontCollection();
        int idx = fonts.getFontIndex(font.getFontName());
        if (idx == -1) {
            idx = fonts.addFont(font.getFontName(), font.getCharSet(), font.getFontFlags(), font.getFontType(), font.getPitchAndFamily());
        }
        return idx;
    }

    public PPFont getFont(int idx) {
        PPFont font = null;
        FontCollection fonts = this.getDocumentRecord().getEnvironment().getFontCollection();
        Record[] ch = fonts.getChildRecords();
        for (int i = 0; i < ch.length; ++i) {
            FontEntityAtom atom;
            if (!(ch[i] instanceof FontEntityAtom) || (atom = (FontEntityAtom)ch[i]).getFontIndex() != idx) continue;
            font = new PPFont(atom);
            break;
        }
        return font;
    }

    public int getNumberOfFonts() {
        return this.getDocumentRecord().getEnvironment().getFontCollection().getNumberOfFonts();
    }

    public HeadersFooters getSlideHeadersFooters() {
        String tag = this.getSlidesMasters()[0].getProgrammableTag();
        boolean ppt2007 = "___PPT12".equals(tag);
        HeadersFootersContainer hdd = null;
        Record[] ch = this._documentRecord.getChildRecords();
        for (int i = 0; i < ch.length; ++i) {
            if (!(ch[i] instanceof HeadersFootersContainer) || ((HeadersFootersContainer)ch[i]).getOptions() != 63) continue;
            hdd = (HeadersFootersContainer)ch[i];
            break;
        }
        boolean newRecord = false;
        if (hdd == null) {
            hdd = new HeadersFootersContainer(63);
            newRecord = true;
        }
        return new HeadersFooters(hdd, this, newRecord, ppt2007);
    }

    public HeadersFooters getNotesHeadersFooters() {
        String tag = this.getSlidesMasters()[0].getProgrammableTag();
        boolean ppt2007 = "___PPT12".equals(tag);
        HeadersFootersContainer hdd = null;
        Record[] ch = this._documentRecord.getChildRecords();
        for (int i = 0; i < ch.length; ++i) {
            if (!(ch[i] instanceof HeadersFootersContainer) || ((HeadersFootersContainer)ch[i]).getOptions() != 79) continue;
            hdd = (HeadersFootersContainer)ch[i];
            break;
        }
        boolean newRecord = false;
        if (hdd == null) {
            hdd = new HeadersFootersContainer(79);
            newRecord = true;
        }
        if (ppt2007 && this._notes.length > 0) {
            return new HeadersFooters(hdd, this._notes[0], newRecord, ppt2007);
        }
        return new HeadersFooters(hdd, this, newRecord, ppt2007);
    }

    public int addMovie(String path, int type) {
        ExMCIMovie mci;
        ExObjList lst = (ExObjList)this._documentRecord.findFirstOfType(RecordTypes.ExObjList.typeID);
        if (lst == null) {
            lst = new ExObjList();
            this._documentRecord.addChildAfter(lst, this._documentRecord.getDocumentAtom());
        }
        ExObjListAtom objAtom = lst.getExObjListAtom();
        int objectId = (int)objAtom.getObjectIDSeed() + 1;
        objAtom.setObjectIDSeed(objectId);
        switch (type) {
            case 1: {
                mci = new ExMCIMovie();
                break;
            }
            case 2: {
                mci = new ExAviMovie();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Movie: " + type);
            }
        }
        lst.appendChildRecord(mci);
        ExVideoContainer exVideo = mci.getExVideo();
        exVideo.getExMediaAtom().setObjectId(objectId);
        exVideo.getExMediaAtom().setMask(0xE80000);
        exVideo.getPathAtom().setText(path);
        return objectId;
    }

    public int addControl(String name, String progId) {
        ExObjList lst = (ExObjList)this._documentRecord.findFirstOfType(RecordTypes.ExObjList.typeID);
        if (lst == null) {
            lst = new ExObjList();
            this._documentRecord.addChildAfter(lst, this._documentRecord.getDocumentAtom());
        }
        ExObjListAtom objAtom = lst.getExObjListAtom();
        int objectId = (int)objAtom.getObjectIDSeed() + 1;
        objAtom.setObjectIDSeed(objectId);
        ExControl ctrl = new ExControl();
        ExOleObjAtom oleObj = ctrl.getExOleObjAtom();
        oleObj.setObjID(objectId);
        oleObj.setDrawAspect(1);
        oleObj.setType(2);
        oleObj.setSubType(0);
        ctrl.setProgId(progId);
        ctrl.setMenuName(name);
        ctrl.setClipboardName(name);
        lst.addChildAfter(ctrl, objAtom);
        return objectId;
    }

    public int addHyperlink(Hyperlink link) {
        ExObjList lst = (ExObjList)this._documentRecord.findFirstOfType(RecordTypes.ExObjList.typeID);
        if (lst == null) {
            lst = new ExObjList();
            this._documentRecord.addChildAfter(lst, this._documentRecord.getDocumentAtom());
        }
        ExObjListAtom objAtom = lst.getExObjListAtom();
        int objectId = (int)objAtom.getObjectIDSeed() + 1;
        objAtom.setObjectIDSeed(objectId);
        ExHyperlink ctrl = new ExHyperlink();
        ExHyperlinkAtom obj = ctrl.getExHyperlinkAtom();
        obj.setNumber(objectId);
        ctrl.setLinkURL(link.getAddress());
        ctrl.setLinkTitle(link.getTitle());
        lst.addChildAfter(ctrl, objAtom);
        link.setId(objectId);
        return objectId;
    }
}

