/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.model.Freeform;
import org.apache.poi.hslf.model.ShapeGroup;
import org.apache.poi.hslf.model.SimpleShape;
import org.apache.poi.hslf.model.TextBox;
import org.apache.poi.hslf.usermodel.RichTextRun;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class PPGraphics2D
extends Graphics2D
implements Cloneable {
    protected POILogger log = POILogFactory.getLogger(this.getClass());
    private ShapeGroup group;
    private AffineTransform transform;
    private Stroke stroke;
    private Paint paint;
    private Font font;
    private Color foreground;
    private Color background;
    private RenderingHints hints;

    public PPGraphics2D(ShapeGroup group) {
        this.group = group;
        this.transform = new AffineTransform();
        this.stroke = new BasicStroke();
        this.paint = Color.black;
        this.font = new Font("Arial", 0, 12);
        this.background = Color.black;
        this.foreground = Color.white;
        this.hints = new RenderingHints(null);
    }

    public ShapeGroup getShapeGroup() {
        return this.group;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getColor() {
        return this.foreground;
    }

    public void setColor(Color c) {
        this.setPaint(c);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke s) {
        this.stroke = s;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this.paint = paint;
        if (paint instanceof Color) {
            this.foreground = (Color)paint;
        }
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    public void setTransform(AffineTransform Tx) {
        this.transform = new AffineTransform(Tx);
    }

    public void draw(Shape shape) {
        GeneralPath path = new GeneralPath(this.transform.createTransformedShape(shape));
        Freeform p = new Freeform(this.group);
        p.setPath(path);
        p.getFill().setForegroundColor(null);
        this.applyStroke(p);
        this.group.addShape(p);
    }

    public void drawString(String s, float x, float y) {
        TextBox txt = new TextBox(this.group);
        txt.getTextRun().supplySlideShow(this.group.getSheet().getSlideShow());
        txt.getTextRun().setSheet(this.group.getSheet());
        txt.setText(s);
        RichTextRun rt = txt.getTextRun().getRichTextRuns()[0];
        rt.setFontSize(this.font.getSize());
        rt.setFontName(this.font.getFamily());
        if (this.getColor() != null) {
            rt.setFontColor(this.getColor());
        }
        if (this.font.isBold()) {
            rt.setBold(true);
        }
        if (this.font.isItalic()) {
            rt.setItalic(true);
        }
        txt.setMarginBottom(0.0f);
        txt.setMarginTop(0.0f);
        txt.setMarginLeft(0.0f);
        txt.setMarginRight(0.0f);
        txt.setWordWrap(2);
        txt.setHorizontalAlignment(0);
        txt.setVerticalAlignment(1);
        TextLayout layout = new TextLayout(s, this.font, this.getFontRenderContext());
        float ascent = layout.getAscent();
        float width = (float)Math.floor(layout.getAdvance());
        float height = ascent * 2.0f;
        txt.setAnchor(new Rectangle2D.Float(x, y -= height / 2.0f + ascent / 2.0f, width, height));
        this.group.addShape(txt);
    }

    public void fill(Shape shape) {
        GeneralPath path = new GeneralPath(this.transform.createTransformedShape(shape));
        Freeform p = new Freeform(this.group);
        p.setPath(path);
        this.applyPaint(p);
        p.setLineColor(null);
        this.group.addShape(p);
    }

    public void translate(int x, int y) {
        this.transform.translate(x, y);
    }

    public void clip(Shape s) {
        this.log.log(5, "Not implemented");
    }

    public Shape getClip() {
        this.log.log(5, "Not implemented");
        return null;
    }

    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Float rect = new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight);
        this.draw(rect);
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    public void fillOval(int x, int y, int width, int height) {
        Ellipse2D.Float oval = new Ellipse2D.Float(x, y, width, height);
        this.fill(oval);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Float rect = new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight);
        this.fill(rect);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Float arc = new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 2);
        this.fill(arc);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Float arc = new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0);
        this.draw(arc);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 0) {
            GeneralPath path = new GeneralPath();
            path.moveTo(xPoints[0], yPoints[0]);
            for (int i = 1; i < nPoints; ++i) {
                path.lineTo(xPoints[i], yPoints[i]);
            }
            this.draw(path);
        }
    }

    public void drawOval(int x, int y, int width, int height) {
        Ellipse2D.Float oval = new Ellipse2D.Float(x, y, width, height);
        this.draw(oval);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        this.log.log(5, "Not implemented");
        return false;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        this.log.log(5, "Not implemented");
        return false;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        this.log.log(5, "Not implemented");
        return false;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        this.log.log(5, "Not implemented");
        return false;
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        this.log.log(5, "Not implemented");
        return false;
    }

    public void dispose() {
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Float line = new Line2D.Float(x1, y1, x2, y2);
        this.draw(line);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon polygon = new Polygon(xPoints, yPoints, nPoints);
        this.fill(polygon);
    }

    public void fillRect(int x, int y, int width, int height) {
        Rectangle rect = new Rectangle(x, y, width, height);
        this.fill(rect);
    }

    public void drawRect(int x, int y, int width, int height) {
        Rectangle rect = new Rectangle(x, y, width, height);
        this.draw(rect);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon polygon = new Polygon(xPoints, yPoints, nPoints);
        this.draw(polygon);
    }

    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    public void setClip(Shape clip) {
        this.log.log(5, "Not implemented");
    }

    public Rectangle getClipBounds() {
        Shape c = this.getClip();
        if (c == null) {
            return null;
        }
        return c.getBounds();
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    public void clearRect(int x, int y, int width, int height) {
        Paint paint = this.getPaint();
        this.setColor(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setPaint(paint);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    public void rotate(double theta) {
        this.transform.rotate(theta);
    }

    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
    }

    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
    }

    public FontRenderContext getFontRenderContext() {
        boolean isAntiAliased = RenderingHints.VALUE_TEXT_ANTIALIAS_ON.equals(this.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
        boolean usesFractionalMetrics = RenderingHints.VALUE_FRACTIONALMETRICS_ON.equals(this.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS));
        return new FontRenderContext(new AffineTransform(), isAntiAliased, usesFractionalMetrics);
    }

    public void transform(AffineTransform Tx) {
        this.transform.concatenate(Tx);
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        img = op.filter(img, null);
        this.drawImage((Image)img, x, y, null);
    }

    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setComposite(Composite comp) {
        this.log.log(5, "Not implemented");
    }

    public Composite getComposite() {
        this.log.log(5, "Not implemented");
        return null;
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.hints.get(hintKey);
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.hints.put(hintKey, hintValue);
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        Shape glyphOutline = g.getOutline(x, y);
        this.fill(glyphOutline);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public void addRenderingHints(Map hints) {
        this.hints.putAll((Map<?, ?>)hints);
    }

    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.log.log(5, "Not implemented");
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke) {
            s = this.getStroke().createStrokedShape(s);
        }
        s = this.getTransform().createTransformedShape(s);
        return s.intersects(rect);
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public void setRenderingHints(Map hints) {
        this.hints = new RenderingHints(hints);
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        this.log.log(5, "Not implemented");
        return false;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        this.log.log(5, "Not implemented");
        return false;
    }

    public Graphics create() {
        try {
            return (Graphics)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HSLFException(e);
        }
    }

    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    public void setXORMode(Color c1) {
        this.log.log(5, "Not implemented");
    }

    public void setPaintMode() {
        this.log.log(5, "Not implemented");
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.log.log(5, "Not implemented");
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.log.log(5, "Not implemented");
    }

    protected void applyStroke(SimpleShape shape) {
        if (this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            shape.setLineWidth(bs.getLineWidth());
            float[] dash = bs.getDashArray();
            if (dash != null) {
                shape.setLineDashing(7);
            }
        }
    }

    protected void applyPaint(SimpleShape shape) {
        if (this.paint instanceof Color) {
            shape.getFill().setForegroundColor((Color)this.paint);
        }
    }
}

