/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.extractor;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.model.Comment;
import org.apache.poi.hslf.model.HeadersFooters;
import org.apache.poi.hslf.model.Notes;
import org.apache.poi.hslf.model.Slide;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.usermodel.SlideShow;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class PowerPointExtractor
extends POIOLE2TextExtractor {
    private HSLFSlideShow _hslfshow;
    private SlideShow _show;
    private Slide[] _slides;
    private boolean slidesByDefault = true;
    private boolean notesByDefault = false;
    private boolean commentsByDefault = false;

    public static void main(String[] args) throws IOException {
        String file;
        if (args.length < 1) {
            System.err.println("Useage:");
            System.err.println("\tPowerPointExtractor [-notes] <file>");
            System.exit(1);
        }
        boolean notes = false;
        boolean comments = false;
        if (args.length > 1) {
            notes = true;
            file = args[1];
            if (args.length > 2) {
                comments = true;
            }
        } else {
            file = args[0];
        }
        PowerPointExtractor ppe = new PowerPointExtractor(file);
        System.out.println(ppe.getText(true, notes, comments));
    }

    public PowerPointExtractor(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    public PowerPointExtractor(InputStream iStream) throws IOException {
        this(new POIFSFileSystem(iStream));
    }

    public PowerPointExtractor(POIFSFileSystem fs) throws IOException {
        this(new HSLFSlideShow(fs));
    }

    public PowerPointExtractor(DirectoryNode dir, POIFSFileSystem fs) throws IOException {
        this(new HSLFSlideShow(dir, fs));
    }

    public PowerPointExtractor(HSLFSlideShow ss) throws IOException {
        super(ss);
        this._hslfshow = ss;
        this._show = new SlideShow(this._hslfshow);
        this._slides = this._show.getSlides();
    }

    public void setSlidesByDefault(boolean slidesByDefault) {
        this.slidesByDefault = slidesByDefault;
    }

    public void setNotesByDefault(boolean notesByDefault) {
        this.notesByDefault = notesByDefault;
    }

    public void setCommentsByDefault(boolean commentsByDefault) {
        this.commentsByDefault = commentsByDefault;
    }

    public String getText() {
        return this.getText(this.slidesByDefault, this.notesByDefault, this.commentsByDefault);
    }

    public String getNotes() {
        return this.getText(false, true);
    }

    public String getText(boolean getSlideText, boolean getNoteText) {
        return this.getText(getSlideText, getNoteText, this.commentsByDefault);
    }

    public String getText(boolean getSlideText, boolean getNoteText, boolean getCommentText) {
        StringBuffer ret = new StringBuffer();
        if (getSlideText) {
            for (int i = 0; i < this._slides.length; ++i) {
                Slide slide = this._slides[i];
                HeadersFooters hf = slide.getHeadersFooters();
                if (hf != null && hf.isHeaderVisible() && hf.getHeaderText() != null) {
                    ret.append(hf.getHeaderText() + "\n");
                }
                TextRun[] runs = slide.getTextRuns();
                for (int j = 0; j < runs.length; ++j) {
                    TextRun run = runs[j];
                    if (run == null) continue;
                    String text = run.getText();
                    ret.append(text);
                    if (text.endsWith("\n")) continue;
                    ret.append("\n");
                }
                if (hf != null && hf.isFooterVisible() && hf.getFooterText() != null) {
                    ret.append(hf.getFooterText() + "\n");
                }
                if (!getCommentText) continue;
                Comment[] comments = slide.getComments();
                for (int j = 0; j < comments.length; ++j) {
                    ret.append(comments[j].getAuthor() + " - " + comments[j].getText() + "\n");
                }
            }
            if (getNoteText) {
                ret.append("\n");
            }
        }
        if (getNoteText) {
            HashSet<Integer> seenNotes = new HashSet<Integer>();
            HeadersFooters hf = this._show.getNotesHeadersFooters();
            for (int i = 0; i < this._slides.length; ++i) {
                TextRun[] runs;
                Integer id;
                Notes notes = this._slides[i].getNotesSheet();
                if (notes == null || seenNotes.contains(id = new Integer(notes._getSheetNumber()))) continue;
                seenNotes.add(id);
                if (hf != null && hf.isHeaderVisible() && hf.getHeaderText() != null) {
                    ret.append(hf.getHeaderText() + "\n");
                }
                if ((runs = notes.getTextRuns()) != null && runs.length > 0) {
                    for (int j = 0; j < runs.length; ++j) {
                        TextRun run = runs[j];
                        String text = run.getText();
                        ret.append(text);
                        if (text.endsWith("\n")) continue;
                        ret.append("\n");
                    }
                }
                if (hf == null || !hf.isFooterVisible() || hf.getFooterText() == null) continue;
                ret.append(hf.getFooterText() + "\n");
            }
        }
        return ret.toString();
    }
}

