/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.observation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.jcr.transaction.TransactionListener;
import org.apache.jackrabbit.webdav.observation.DefaultEventType;
import org.apache.jackrabbit.webdav.observation.EventBundle;
import org.apache.jackrabbit.webdav.observation.EventDiscovery;
import org.apache.jackrabbit.webdav.observation.EventType;
import org.apache.jackrabbit.webdav.observation.Filter;
import org.apache.jackrabbit.webdav.observation.ObservationConstants;
import org.apache.jackrabbit.webdav.observation.ObservationResource;
import org.apache.jackrabbit.webdav.observation.Subscription;
import org.apache.jackrabbit.webdav.observation.SubscriptionInfo;
import org.apache.jackrabbit.webdav.transaction.TransactionResource;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SubscriptionImpl
implements Subscription,
ObservationConstants,
EventListener {
    private static Logger log = LoggerFactory.getLogger(SubscriptionImpl.class);
    private static final long DEFAULT_TIMEOUT = 300000L;
    private static final String EVENT_NODEADDED = "nodeadded";
    private static final String EVENT_NODEREMOVED = "noderemoved";
    private static final String EVENT_PROPERTYADDED = "propertyadded";
    private static final String EVENT_PROPERTYREMOVED = "propertyremoved";
    private static final String EVENT_PROPERTYCHANGED = "propertychanged";
    private static final String EVENT_NODEMOVED = "nodemoved";
    private static final String EVENT_PERSIST = "persist";
    private SubscriptionInfo info;
    private long expirationTime;
    private final DavResourceLocator locator;
    private final String subscriptionId = UUID.randomUUID().toString();
    private final List eventBundles = new ArrayList();
    private final ObservationManager obsMgr;

    public SubscriptionImpl(SubscriptionInfo info, ObservationResource resource) throws DavException {
        this.setInfo(info);
        this.locator = resource.getLocator();
        Session s = JcrDavSession.getRepositorySession(resource.getSession());
        try {
            this.obsMgr = s.getWorkspace().getObservationManager();
        }
        catch (RepositoryException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public Element toXml(Document document) {
        Element subscr = DomUtil.createElement(document, "subscription", NAMESPACE);
        subscr.appendChild(this.info.toXml(document));
        subscr.appendChild(DomUtil.depthToXml(this.info.isDeep(), document));
        subscr.appendChild(DomUtil.timeoutToXml(this.info.getTimeOut(), document));
        if (this.getSubscriptionId() != null) {
            Element id = DomUtil.addChildElement(subscr, "subscriptionid", NAMESPACE);
            id.appendChild(DomUtil.hrefToXml(this.getSubscriptionId(), document));
        }
        return subscr;
    }

    void setInfo(SubscriptionInfo info) {
        this.info = info;
        long timeout = info.getTimeOut();
        if (timeout <= 0L) {
            timeout = 300000L;
        }
        this.expirationTime = System.currentTimeMillis() + timeout;
    }

    int getJcrEventTypes() throws DavException {
        EventType[] eventTypes = this.info.getEventTypes();
        int events = 0;
        for (int i = 0; i < eventTypes.length; ++i) {
            events |= SubscriptionImpl.getJcrEventType(eventTypes[i]);
        }
        return events;
    }

    String[] getUuidFilters() {
        return this.getFilterValues("uuid");
    }

    String[] getNodetypeNameFilters() {
        return this.getFilterValues("nodetype-name");
    }

    private String[] getFilterValues(String filterLocalName) {
        Filter[] filters = this.info.getFilters(filterLocalName, NAMESPACE);
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < filters.length; ++i) {
            String val = filters[i].getValue();
            if (val == null) continue;
            values.add(val);
        }
        return values.size() > 0 ? values.toArray(new String[values.size()]) : null;
    }

    boolean isNoLocal() {
        return this.info.isNoLocal();
    }

    boolean isDeep() {
        return this.info.isDeep();
    }

    DavResourceLocator getLocator() {
        return this.locator;
    }

    boolean isSubscribedToResource(ObservationResource resource) {
        return this.locator.getResourcePath().equals(resource.getResourcePath());
    }

    boolean isExpired() {
        return System.currentTimeMillis() > this.expirationTime;
    }

    synchronized EventDiscovery discoverEvents(long timeout) {
        EventDiscovery ed = new EventDiscovery();
        if (this.eventBundles.isEmpty() && timeout > 0L) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        for (EventBundle eb : this.eventBundles) {
            ed.addEventBundle(eb);
        }
        this.eventBundles.clear();
        return ed;
    }

    TransactionListener createTransactionListener() {
        if (this.info.isNoLocal()) {
            return new TransactionEvent(){

                public void onEvent(EventIterator events) {
                }

                public void beforeCommit(TransactionResource resource, String lockToken) {
                }

                public void afterCommit(TransactionResource resource, String lockToken, boolean success) {
                }
            };
        }
        return new TransactionEvent();
    }

    void suspend() throws DavException {
        try {
            this.obsMgr.removeEventListener(this);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    void resume() throws DavException {
        try {
            this.obsMgr.addEventListener(this, this.getJcrEventTypes(), this.getLocator().getRepositoryPath(), this.isDeep(), this.getUuidFilters(), this.getNodetypeNameFilters(), this.isNoLocal());
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public synchronized void onEvent(EventIterator events) {
        if (!this.isExpired()) {
            this.eventBundles.add(new EventBundleImpl(events));
        } else {
            try {
                this.obsMgr.removeEventListener(this);
            }
            catch (RepositoryException e) {
                log.warn("Exception while unsubscribing: " + e);
            }
        }
        this.notifyAll();
    }

    public static EventType getEventType(int jcrEventType) {
        String localName;
        switch (jcrEventType) {
            case 1: {
                localName = EVENT_NODEADDED;
                break;
            }
            case 2: {
                localName = EVENT_NODEREMOVED;
                break;
            }
            case 4: {
                localName = EVENT_PROPERTYADDED;
                break;
            }
            case 16: {
                localName = EVENT_PROPERTYCHANGED;
                break;
            }
            case 8: {
                localName = EVENT_PROPERTYREMOVED;
                break;
            }
            case 32: {
                localName = EVENT_NODEMOVED;
                break;
            }
            case 64: {
                localName = EVENT_PERSIST;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid JCR event type: " + jcrEventType);
            }
        }
        return DefaultEventType.create(localName, NAMESPACE);
    }

    public static int getJcrEventType(EventType eventType) throws DavException {
        int eType;
        if (eventType == null || !NAMESPACE.equals(eventType.getNamespace())) {
            throw new DavException(422, "Invalid JCR event type: " + eventType + ": Namespace mismatch.");
        }
        String eventName = eventType.getName();
        if (EVENT_NODEADDED.equals(eventName)) {
            eType = 1;
        } else if (EVENT_NODEREMOVED.equals(eventName)) {
            eType = 2;
        } else if (EVENT_PROPERTYADDED.equals(eventName)) {
            eType = 4;
        } else if (EVENT_PROPERTYCHANGED.equals(eventName)) {
            eType = 16;
        } else if (EVENT_PROPERTYREMOVED.equals(eventName)) {
            eType = 8;
        } else if (EVENT_NODEMOVED.equals(eventName)) {
            eType = 32;
        } else if (EVENT_PERSIST.equals(eventName)) {
            eType = 64;
        } else {
            throw new DavException(422, "Invalid event type: " + eventName);
        }
        return eType;
    }

    private class TransactionEvent
    implements EventListener,
    TransactionListener {
        private String transactionId;

        private TransactionEvent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(EventIterator events) {
            String tId = this.transactionId;
            if (tId == null) {
                tId = UUID.randomUUID().toString();
            }
            SubscriptionImpl subscriptionImpl = SubscriptionImpl.this;
            synchronized (subscriptionImpl) {
                SubscriptionImpl.this.eventBundles.add(new EventBundleImpl(events, tId));
                SubscriptionImpl.this.notifyAll();
            }
        }

        public void beforeCommit(TransactionResource resource, String lockToken) {
            try {
                this.transactionId = lockToken;
                SubscriptionImpl.this.obsMgr.addEventListener(this, SubscriptionImpl.this.getJcrEventTypes(), SubscriptionImpl.this.getLocator().getRepositoryPath(), SubscriptionImpl.this.isDeep(), SubscriptionImpl.this.getUuidFilters(), SubscriptionImpl.this.getNodetypeNameFilters(), SubscriptionImpl.this.isNoLocal());
                SubscriptionImpl.this.suspend();
            }
            catch (RepositoryException e) {
                log.warn("Unable to register TransactionListener: " + e);
            }
            catch (DavException e) {
                log.warn("Unable to register TransactionListener: " + e);
            }
        }

        public void afterCommit(TransactionResource resource, String lockToken, boolean success) {
            try {
                SubscriptionImpl.this.resume();
                SubscriptionImpl.this.obsMgr.removeEventListener(this);
            }
            catch (RepositoryException e) {
                log.warn("Unable to remove listener: " + e);
            }
            catch (DavException e) {
                log.warn("Unable to resume Subscription: " + e);
            }
        }
    }

    private class EventBundleImpl
    implements EventBundle {
        private final EventIterator events;
        private final String transactionId;

        private EventBundleImpl(EventIterator events) {
            this(events, (String)null);
        }

        private EventBundleImpl(EventIterator events, String transactionId) {
            this.events = events;
            this.transactionId = transactionId;
        }

        public Element toXml(Document document) {
            Element bundle = DomUtil.createElement(document, "eventbundle", ObservationConstants.NAMESPACE);
            if (this.transactionId != null) {
                DomUtil.setAttribute(bundle, "transactionid", ObservationConstants.NAMESPACE, this.transactionId);
            }
            while (this.events.hasNext()) {
                Event event = this.events.nextEvent();
                Element eventElem = DomUtil.addChildElement(bundle, "event", ObservationConstants.NAMESPACE);
                String eHref = "";
                try {
                    boolean isCollection = event.getType() == 1 || event.getType() == 2;
                    eHref = SubscriptionImpl.this.locator.getFactory().createResourceLocator(SubscriptionImpl.this.locator.getPrefix(), SubscriptionImpl.this.locator.getWorkspacePath(), event.getPath(), false).getHref(isCollection);
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                }
                eventElem.appendChild(DomUtil.hrefToXml(eHref, document));
                Element eType = DomUtil.addChildElement(eventElem, "eventtype", ObservationConstants.NAMESPACE);
                eType.appendChild(SubscriptionImpl.getEventType(event.getType()).toXml(document));
                DomUtil.addChildElement(eventElem, "eventuserid", ObservationConstants.NAMESPACE, event.getUserID());
                try {
                    DomUtil.addChildElement(eventElem, "eventuserdata", ObservationConstants.NAMESPACE, event.getUserData());
                }
                catch (RepositoryException e) {
                    log.error("Internal error while retrieving event user data.", (Object)e.getMessage());
                }
                try {
                    DomUtil.addChildElement(eventElem, "eventdate", ObservationConstants.NAMESPACE, String.valueOf(event.getDate()));
                }
                catch (RepositoryException e) {
                    log.error("Internal error while retrieving event date.", (Object)e.getMessage());
                }
                try {
                    DomUtil.addChildElement(eventElem, "eventidentifier", ObservationConstants.NAMESPACE, event.getIdentifier());
                }
                catch (RepositoryException e) {
                    log.error("Internal error while retrieving event identifier.", (Object)e.getMessage());
                }
                Element info = DomUtil.addChildElement(eventElem, "eventinfo", ObservationConstants.NAMESPACE);
                try {
                    Map m = event.getInfo();
                    Iterator it = m.keySet().iterator();
                    while (it.hasNext()) {
                        String key = it.next().toString();
                        Object value = m.get(key);
                        if (value != null) {
                            DomUtil.addChildElement(info, key, Namespace.EMPTY_NAMESPACE, value.toString());
                            continue;
                        }
                        DomUtil.addChildElement(info, key, Namespace.EMPTY_NAMESPACE);
                    }
                }
                catch (RepositoryException e) {
                    log.error("Internal error while retrieving event info.", (Object)e.getMessage());
                }
            }
            return bundle;
        }
    }
}

