/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.nodetype;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.jackrabbit.commons.iterator.NodeTypeIteratorAdapter;
import org.apache.jackrabbit.spi.commons.nodetype.AbstractNodeTypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeType
implements NodeType {
    private static final Logger log = LoggerFactory.getLogger(AbstractNodeType.class);
    private final AbstractNodeTypeManager ntMgr;

    public AbstractNodeType(AbstractNodeTypeManager ntMgr) {
        this.ntMgr = ntMgr;
    }

    public NodeTypeIterator getDeclaredSubtypes() {
        return this.getSubtypes(true);
    }

    public NodeTypeIterator getSubtypes() {
        return this.getSubtypes(false);
    }

    public NodeTypeIterator getSubtypes(boolean directOnly) {
        NodeTypeIterator iter;
        try {
            iter = this.ntMgr.getAllNodeTypes();
        }
        catch (RepositoryException e) {
            log.error("failed to retrieve registered node types", e);
            return NodeTypeIteratorAdapter.EMPTY;
        }
        ArrayList<NodeType> result = new ArrayList<NodeType>();
        String thisName = this.getName();
        block2: while (iter.hasNext()) {
            NodeType nt = iter.nextNodeType();
            if (nt.getName().equals(thisName)) continue;
            if (directOnly) {
                String[] names = nt.getDeclaredSupertypeNames();
                for (int i = 0; i < names.length; ++i) {
                    if (!names[i].equals(thisName)) continue;
                    result.add(nt);
                    continue block2;
                }
                continue;
            }
            if (!nt.isNodeType(thisName)) continue;
            result.add(nt);
        }
        return new NodeTypeIteratorAdapter(result);
    }
}

