/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.commons.QItemDefinitionImpl;

public class QPropertyDefinitionImpl
extends QItemDefinitionImpl
implements QPropertyDefinition {
    private final int requiredType;
    private final QValueConstraint[] valueConstraints;
    private final QValue[] defaultValues;
    private final boolean multiple;
    private final String[] availableQueryOperators;
    private final boolean fullTextSearchable;
    private final boolean queryOrderable;

    public QPropertyDefinitionImpl(QPropertyDefinition propDef) {
        this(propDef.getName(), propDef.getDeclaringNodeType(), propDef.isAutoCreated(), propDef.isMandatory(), propDef.getOnParentVersion(), propDef.isProtected(), propDef.getDefaultValues(), propDef.isMultiple(), propDef.getRequiredType(), propDef.getValueConstraints(), propDef.getAvailableQueryOperators(), propDef.isFullTextSearchable(), propDef.isQueryOrderable());
    }

    public QPropertyDefinitionImpl(Name name, Name declaringNodeType, boolean isAutoCreated, boolean isMandatory, int onParentVersion, boolean isProtected, QValue[] defaultValues, boolean isMultiple, int requiredType, QValueConstraint[] valueConstraints, String[] availableQueryOperators, boolean isFullTextSearchable, boolean isQueryOrderable) {
        super(name, declaringNodeType, isAutoCreated, isMandatory, onParentVersion, isProtected);
        if (valueConstraints == null) {
            throw new NullPointerException("valueConstraints");
        }
        this.defaultValues = defaultValues;
        this.multiple = isMultiple;
        this.requiredType = requiredType;
        this.valueConstraints = valueConstraints;
        this.availableQueryOperators = availableQueryOperators;
        this.fullTextSearchable = isFullTextSearchable;
        this.queryOrderable = isQueryOrderable;
    }

    public int getRequiredType() {
        return this.requiredType;
    }

    public QValueConstraint[] getValueConstraints() {
        return this.valueConstraints;
    }

    public QValue[] getDefaultValues() {
        return this.defaultValues;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public String[] getAvailableQueryOperators() {
        return this.availableQueryOperators;
    }

    public boolean isFullTextSearchable() {
        return this.fullTextSearchable;
    }

    public boolean isQueryOrderable() {
        return this.queryOrderable;
    }

    public boolean definesNode() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QPropertyDefinition) {
            QPropertyDefinition other = (QPropertyDefinition)obj;
            return super.equals(obj) && this.requiredType == other.getRequiredType() && this.multiple == other.isMultiple() && this.fullTextSearchable == other.isFullTextSearchable() && this.queryOrderable == other.isQueryOrderable() && Arrays.equals(this.valueConstraints, other.getValueConstraints()) && Arrays.equals(this.defaultValues, other.getDefaultValues()) && Arrays.equals(this.availableQueryOperators, other.getAvailableQueryOperators());
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getDeclaringNodeType().toString());
            sb.append('/');
            if (this.definesResidual()) {
                sb.append('*');
            } else {
                sb.append(this.getName().toString());
            }
            sb.append('/');
            sb.append(this.requiredType);
            sb.append('/');
            sb.append(this.multiple ? 1 : 0);
            sb.append('/');
            sb.append(this.fullTextSearchable ? 1 : 0);
            sb.append('/');
            sb.append(this.queryOrderable ? 1 : 0);
            sb.append('/');
            HashSet<String> s = new HashSet<String>();
            String[] names = this.getAvailableQueryOperators();
            s.addAll(Arrays.asList(names));
            sb.append(((Object)s).toString());
            this.hashCode = sb.toString().hashCode();
        }
        return this.hashCode;
    }
}

