/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.QItemDefinitionImpl;
import org.apache.jackrabbit.spi.commons.QNodeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.QPropertyDefinitionImpl;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.nodetype.constraint.ValueConstraint;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;

public class QNodeTypeDefinitionImpl
implements QNodeTypeDefinition,
Serializable {
    private final Name name;
    private final Name[] supertypes;
    private final Name[] supportedMixins;
    private final boolean isMixin;
    private final boolean isAbstract;
    private final boolean isQueryable;
    private final boolean hasOrderableChildNodes;
    private final Name primaryItemName;
    private final QPropertyDefinition[] propertyDefs;
    private final QNodeDefinition[] childNodeDefs;
    private transient Collection<Name> dependencies;

    public QNodeTypeDefinitionImpl(QNodeTypeDefinition nt) {
        this(nt.getName(), nt.getSupertypes(), nt.getSupportedMixinTypes(), nt.isMixin(), nt.isAbstract(), nt.isQueryable(), nt.hasOrderableChildNodes(), nt.getPrimaryItemName(), nt.getPropertyDefs(), nt.getChildNodeDefs());
    }

    public QNodeTypeDefinitionImpl(Name name, Name[] supertypes, Name[] supportedMixins, boolean isMixin, boolean isAbstract, boolean isQueryable, boolean hasOrderableChildNodes, Name primaryItemName, QPropertyDefinition[] declaredPropDefs, QNodeDefinition[] declaredNodeDefs) {
        this.name = name;
        this.supertypes = supertypes;
        this.supportedMixins = supportedMixins;
        this.isMixin = isMixin;
        this.isAbstract = isAbstract;
        this.isQueryable = isQueryable;
        this.hasOrderableChildNodes = hasOrderableChildNodes;
        this.primaryItemName = primaryItemName;
        this.propertyDefs = QNodeTypeDefinitionImpl.getSerializablePropertyDefs(declaredPropDefs);
        this.childNodeDefs = QNodeTypeDefinitionImpl.getSerializableNodeDefs(declaredNodeDefs);
    }

    public QNodeTypeDefinitionImpl(NodeTypeDefinition def, NamePathResolver resolver, QValueFactory qValueFactory) throws RepositoryException {
        this(resolver.getQName(def.getName()), def, resolver, qValueFactory);
    }

    private QNodeTypeDefinitionImpl(Name name, NodeTypeDefinition def, NamePathResolver resolver, QValueFactory qValueFactory) throws RepositoryException {
        this(name, QNodeTypeDefinitionImpl.getNames(def.getDeclaredSupertypeNames(), resolver), null, def.isMixin(), def.isAbstract(), def.isQueryable(), def.hasOrderableChildNodes(), def.getPrimaryItemName() == null ? null : resolver.getQName(def.getPrimaryItemName()), QNodeTypeDefinitionImpl.createQPropertyDefinitions(name, def.getDeclaredPropertyDefinitions(), resolver, qValueFactory), QNodeTypeDefinitionImpl.createQNodeDefinitions(name, def.getDeclaredChildNodeDefinitions(), resolver));
    }

    public Name getName() {
        return this.name;
    }

    public Name[] getSupertypes() {
        Name[] sTypes = new Name[this.supertypes.length];
        System.arraycopy(this.supertypes, 0, sTypes, 0, this.supertypes.length);
        return sTypes;
    }

    public boolean isMixin() {
        return this.isMixin;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isQueryable() {
        return this.isQueryable;
    }

    public boolean hasOrderableChildNodes() {
        return this.hasOrderableChildNodes;
    }

    public Name getPrimaryItemName() {
        return this.primaryItemName;
    }

    public QPropertyDefinition[] getPropertyDefs() {
        QPropertyDefinition[] pDefs = new QPropertyDefinition[this.propertyDefs.length];
        System.arraycopy(this.propertyDefs, 0, pDefs, 0, this.propertyDefs.length);
        return pDefs;
    }

    public QNodeDefinition[] getChildNodeDefs() {
        QNodeDefinition[] cnDefs = new QNodeDefinition[this.childNodeDefs.length];
        System.arraycopy(this.childNodeDefs, 0, cnDefs, 0, this.childNodeDefs.length);
        return cnDefs;
    }

    public Collection getDependencies() {
        if (this.dependencies == null) {
            HashSet<Name> deps = new HashSet<Name>();
            deps.addAll(Arrays.asList(this.supertypes));
            for (QNodeDefinition qNodeDefinition : this.childNodeDefs) {
                Name[] ntNames;
                Name ntName = qNodeDefinition.getDefaultPrimaryType();
                if (ntName != null && !this.name.equals(ntName)) {
                    deps.add(ntName);
                }
                for (Name ntName1 : ntNames = qNodeDefinition.getRequiredPrimaryTypes()) {
                    if (ntName1 == null || this.name.equals(ntName1)) continue;
                    deps.add(ntName1);
                }
            }
            for (QItemDefinition qItemDefinition : this.propertyDefs) {
                QValueConstraint[] ca;
                if (qItemDefinition.getRequiredType() != 9 && qItemDefinition.getRequiredType() != 10 || (ca = qItemDefinition.getValueConstraints()) == null) continue;
                for (QValueConstraint aCa : ca) {
                    NameFactory factory = NameFactoryImpl.getInstance();
                    Name ntName = factory.create(aCa.getString());
                    if (this.name.equals(ntName)) continue;
                    deps.add(ntName);
                }
            }
            this.dependencies = Collections.unmodifiableCollection(deps);
        }
        return this.dependencies;
    }

    public Name[] getSupportedMixinTypes() {
        if (this.supportedMixins == null) {
            return null;
        }
        Name[] mixins = new Name[this.supportedMixins.length];
        System.arraycopy(this.supportedMixins, 0, mixins, 0, this.supportedMixins.length);
        return mixins;
    }

    private static QPropertyDefinition[] getSerializablePropertyDefs(QPropertyDefinition[] propDefs) {
        QPropertyDefinition[] serDefs = new QPropertyDefinition[propDefs.length];
        for (int i = 0; i < propDefs.length; ++i) {
            serDefs[i] = propDefs[i] instanceof Serializable ? propDefs[i] : new QPropertyDefinitionImpl(propDefs[i]);
        }
        return serDefs;
    }

    private static QNodeDefinition[] getSerializableNodeDefs(QNodeDefinition[] nodeDefs) {
        QNodeDefinition[] serDefs = new QNodeDefinition[nodeDefs.length];
        for (int i = 0; i < nodeDefs.length; ++i) {
            serDefs[i] = nodeDefs[i] instanceof Serializable ? nodeDefs[i] : new QNodeDefinitionImpl(nodeDefs[i]);
        }
        return serDefs;
    }

    private static Name[] getNames(String[] jcrNames, NamePathResolver resolver) throws NamespaceException, IllegalNameException {
        Name[] names = new Name[jcrNames.length];
        for (int i = 0; i < jcrNames.length; ++i) {
            names[i] = resolver.getQName(jcrNames[i]);
        }
        return names;
    }

    private static QPropertyDefinition[] createQPropertyDefinitions(Name declName, PropertyDefinition[] pds, NamePathResolver resolver, QValueFactory qValueFactory) throws RepositoryException {
        if (pds == null || pds.length == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        QPropertyDefinition[] declaredPropDefs = new QPropertyDefinition[pds.length];
        for (int i = 0; i < pds.length; ++i) {
            Name name;
            PropertyDefinition propDef = pds[i];
            Name name2 = name = propDef.getName().equals(QItemDefinitionImpl.ANY_NAME.getLocalName()) ? QItemDefinitionImpl.ANY_NAME : resolver.getQName(propDef.getName());
            if (propDef.getDeclaringNodeType() != null && !declName.equals(resolver.getQName(propDef.getDeclaringNodeType().getName()))) {
                throw new RepositoryException("Property definition specified invalid declaring nodetype: " + propDef.getDeclaringNodeType().getName() + ", but should be " + declName);
            }
            QValue[] defVls = propDef.getDefaultValues() == null ? QValue.EMPTY_ARRAY : ValueFormat.getQValues(propDef.getDefaultValues(), resolver, qValueFactory);
            String[] jcrConstraints = propDef.getValueConstraints();
            QValueConstraint[] constraints = QValueConstraint.EMPTY_ARRAY;
            if (jcrConstraints != null && jcrConstraints.length > 0) {
                constraints = new QValueConstraint[jcrConstraints.length];
                for (int j = 0; j < constraints.length; ++j) {
                    constraints[j] = ValueConstraint.create(propDef.getRequiredType(), jcrConstraints[j], resolver);
                }
            }
            declaredPropDefs[i] = new QPropertyDefinitionImpl(name, declName, propDef.isAutoCreated(), propDef.isMandatory(), propDef.getOnParentVersion(), propDef.isProtected(), defVls, propDef.isMultiple(), propDef.getRequiredType(), constraints, propDef.getAvailableQueryOperators(), propDef.isFullTextSearchable(), propDef.isQueryOrderable());
        }
        return declaredPropDefs;
    }

    private static QNodeDefinition[] createQNodeDefinitions(Name declName, NodeDefinition[] nds, NamePathResolver resolver) throws RepositoryException {
        if (nds == null || nds.length == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        QNodeDefinition[] declaredNodeDefs = new QNodeDefinition[nds.length];
        for (int i = 0; i < nds.length; ++i) {
            Name name;
            NodeDefinition nodeDef = nds[i];
            Name name2 = name = nodeDef.getName().equals(QItemDefinitionImpl.ANY_NAME.getLocalName()) ? QItemDefinitionImpl.ANY_NAME : resolver.getQName(nodeDef.getName());
            if (nodeDef.getDeclaringNodeType() != null && !declName.equals(resolver.getQName(nodeDef.getDeclaringNodeType().getName()))) {
                throw new RepositoryException("Childnode definition specified invalid declaring nodetype: " + nodeDef.getDeclaringNodeType().getName() + ", but should be " + declName);
            }
            Name defaultPrimaryType = nodeDef.getDefaultPrimaryTypeName() == null ? null : resolver.getQName(nodeDef.getDefaultPrimaryTypeName());
            Name[] requiredPrimaryTypes = QNodeTypeDefinitionImpl.getNames(nodeDef.getRequiredPrimaryTypeNames(), resolver);
            declaredNodeDefs[i] = new QNodeDefinitionImpl(name, declName, nodeDef.isAutoCreated(), nodeDef.isMandatory(), nodeDef.getOnParentVersion(), nodeDef.isProtected(), defaultPrimaryType, requiredPrimaryTypes, nodeDef.allowsSameNameSiblings());
        }
        return declaredNodeDefs;
    }
}

