/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Item;
import org.apache.jackrabbit.server.io.AbstractExportContext;
import org.apache.jackrabbit.server.io.IOUtil;
import org.apache.jackrabbit.server.io.MimeResolver;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportContextImpl
extends AbstractExportContext {
    private static Logger log = LoggerFactory.getLogger(ExportContextImpl.class);
    private final Map properties = new HashMap();
    private final OutputContext outputCtx;
    private File outFile;
    private OutputStream outStream;

    public ExportContextImpl(Item exportRoot, OutputContext outputCtx) throws IOException {
        this(exportRoot, outputCtx, null);
    }

    public ExportContextImpl(Item exportRoot, OutputContext outputCtx, MimeResolver mimeResolver) throws IOException {
        super(exportRoot, outputCtx != null ? outputCtx.hasStream() : false, null, mimeResolver);
        this.outputCtx = outputCtx;
        if (this.hasStream()) {
            this.outFile = File.createTempFile("__exportcontext", "tmp");
        }
    }

    public OutputStream getOutputStream() {
        this.checkCompleted();
        if (this.hasStream()) {
            try {
                if (this.outStream != null) {
                    this.outStream.close();
                }
                this.outStream = new FileOutputStream(this.outFile);
                return this.outStream;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setContentLanguage(String contentLanguage) {
        this.properties.put("Content-Language", contentLanguage);
    }

    public void setContentLength(long contentLength) {
        this.properties.put("Content-Length", contentLength + "");
    }

    public void setContentType(String mimeType, String encoding) {
        this.properties.put("Content-Type", IOUtil.buildContentType(mimeType, encoding));
    }

    public void setCreationTime(long creationTime) {
    }

    public void setModificationTime(long modificationTime) {
        if (modificationTime <= -1L) {
            modificationTime = new Date().getTime();
        }
        String lastMod = IOUtil.getLastModified(modificationTime);
        this.properties.put("Last-Modified", lastMod);
    }

    public void setETag(String etag) {
        this.properties.put("ETag", etag);
    }

    public void setProperty(Object propertyName, Object propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    public void informCompleted(boolean success) {
        this.checkCompleted();
        this.completed = true;
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (success && this.outputCtx != null) {
            boolean hasContentLength = false;
            for (Object name : this.properties.keySet()) {
                Object value = this.properties.get(name);
                if (name == null || value == null) continue;
                this.outputCtx.setProperty(name.toString(), value.toString());
                hasContentLength = "Content-Length".equals(name.toString());
            }
            if (this.outputCtx.hasStream() && this.outFile != null) {
                OutputStream out = this.outputCtx.getOutputStream();
                try {
                    if (!hasContentLength) {
                        this.outputCtx.setContentLength(this.outFile.length());
                    }
                    FileInputStream in = new FileInputStream(this.outFile);
                    IOUtil.spool(in, out);
                }
                catch (IOException e) {
                    log.error(e.toString());
                }
            }
        }
        if (this.outFile != null) {
            this.outFile.delete();
        }
    }
}

