/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.value;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.rmi.value.SerialValue;
import org.apache.jackrabbit.rmi.value.SerialValueFactory;
import org.apache.jackrabbit.rmi.value.StatefulValue;

final class StatefulValueAdapter
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = -8467636003279312276L;
    private Value delegatee;

    StatefulValueAdapter(Value delegatee) {
        this.delegatee = delegatee;
    }

    public InputStream getStream() throws ValueFormatException, RepositoryException {
        return this.delegatee.getStream();
    }

    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        return this.delegatee.getBoolean();
    }

    public Calendar getDate() throws ValueFormatException, RepositoryException {
        return this.delegatee.getDate();
    }

    public double getDouble() throws ValueFormatException, RepositoryException {
        return this.delegatee.getDouble();
    }

    public long getLong() throws ValueFormatException, RepositoryException {
        return this.delegatee.getLong();
    }

    public String getString() throws ValueFormatException, RepositoryException {
        return this.delegatee.getString();
    }

    public int getType() {
        return this.delegatee.getType();
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.delegatee instanceof StatefulValue || this.delegatee instanceof SerialValue) {
            out.writeObject(this.delegatee);
            return;
        }
        try {
            void var3_4;
            SerialValueFactory factory = SerialValueFactory.getInstance();
            switch (this.getType()) {
                case 2: {
                    StatefulValue toSend = factory.createBinaryValue(this.getStream());
                    break;
                }
                case 6: {
                    StatefulValue toSend = factory.createBooleanValue(this.getBoolean());
                    break;
                }
                case 5: {
                    StatefulValue toSend = factory.createDateValue(this.getDate());
                    break;
                }
                case 4: {
                    StatefulValue toSend = factory.createDoubleValue(this.getDouble());
                    break;
                }
                case 3: {
                    StatefulValue toSend = factory.createLongValue(this.getLong());
                    break;
                }
                case 7: {
                    StatefulValue toSend = factory.createNameValue(this.getString());
                    break;
                }
                case 8: {
                    StatefulValue toSend = factory.createPathValue(this.getString());
                    break;
                }
                case 9: {
                    StatefulValue toSend = factory.createReferenceValue(this.getString());
                    break;
                }
                case 1: {
                    StatefulValue toSend = factory.createStringValue(this.getString());
                    break;
                }
                default: {
                    throw new IOException("Unknown value type");
                }
            }
            this.delegatee = var3_4;
            out.writeObject(var3_4);
        }
        catch (RepositoryException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            this.delegatee = (Value)in.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Cannot load value object class: " + cnfe.getMessage());
        }
    }
}

