/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.UnmarshalException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonMismatchException;
import javax.transaction.xa.Xid;
import org.apache.jackrabbit.rmi.server.ServerXAResource;

public final class ServerXAResource_Skel
implements Skeleton {
    private static final Operation[] operations = new Operation[]{new Operation("void commit(javax.transaction.xa.Xid, boolean)"), new Operation("void end(javax.transaction.xa.Xid, int)"), new Operation("void forget(javax.transaction.xa.Xid)"), new Operation("int getTransactionTimeout()"), new Operation("int prepare(javax.transaction.xa.Xid)"), new Operation("javax.transaction.xa.Xid recover(int)[]"), new Operation("void rollback(javax.transaction.xa.Xid)"), new Operation("boolean setTransactionTimeout(int)"), new Operation("void start(javax.transaction.xa.Xid, int)")};
    private static final long interfaceHash = -6369940648514856204L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(Remote remote, RemoteCall remoteCall, int n, long l) throws Exception {
        if (n < 0) {
            if (l == 8805925169258807420L) {
                n = 0;
            } else if (l == -3872066200181363L) {
                n = 1;
            } else if (l == -5404232821767450048L) {
                n = 2;
            } else if (l == 688134995359098708L) {
                n = 3;
            } else if (l == 7632656116779075837L) {
                n = 4;
            } else if (l == -6625995263666380736L) {
                n = 5;
            } else if (l == -2072786701375952034L) {
                n = 6;
            } else if (l == 8163283085921081293L) {
                n = 7;
            } else {
                if (l != 6143421134238818028L) throw new UnmarshalException("invalid method hash");
                n = 8;
            }
        } else if (l != -6369940648514856204L) {
            throw new SkeletonMismatchException("interface hash mismatch");
        }
        ServerXAResource serverXAResource = (ServerXAResource)remote;
        switch (n) {
            case 0: {
                boolean bl;
                Xid xid;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        xid = (Xid)objectInput.readObject();
                        bl = objectInput.readBoolean();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    Object var10_39 = null;
                }
                catch (Throwable throwable) {
                    Object var10_40 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                serverXAResource.commit(xid, bl);
                try {
                    remoteCall.getResultStream(true);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 1: {
                int n2;
                Xid xid;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        xid = (Xid)objectInput.readObject();
                        n2 = objectInput.readInt();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    Object var10_41 = null;
                }
                catch (Throwable throwable) {
                    Object var10_42 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                serverXAResource.end(xid, n2);
                try {
                    remoteCall.getResultStream(true);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 2: {
                Xid xid;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        xid = (Xid)objectInput.readObject();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    Object var9_62 = null;
                }
                catch (Throwable throwable) {
                    Object var9_63 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                serverXAResource.forget(xid);
                try {
                    remoteCall.getResultStream(true);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 3: {
                remoteCall.releaseInputStream();
                int n3 = serverXAResource.getTransactionTimeout();
                try {
                    ObjectOutput objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeInt(n3);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 4: {
                ObjectOutput objectOutput;
                Xid xid;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        xid = (Xid)objectInput.readObject();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    objectOutput = null;
                }
                catch (Throwable throwable) {
                    Object var9_65 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                int n4 = serverXAResource.prepare(xid);
                try {
                    objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeInt(n4);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 5: {
                ObjectOutput objectOutput;
                int n5;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        n5 = objectInput.readInt();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    objectOutput = null;
                }
                catch (Throwable throwable) {
                    Object var9_68 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                Xid[] xidArray = serverXAResource.recover(n5);
                try {
                    objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeObject(xidArray);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 6: {
                Xid xid;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        xid = (Xid)objectInput.readObject();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    Object var9_70 = null;
                }
                catch (Throwable throwable) {
                    Object var9_71 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                serverXAResource.rollback(xid);
                try {
                    remoteCall.getResultStream(true);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 7: {
                ObjectOutput objectOutput;
                int n6;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        n6 = objectInput.readInt();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    objectOutput = null;
                }
                catch (Throwable throwable) {
                    Object var9_73 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                boolean bl = serverXAResource.setTransactionTimeout(n6);
                try {
                    objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeBoolean(bl);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 8: {
                int n7;
                Xid xid;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        xid = (Xid)objectInput.readObject();
                        n7 = objectInput.readInt();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    Object var10_56 = null;
                }
                catch (Throwable throwable) {
                    Object var10_57 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                serverXAResource.start(xid, n7);
                try {
                    remoteCall.getResultStream(true);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            default: {
                throw new UnmarshalException("invalid method number");
            }
        }
    }

    public Operation[] getOperations() {
        return (Operation[])operations.clone();
    }
}

