/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Set;
import org.apache.jackrabbit.extractor.TextExtractor;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParsingReader;

public class DefaultTextExtractor
implements TextExtractor {
    private static final AutoDetectParser PARSER;
    private static final String[] TYPES;

    public String[] getContentTypes() {
        return TYPES;
    }

    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        Metadata metadata = new Metadata();
        if (type != null && type.trim().length() > 0) {
            metadata.set("Content-Type", type.trim());
        }
        return new ParsingReader(PARSER, stream, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream stream = DefaultTextExtractor.class.getResourceAsStream("tika-config.xml");
        try {
            try {
                PARSER = new AutoDetectParser(new TikaConfig(stream));
                Set<String> types = PARSER.getParsers().keySet();
                TYPES = types.toArray(new String[types.size()]);
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load Tika configuration", e);
        }
    }
}

