/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.ActivityViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.cluster.UpdateEventListener;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.observation.DelegatingObservationDispatcher;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalActivityImpl;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionHistoryImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionManager;
import org.apache.jackrabbit.core.version.InternalVersionManagerBase;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionHistoryInfo;
import org.apache.jackrabbit.core.version.VersionItemStateManager;
import org.apache.jackrabbit.core.version.VersionItemStateProvider;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalVersionManagerImpl
extends InternalVersionManagerBase
implements ItemStateListener,
UpdateEventListener {
    private static Logger log = LoggerFactory.getLogger(InternalVersionManager.class);
    private static final Path SYSTEM_PATH;
    private static final Path HISTORIES_PATH;
    private static final Path ACTIVITIES_PATH;
    private final PersistenceManager pMgr;
    private final FileSystem fs;
    private VersionItemStateManager sharedStateMgr;
    private final VersionItemStateProvider versProvider;
    private final DynamicESCFactory escFactory;
    private final NodeStateEx historyRoot;
    private final NodeStateEx activitiesRoot;
    private final Map<ItemId, InternalVersionItem> versionItems = new ReferenceMap(0, 2);

    public InternalVersionManagerImpl(PersistenceManager pMgr, FileSystem fs, NodeTypeRegistry ntReg, DelegatingObservationDispatcher obsMgr, NodeId systemId, NodeId historiesId, NodeId activitiesId, ItemStateCacheFactory cacheFactory, ISMLocking ismLocking) throws RepositoryException {
        super(ntReg, historiesId, activitiesId);
        try {
            ChangeLog cl;
            PropertyState pt;
            NodeState root;
            this.pMgr = pMgr;
            this.fs = fs;
            this.escFactory = new DynamicESCFactory(obsMgr);
            if (!pMgr.exists(historiesId)) {
                root = pMgr.createNew(historiesId);
                root.setParentId(systemId);
                root.setDefinitionId(ntReg.getEffectiveNodeType(NameConstants.REP_SYSTEM).getApplicableChildNodeDef(NameConstants.JCR_VERSIONSTORAGE, NameConstants.REP_VERSIONSTORAGE, ntReg).getId());
                root.setNodeTypeName(NameConstants.REP_VERSIONSTORAGE);
                pt = pMgr.createNew(new PropertyId(historiesId, NameConstants.JCR_PRIMARYTYPE));
                pt.setDefinitionId(ntReg.getEffectiveNodeType(NameConstants.REP_VERSIONSTORAGE).getApplicablePropertyDef(NameConstants.JCR_PRIMARYTYPE, 7, false).getId());
                pt.setMultiValued(false);
                pt.setType(7);
                pt.setValues(new InternalValue[]{InternalValue.create(NameConstants.REP_VERSIONSTORAGE)});
                root.addPropertyName(pt.getName());
                cl = new ChangeLog();
                cl.added(root);
                cl.added(pt);
                pMgr.store(cl);
            }
            if (!pMgr.exists(activitiesId)) {
                root = pMgr.createNew(activitiesId);
                root.setParentId(systemId);
                root.setDefinitionId(ntReg.getEffectiveNodeType(NameConstants.REP_SYSTEM).getApplicableChildNodeDef(NameConstants.JCR_ACTIVITIES, NameConstants.REP_ACTIVITIES, ntReg).getId());
                root.setNodeTypeName(NameConstants.REP_ACTIVITIES);
                pt = pMgr.createNew(new PropertyId(activitiesId, NameConstants.JCR_PRIMARYTYPE));
                pt.setDefinitionId(ntReg.getEffectiveNodeType(NameConstants.REP_ACTIVITIES).getApplicablePropertyDef(NameConstants.JCR_PRIMARYTYPE, 7, false).getId());
                pt.setMultiValued(false);
                pt.setType(7);
                pt.setValues(new InternalValue[]{InternalValue.create(NameConstants.REP_ACTIVITIES)});
                root.addPropertyName(pt.getName());
                cl = new ChangeLog();
                cl.added(root);
                cl.added(pt);
                pMgr.store(cl);
            }
            this.sharedStateMgr = this.createItemStateManager(pMgr, systemId, ntReg, cacheFactory, ismLocking);
            this.stateMgr = LocalItemStateManager.createInstance(this.sharedStateMgr, this.escFactory, cacheFactory);
            this.stateMgr.addListener(this);
            NodeState nodeState = (NodeState)this.stateMgr.getItemState(historiesId);
            this.historyRoot = new NodeStateEx(this.stateMgr, ntReg, nodeState, NameConstants.JCR_VERSIONSTORAGE);
            nodeState = (NodeState)this.stateMgr.getItemState(activitiesId);
            this.activitiesRoot = new NodeStateEx(this.stateMgr, ntReg, nodeState, NameConstants.JCR_ACTIVITIES);
            this.versProvider = new VersionItemStateProvider(historiesId, activitiesId, this.sharedStateMgr);
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public VirtualItemStateProvider getVirtualItemStateProvider() {
        return this.versProvider;
    }

    public PersistenceManager getPersistenceManager() {
        return this.pMgr;
    }

    @Override
    public void close() throws Exception {
        this.pMgr.close();
        this.fs.close();
    }

    public DynamicESCFactory getEscFactory() {
        return this.escFactory;
    }

    @Override
    protected VersionHistoryInfo createVersionHistory(Session session, final NodeState node, final NodeId copiedFrom) throws RepositoryException {
        NodeStateEx state = (NodeStateEx)this.escFactory.doSourced((SessionImpl)session, new SourcedTarget(){

            public Object run() throws RepositoryException {
                return InternalVersionManagerImpl.this.internalCreateVersionHistory(node, copiedFrom);
            }
        });
        if (state == null) {
            throw new VersionException("History already exists for node " + node.getNodeId());
        }
        Name root = NameConstants.JCR_ROOTVERSION;
        return new VersionHistoryInfo(state.getNodeId(), state.getState().getChildNodeEntry(root, 1).getId());
    }

    @Override
    public NodeId createActivity(Session session, final String title) throws RepositoryException {
        NodeStateEx state = (NodeStateEx)this.escFactory.doSourced((SessionImpl)session, new SourcedTarget(){

            public Object run() throws RepositoryException {
                return InternalVersionManagerImpl.this.internalCreateActivity(title);
            }
        });
        return state.getNodeId();
    }

    @Override
    public void removeActivity(Session session, final NodeId nodeId) throws RepositoryException {
        this.escFactory.doSourced((SessionImpl)session, new SourcedTarget(){

            public Object run() throws RepositoryException {
                InternalActivityImpl act = (InternalActivityImpl)InternalVersionManagerImpl.this.getItem(nodeId);
                InternalVersionManagerImpl.this.internalRemoveActivity(act);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasItem(NodeId id) {
        ISMLocking.ReadLock lock = this.acquireReadLock();
        try {
            boolean bl = this.stateMgr.hasItemState(id);
            return bl;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected InternalVersionItem getItem(NodeId id) throws RepositoryException {
        InternalVersionItem internalVersionItem;
        if (id.equals(this.historiesId)) {
            return null;
        }
        if (id.equals(this.activitiesId)) {
            return null;
        }
        ISMLocking.ReadLock lock = this.acquireReadLock();
        try {
            Map<ItemId, InternalVersionItem> map = this.versionItems;
            synchronized (map) {
                InternalVersionItem item = this.versionItems.get(id);
                if (item == null) {
                    item = this.createInternalVersionItem(id);
                    if (item == null) {
                        InternalVersionItem internalVersionItem2 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 6, 7] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                        lock.release();
                        return internalVersionItem2;
                    }
                    this.versionItems.put(id, item);
                }
                internalVersionItem = item;
            }
        }
        catch (Throwable throwable) {
            lock.release();
            throw throwable;
        }
        lock.release();
        return internalVersionItem;
    }

    @Override
    public NodeId canCheckout(NodeStateEx state, NodeId activityId) throws RepositoryException {
        NodeId baseId = state.getPropertyValue(NameConstants.JCR_BASEVERSION).getNodeId();
        if (activityId != null) {
            NodeId historyId;
            InternalVersionHistory history;
            InternalActivityImpl a;
            InternalVersion version;
            if (this.stateMgr.hasNodeReferences(activityId)) {
                try {
                    NodeReferences refs = this.stateMgr.getNodeReferences(activityId);
                    for (PropertyId id : refs.getReferences()) {
                        if (state.hasNode(id.getParentId())) continue;
                        throw new ActivityViolationException("Unable to checkout. Activity is already used for the same node in another workspace.");
                    }
                }
                catch (ItemStateException e) {
                    throw new RepositoryException("Error during checkout.", e);
                }
            }
            if ((version = (a = (InternalActivityImpl)this.getItem(activityId)).getLatestVersion(history = (InternalVersionHistory)this.getItem(historyId = state.getPropertyValue(NameConstants.JCR_VERSIONHISTORY).getNodeId()))) != null) {
                InternalVersion baseVersion;
                for (baseVersion = (InternalVersion)this.getItem(baseId); baseVersion != null && !baseVersion.getId().equals(version.getId()); baseVersion = baseVersion.getLinearPredecessor()) {
                }
                if (baseVersion == null) {
                    throw new ActivityViolationException("Unable to checkout. Activity is used by another version on a different branch: " + version.getName());
                }
            }
        }
        return baseId;
    }

    @Override
    public InternalVersion checkin(Session session, final NodeStateEx node, final Calendar created) throws RepositoryException {
        return (InternalVersion)this.escFactory.doSourced((SessionImpl)session, new SourcedTarget(){

            public Object run() throws RepositoryException {
                if (node.getEffectiveNodeType().includesNodeType(NameConstants.MIX_VERSIONABLE)) {
                    NodeId histId = node.getPropertyValue(NameConstants.JCR_VERSIONHISTORY).getNodeId();
                    InternalVersionHistoryImpl vh = (InternalVersionHistoryImpl)InternalVersionManagerImpl.this.getVersionHistory(histId);
                    return InternalVersionManagerImpl.this.internalCheckin(vh, node, false, created);
                }
                InternalVersionHistoryImpl vh = (InternalVersionHistoryImpl)InternalVersionManagerImpl.this.getVersionHistoryOfNode(node.getNodeId());
                return InternalVersionManagerImpl.this.internalCheckin(vh, node, true, created);
            }
        });
    }

    @Override
    public void removeVersion(Session session, final InternalVersionHistory history, final Name name) throws VersionException, RepositoryException {
        if (!history.hasVersion(name)) {
            throw new VersionException("Version with name " + name.toString() + " does not exist in this VersionHistory");
        }
        this.escFactory.doSourced((SessionImpl)session, new SourcedTarget(){

            public Object run() throws RepositoryException {
                InternalVersionManagerImpl.this.internalRemoveVersion((InternalVersionHistoryImpl)history, name);
                return null;
            }
        });
    }

    @Override
    public InternalVersion setVersionLabel(Session session, final InternalVersionHistory history, final Name version, final Name label, final boolean move) throws RepositoryException {
        return (InternalVersion)this.escFactory.doSourced((SessionImpl)session, new SourcedTarget(){

            public Object run() throws RepositoryException {
                return InternalVersionManagerImpl.this.setVersionLabel((InternalVersionHistoryImpl)history, version, label, move);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemsUpdated(Collection<InternalVersionItem> items) {
        ISMLocking.ReadLock lock = this.acquireReadLock();
        try {
            Map<ItemId, InternalVersionItem> map = this.versionItems;
            synchronized (map) {
                for (InternalVersionItem item : items) {
                    InternalVersionItem cached = this.versionItems.remove(item.getId());
                    if (cached == null || !(cached instanceof InternalVersionHistoryImpl)) continue;
                    InternalVersionHistoryImpl vh = (InternalVersionHistoryImpl)cached;
                    try {
                        vh.reload();
                        this.versionItems.put(vh.getId(), vh);
                    }
                    catch (RepositoryException e) {
                        log.warn("Unable to update version history: " + e.toString());
                    }
                }
            }
        }
        finally {
            lock.release();
        }
    }

    public void setEventChannel(UpdateEventChannel eventChannel) {
        this.sharedStateMgr.setEventChannel(eventChannel);
        eventChannel.setListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void itemDiscarded(InternalVersionItem item) {
        ISMLocking.ReadLock lock = this.acquireReadLock();
        try {
            this.versionItems.remove(item.getId());
        }
        finally {
            lock.release();
        }
    }

    @Override
    protected boolean hasItemReferences(NodeId id) throws RepositoryException {
        return this.stateMgr.hasNodeReferences(id);
    }

    @Override
    protected NodeStateEx getNodeStateEx(NodeId parentNodeId) throws RepositoryException {
        try {
            NodeState state = (NodeState)this.stateMgr.getItemState(parentNodeId);
            return new NodeStateEx(this.stateMgr, this.ntReg, state, null);
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    protected NodeStateEx getHistoryRoot() {
        return this.historyRoot;
    }

    @Override
    protected NodeStateEx getActivitiesRoot() {
        return this.activitiesRoot;
    }

    protected SharedItemStateManager getSharedStateMgr() {
        return this.sharedStateMgr;
    }

    protected VersionItemStateManager createItemStateManager(PersistenceManager pMgr, NodeId rootId, NodeTypeRegistry ntReg, ItemStateCacheFactory cacheFactory, ISMLocking ismLocking) throws ItemStateException {
        return new VersionItemStateManager(pMgr, rootId, ntReg, cacheFactory, ismLocking);
    }

    @Override
    public void stateCreated(ItemState created) {
    }

    @Override
    public void stateModified(ItemState modified) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateDestroyed(ItemState destroyed) {
        ISMLocking.ReadLock lock = this.acquireReadLock();
        try {
            this.versionItems.remove(destroyed.getId());
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void stateDiscarded(ItemState discarded) {
    }

    @Override
    public void externalUpdate(ChangeLog changes, List<EventState> events, long timestamp, String userData) throws RepositoryException {
        EventStateCollection esc = this.getEscFactory().createEventStateCollection(null);
        esc.addAll(events);
        esc.setTimestamp(timestamp);
        esc.setUserData(userData);
        this.sharedStateMgr.externalUpdate(changes, esc);
    }

    static {
        try {
            PathBuilder builder = new PathBuilder();
            builder.addRoot();
            builder.addLast(NameConstants.JCR_SYSTEM);
            SYSTEM_PATH = builder.getPath();
            builder = new PathBuilder();
            builder.addRoot();
            builder.addLast(NameConstants.JCR_SYSTEM);
            builder.addLast(NameConstants.JCR_VERSIONSTORAGE);
            HISTORIES_PATH = builder.getPath();
            builder = new PathBuilder();
            builder.addRoot();
            builder.addLast(NameConstants.JCR_SYSTEM);
            builder.addLast(NameConstants.JCR_ACTIVITIES);
            ACTIVITIES_PATH = builder.getPath();
        }
        catch (MalformedPathException e) {
            throw new InternalError("Cannot initialize path");
        }
    }

    private abstract class SourcedTarget {
        private SourcedTarget() {
        }

        public abstract Object run() throws RepositoryException;
    }

    public static final class DynamicESCFactory
    implements EventStateCollectionFactory {
        private DelegatingObservationDispatcher obsMgr;
        private SessionImpl source;

        public DynamicESCFactory(DelegatingObservationDispatcher obsMgr) {
            this.obsMgr = obsMgr;
        }

        public synchronized EventStateCollection createEventStateCollection() throws RepositoryException {
            if (this.source == null) {
                throw new RepositoryException("Unknown event source.");
            }
            return this.createEventStateCollection(this.source);
        }

        public EventStateCollection createEventStateCollection(SessionImpl source) {
            return this.obsMgr.createEventStateCollection(source, SYSTEM_PATH);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Object doSourced(SessionImpl eventSource, SourcedTarget runnable) throws RepositoryException {
            this.source = eventSource;
            try {
                Object object = runnable.run();
                return object;
            }
            finally {
                this.source = null;
            }
        }
    }
}

